/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.PureUtilities.DaemonManager;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MemoryMapFileUtil {
    private static final Map<String, MemoryMapFileUtil> INSTANCES = new HashMap<String, MemoryMapFileUtil>();
    private static final int WRITE_DELAY = 250;
    private final String file;
    private DataGrabber grabber;
    private boolean modelDirty = false;
    private boolean fileDirty = false;
    private boolean running = false;
    private long lastWrite = 0L;
    private ExecutorService service;

    public static synchronized MemoryMapFileUtil getInstance(File f, DataGrabber grabber) throws IOException {
        MemoryMapFileUtil mem;
        String s = f.getCanonicalPath();
        if (!INSTANCES.containsKey(s)) {
            mem = new MemoryMapFileUtil(f, grabber);
            INSTANCES.put(s, mem);
        } else {
            mem = INSTANCES.get(s);
        }
        mem.grabber = grabber;
        return mem;
    }

    private MemoryMapFileUtil(File file, DataGrabber grabber) throws IOException {
        this.file = file.getCanonicalPath();
        this.grabber = grabber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void run() {
        try {
            MemoryMapFileUtil memoryMapFileUtil = this;
            // MONITORENTER : memoryMapFileUtil
            this.running = true;
            // MONITOREXIT : memoryMapFileUtil
            while (true) {
                block23: {
                    long lastWriteDelta;
                    if ((lastWriteDelta = System.currentTimeMillis() - this.lastWrite) < 250L) {
                        try {
                            Thread.sleep(lastWriteDelta);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    MemoryMapFileUtil memoryMapFileUtil2 = this;
                    // MONITORENTER : memoryMapFileUtil2
                    if (this.modelDirty || this.fileDirty) break block23;
                    // MONITOREXIT : memoryMapFileUtil2
                    MemoryMapFileUtil memoryMapFileUtil3 = this;
                    // MONITORENTER : memoryMapFileUtil3
                    this.running = false;
                    // MONITOREXIT : memoryMapFileUtil3
                    return;
                }
                try {
                    // MONITOREXIT : memoryMapFileUtil2
                    File permanent = new File(this.file);
                    MemoryMapFileUtil memoryMapFileUtil4 = this;
                    // MONITORENTER : memoryMapFileUtil4
                    byte[] data = this.grabber.getData();
                    this.modelDirty = false;
                    this.fileDirty = true;
                    // MONITOREXIT : memoryMapFileUtil4
                    memoryMapFileUtil4 = this;
                    // MONITORENTER : memoryMapFileUtil4
                    FileUtil.write(data, permanent, 0, true);
                    this.lastWrite = System.currentTimeMillis();
                    this.fileDirty = false;
                    // MONITOREXIT : memoryMapFileUtil4
                }
                catch (IOException ex) {
                    Logger.getLogger(MemoryMapFileUtil.class.getName()).log(Level.SEVERE, null, ex);
                }
                continue;
                break;
            }
        }
        catch (Throwable throwable) {
            MemoryMapFileUtil memoryMapFileUtil = this;
            // MONITORENTER : memoryMapFileUtil
            this.running = false;
            // MONITOREXIT : memoryMapFileUtil
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(final DaemonManager dm) {
        MemoryMapFileUtil memoryMapFileUtil = this;
        synchronized (memoryMapFileUtil) {
            this.fileDirty = true;
            this.modelDirty = true;
            if (!this.running) {
                if (dm != null) {
                    dm.activateThread(null);
                }
                this.getService().submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MemoryMapFileUtil.this.run();
                        }
                        finally {
                            if (dm != null) {
                                dm.deactivateThread(null);
                            }
                        }
                    }
                });
            }
        }
    }

    private synchronized ExecutorService getService() {
        if (this.service == null) {
            this.service = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, "MemoryMapWriter-" + MemoryMapFileUtil.this.file);
                    t.setPriority(1);
                    return t;
                }
            });
        }
        return this.service;
    }

    public static interface DataGrabber {
        public byte[] getData();
    }
}

