/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit;

import com.laytonsmith.abstraction.AbstractionObject;
import com.laytonsmith.abstraction.MCChunk;
import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.MCFireworkEffect;
import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.MCLivingEntity;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.MCWorld;
import com.laytonsmith.abstraction.MCWorldBorder;
import com.laytonsmith.abstraction.blocks.MCBlock;
import com.laytonsmith.abstraction.blocks.MCBlockData;
import com.laytonsmith.abstraction.blocks.MCBlockFace;
import com.laytonsmith.abstraction.blocks.MCMaterial;
import com.laytonsmith.abstraction.bukkit.BukkitConvertor;
import com.laytonsmith.abstraction.bukkit.BukkitMCChunk;
import com.laytonsmith.abstraction.bukkit.BukkitMCLocation;
import com.laytonsmith.abstraction.bukkit.BukkitMCMetadatable;
import com.laytonsmith.abstraction.bukkit.BukkitMCWorldBorder;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCBlock;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCEntity;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCFallingBlock;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCFirework;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCItem;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCLightningStrike;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCLivingEntity;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCPlayer;
import com.laytonsmith.abstraction.entities.MCFallingBlock;
import com.laytonsmith.abstraction.entities.MCFirework;
import com.laytonsmith.abstraction.entities.MCItem;
import com.laytonsmith.abstraction.entities.MCLightningStrike;
import com.laytonsmith.abstraction.enums.MCBiomeType;
import com.laytonsmith.abstraction.enums.MCDifficulty;
import com.laytonsmith.abstraction.enums.MCEffect;
import com.laytonsmith.abstraction.enums.MCEntityType;
import com.laytonsmith.abstraction.enums.MCParticle;
import com.laytonsmith.abstraction.enums.MCSound;
import com.laytonsmith.abstraction.enums.MCSoundCategory;
import com.laytonsmith.abstraction.enums.MCTreeType;
import com.laytonsmith.abstraction.enums.MCVersion;
import com.laytonsmith.abstraction.enums.MCWorldEnvironment;
import com.laytonsmith.abstraction.enums.MCWorldType;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCBiomeType;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCDifficulty;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCEntityType;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCParticle;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCSound;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCSoundCategory;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCTreeType;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCWorldEnvironment;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCWorldType;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CClosure;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.CRE.CREPluginInternalException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.bukkit.Chunk;
import org.bukkit.Difficulty;
import org.bukkit.Effect;
import org.bukkit.FireworkEffect;
import org.bukkit.GameRule;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.metadata.Metadatable;
import org.bukkit.util.Consumer;

public class BukkitMCWorld
extends BukkitMCMetadatable
implements MCWorld {
    World w;

    public BukkitMCWorld(World w) {
        super((Metadatable)w);
        this.w = w;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof MCWorld && this.w.equals((Object)((BukkitMCWorld)o).w);
    }

    @Override
    public int hashCode() {
        return this.w.hashCode();
    }

    @Override
    public String toString() {
        return this.w.toString();
    }

    public BukkitMCWorld(AbstractionObject a) {
        this((World)null);
        if (!(a instanceof MCWorld)) {
            throw new ClassCastException();
        }
        this.w = (World)a.getHandle();
    }

    public World getHandle() {
        return this.w;
    }

    public World __World() {
        return this.w;
    }

    @Override
    public List<MCPlayer> getPlayers() {
        ArrayList<MCPlayer> list = new ArrayList<MCPlayer>();
        for (Player p2 : this.w.getPlayers()) {
            list.add(new BukkitMCPlayer((Entity)p2));
        }
        return list;
    }

    @Override
    public List<MCEntity> getEntities() {
        ArrayList<MCEntity> list = new ArrayList<MCEntity>();
        for (Entity e : this.w.getEntities()) {
            list.add(new BukkitMCEntity(e));
        }
        return list;
    }

    @Override
    public List<MCLivingEntity> getLivingEntities() {
        ArrayList<MCLivingEntity> list = new ArrayList<MCLivingEntity>();
        for (LivingEntity e : this.w.getLivingEntities()) {
            list.add(new BukkitMCLivingEntity((Entity)e));
        }
        return list;
    }

    @Override
    public String getName() {
        return this.w.getName();
    }

    @Override
    public UUID getUniqueID() {
        return this.w.getUID();
    }

    @Override
    public long getSeed() {
        return this.w.getSeed();
    }

    @Override
    public MCDifficulty getDifficulty() {
        return (MCDifficulty)((Object)BukkitMCDifficulty.getConvertor().getAbstractedEnum(this.w.getDifficulty()));
    }

    @Override
    public void setDifficulty(MCDifficulty difficulty) {
        this.w.setDifficulty((Difficulty)BukkitMCDifficulty.getConvertor().getConcreteEnum(difficulty));
    }

    @Override
    public boolean getPVP() {
        return this.w.getPVP();
    }

    @Override
    public void setPVP(boolean pvp) {
        this.w.setPVP(pvp);
    }

    @Override
    public String[] getGameRules() {
        return this.w.getGameRules();
    }

    @Override
    public boolean isGameRule(String gameRule) {
        if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_21_11)) {
            NamespacedKey key = NamespacedKey.fromString((String)gameRule);
            if (key == null) {
                return false;
            }
            return Registry.GAME_RULE.get(key) != null;
        }
        return this.w.isGameRule(gameRule);
    }

    @Override
    public Object getGameRuleValue(String gameRule) {
        GameRule gr = GameRule.getByName((String)gameRule);
        if (gr == null) {
            return null;
        }
        return this.w.getGameRuleValue(gr);
    }

    @Override
    public boolean setGameRuleValue(String gameRule, Object value) {
        GameRule gr = GameRule.getByName((String)gameRule);
        if (gr == null) {
            return false;
        }
        return this.w.setGameRule(gr, value);
    }

    @Override
    public MCWorldBorder getWorldBorder() {
        return new BukkitMCWorldBorder(this.w.getWorldBorder());
    }

    @Override
    public MCWorldEnvironment getEnvironment() {
        return (MCWorldEnvironment)((Object)BukkitMCWorldEnvironment.getConvertor().getAbstractedEnum(this.w.getEnvironment()));
    }

    @Override
    public String getGenerator() {
        ChunkGenerator generator = this.w.getGenerator();
        if (generator == null) {
            return "default";
        }
        return generator.toString();
    }

    @Override
    public MCWorldType getWorldType() {
        return (MCWorldType)((Object)BukkitMCWorldType.getConvertor().getAbstractedEnum(this.w.getWorldType()));
    }

    @Override
    public int getSeaLevel() {
        return this.getHandle().getSeaLevel();
    }

    @Override
    public int getMaxHeight() {
        return this.getHandle().getMaxHeight();
    }

    @Override
    public int getMinHeight() {
        return this.w.getMinHeight();
    }

    @Override
    public MCBlock getBlockAt(int x, int y, int z) {
        return new BukkitMCBlock(this.w.getBlockAt(x, y, z));
    }

    @Override
    public MCEntity spawn(MCLocation l, Class mobType) {
        return BukkitConvertor.BukkitGetCorrectEntity(this.w.spawn(((BukkitMCLocation)l).l, mobType));
    }

    @Override
    public MCEntity spawn(MCLocation l, MCEntityType entType) {
        return BukkitConvertor.BukkitGetCorrectEntity(this.w.spawnEntity(((BukkitMCLocation)l).asLocation(), (EntityType)((BukkitMCEntityType)entType).getConcrete()));
    }

    @Override
    public MCEntity spawn(MCLocation l, MCEntityType.MCVanillaEntityType entityType) {
        return BukkitConvertor.BukkitGetCorrectEntity(this.w.spawnEntity(((BukkitMCLocation)l).asLocation(), (EntityType)MCEntityType.valueOfVanillaType(entityType).getConcrete()));
    }

    @Override
    public MCEntity spawn(MCLocation l, MCEntityType entType, CClosure closure2) {
        Entity entity;
        Location location = (Location)l.getHandle();
        Class entityClass = ((EntityType)entType.getConcrete()).getEntityClass();
        if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_2)) {
            entity = this.w.spawn(location, entityClass, e -> this.beforeSpawn((Entity)e, closure2));
        } else {
            try {
                Method m = this.w.getClass().getMethod("spawn", Location.class, Class.class, Consumer.class);
                entity = (Entity)m.invoke((Object)this.w, location, entityClass, e -> this.beforeSpawn((Entity)e, closure2));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e2) {
                throw new CREPluginInternalException(e2.getMessage(), Target.UNKNOWN, e2);
            }
        }
        return BukkitConvertor.BukkitGetCorrectEntity(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beforeSpawn(Entity entity, CClosure closure2) {
        MCEntity temp = BukkitConvertor.BukkitGetCorrectEntity(entity);
        Static.InjectEntity(temp);
        try {
            closure2.executeCallable(new CString(entity.getUniqueId().toString(), Target.UNKNOWN));
        }
        finally {
            Static.UninjectEntity(temp);
        }
    }

    @Override
    public boolean generateTree(MCLocation l, MCTreeType treeType) {
        return this.w.generateTree(((BukkitMCLocation)l).asLocation(), (TreeType)BukkitMCTreeType.getConvertor().getConcreteEnum(treeType));
    }

    @Override
    public void playEffect(MCLocation l, MCEffect mCEffect, int data, int radius) {
        this.w.playEffect(((BukkitMCLocation)l).l, Effect.valueOf((String)mCEffect.name()), data, radius);
    }

    @Override
    public void playEffect(MCLocation l, MCEffect mcEffect, Object data, int radius) {
        Effect effect = Effect.valueOf((String)mcEffect.name());
        switch (mcEffect) {
            case RECORD_PLAY: 
            case STEP_SOUND: {
                this.w.playEffect((Location)l.getHandle(), effect, ((MCMaterial)data).getHandle(), radius);
                return;
            }
            case SMOKE: 
            case SHOOT_WHITE_SMOKE: {
                this.w.playEffect((Location)l.getHandle(), effect, (Object)BlockFace.valueOf((String)((MCBlockFace)((Object)data)).name()), radius);
                return;
            }
            case PARTICLES_AND_SOUND_BRUSH_BLOCK_COMPLETE: {
                this.w.playEffect((Location)l.getHandle(), effect, ((MCBlockData)data).getHandle(), radius);
                return;
            }
        }
        this.w.playEffect((Location)l.getHandle(), effect, data, radius);
    }

    @Override
    public void spawnParticle(MCLocation l, MCParticle pa, int count, double offsetX, double offsetY, double offsetZ, double velocity, boolean force, Object data) {
        this.w.spawnParticle((Particle)pa.getConcrete(), (Location)l.getHandle(), count, offsetX, offsetY, offsetZ, velocity, ((BukkitMCParticle)pa).getParticleData(l, data), force);
    }

    @Override
    public void playSound(MCLocation l, MCSound sound, MCSoundCategory category, float volume, float pitch, Long seed) {
        SoundCategory cat = (SoundCategory)BukkitMCSoundCategory.getConvertor().getConcreteEnum(category);
        if (cat == null) {
            cat = SoundCategory.MASTER;
        }
        if (seed == null) {
            this.w.playSound((Location)l.getHandle(), (Sound)((BukkitMCSound)sound).getConcrete(), cat, volume, pitch);
        } else {
            this.w.playSound((Location)l.getHandle(), (Sound)((BukkitMCSound)sound).getConcrete(), cat, volume, pitch, seed.longValue());
        }
    }

    @Override
    public void playSound(MCEntity ent, MCSound sound, MCSoundCategory category, float volume, float pitch, Long seed) {
        SoundCategory cat = (SoundCategory)BukkitMCSoundCategory.getConvertor().getConcreteEnum(category);
        if (cat == null) {
            cat = SoundCategory.MASTER;
        }
        if (seed == null) {
            this.w.playSound((Entity)ent.getHandle(), (Sound)((BukkitMCSound)sound).getConcrete(), cat, volume, pitch);
        } else {
            this.w.playSound((Entity)ent.getHandle(), (Sound)((BukkitMCSound)sound).getConcrete(), cat, volume, pitch, seed.longValue());
        }
    }

    @Override
    public void playSound(MCEntity ent, String sound, MCSoundCategory category, float volume, float pitch, Long seed) {
        SoundCategory cat = (SoundCategory)BukkitMCSoundCategory.getConvertor().getConcreteEnum(category);
        if (cat == null) {
            cat = SoundCategory.MASTER;
        }
        if (seed == null) {
            this.w.playSound((Entity)ent.getHandle(), sound, cat, volume, pitch);
        } else {
            this.w.playSound((Entity)ent.getHandle(), sound, cat, volume, pitch, seed.longValue());
        }
    }

    @Override
    public void playSound(MCLocation l, String sound, MCSoundCategory category, float volume, float pitch, Long seed) {
        SoundCategory cat = (SoundCategory)BukkitMCSoundCategory.getConvertor().getConcreteEnum(category);
        if (cat == null) {
            cat = SoundCategory.MASTER;
        }
        if (seed == null) {
            this.w.playSound((Location)l.getHandle(), sound, cat, volume, pitch);
        } else {
            this.w.playSound((Location)l.getHandle(), sound, cat, volume, pitch, seed.longValue());
        }
    }

    @Override
    public MCItem dropItemNaturally(MCLocation l, MCItemStack is) {
        return new BukkitMCItem((Entity)this.w.dropItemNaturally(((BukkitMCLocation)l).l, (ItemStack)is.getHandle()));
    }

    @Override
    public MCItem dropItem(MCLocation l, MCItemStack is) {
        return new BukkitMCItem((Entity)this.w.dropItem(((BukkitMCLocation)l).l, (ItemStack)is.getHandle()));
    }

    @Override
    public MCLightningStrike strikeLightning(MCLocation location) {
        return new BukkitMCLightningStrike((Entity)this.w.strikeLightning(((BukkitMCLocation)location).l));
    }

    @Override
    public MCLightningStrike strikeLightningEffect(MCLocation location) {
        return new BukkitMCLightningStrike((Entity)this.w.strikeLightningEffect(((BukkitMCLocation)location).l));
    }

    @Override
    public void setStorm(boolean b) {
        this.w.setStorm(b);
    }

    @Override
    public MCLocation getSpawnLocation() {
        return new BukkitMCLocation(this.w.getSpawnLocation());
    }

    @Override
    public void refreshChunk(int x, int z) {
        this.w.refreshChunk(x, z);
    }

    @Override
    public void loadChunk(int x, int z) {
        this.w.loadChunk(x, z);
    }

    @Override
    public void unloadChunk(int x, int z) {
        this.w.unloadChunk(x, z);
    }

    @Override
    public boolean isChunkForceLoaded(int x, int z) {
        return this.w.isChunkForceLoaded(x, z);
    }

    @Override
    public void setChunkForceLoaded(int x, int z, boolean forced) {
        this.w.setChunkForceLoaded(x, z, forced);
    }

    @Override
    public MCChunk[] getForceLoadedChunks() {
        Collection chunks = this.w.getForceLoadedChunks();
        MCChunk[] mcChunks = new MCChunk[chunks.size()];
        int i = 0;
        for (Chunk c : chunks) {
            mcChunks[i++] = new BukkitMCChunk(c);
        }
        return mcChunks;
    }

    @Override
    public void setTime(long time2) {
        this.w.setTime(time2);
    }

    @Override
    public long getTime() {
        return this.w.getTime();
    }

    @Override
    public void setFullTime(long time2) {
        this.w.setFullTime(time2);
    }

    @Override
    public long getFullTime() {
        return this.w.getFullTime();
    }

    @Override
    public MCBiomeType getBiome(MCLocation location) {
        return BukkitMCBiomeType.valueOfConcrete(this.w.getBiome((Location)location.getHandle()));
    }

    @Override
    public void setBiome(int x, int z, MCBiomeType type) {
        this.w.setBiome(x, z, (Biome)((BukkitMCBiomeType)type).getConcrete());
    }

    @Override
    public void setBiome(MCLocation location, MCBiomeType type) {
        this.w.setBiome((Location)location.getHandle(), (Biome)((BukkitMCBiomeType)type).getConcrete());
    }

    @Override
    public MCBlock getHighestBlockAt(int x, int z) {
        return new BukkitMCBlock(this.w.getHighestBlockAt(x, z, HeightMap.WORLD_SURFACE));
    }

    @Override
    public boolean explosion(MCLocation location, float size, boolean safe, boolean fire, MCEntity source) {
        Location loc = (Location)location.getHandle();
        Entity src = null;
        if (source != null) {
            src = (Entity)source.getHandle();
        }
        return this.w.createExplosion(loc, size, fire, !safe, src);
    }

    @Override
    public void setSpawnLocation(int x, int y, int z) {
        this.w.setSpawnLocation(x, y, z);
    }

    @Override
    public void setSpawnLocation(MCLocation location) {
        Location loc = (Location)location.getHandle();
        loc.setYaw(Location.normalizeYaw((float)loc.getYaw()));
        this.w.setSpawnLocation(loc);
    }

    @Override
    public boolean exists() {
        try {
            this.w.getName();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isAutoSave() {
        return this.w.isAutoSave();
    }

    @Override
    public void setAutoSave(boolean autoSave) {
        this.w.setAutoSave(autoSave);
    }

    @Override
    public MCFallingBlock spawnFallingBlock(MCLocation loc, MCBlockData data) {
        return new BukkitMCFallingBlock((Entity)this.w.spawnFallingBlock((Location)loc.getHandle(), (BlockData)data.getHandle()));
    }

    @Override
    public MCFirework launchFirework(MCLocation l, int strength, List<MCFireworkEffect> effects) {
        Firework firework = (Firework)this.w.spawn(((BukkitMCLocation)l).asLocation(), Firework.class);
        FireworkMeta meta = firework.getFireworkMeta();
        meta.setPower(Math.max(strength, 0));
        for (MCFireworkEffect effect : effects) {
            meta.addEffect((FireworkEffect)effect.getHandle());
        }
        firework.setFireworkMeta(meta);
        if (strength < 0) {
            firework.detonate();
        }
        return new BukkitMCFirework((Entity)firework);
    }

    @Override
    public boolean regenerateChunk(int x, int z) {
        return this.w.regenerateChunk(x, z);
    }

    @Override
    public MCChunk getChunkAt(int x, int z) {
        return new BukkitMCChunk(this.w.getChunkAt(x, z));
    }

    @Override
    public MCChunk getChunkAt(MCBlock b) {
        return new BukkitMCChunk(this.w.getChunkAt(((BukkitMCBlock)b).__Block()));
    }

    @Override
    public MCChunk getChunkAt(MCLocation l) {
        return new BukkitMCChunk(this.w.getChunkAt(((BukkitMCLocation)l).asLocation()));
    }

    @Override
    public MCChunk[] getLoadedChunks() {
        Chunk[] chunks = this.w.getLoadedChunks();
        MCChunk[] mcChunks = new MCChunk[chunks.length];
        for (int i = 0; i < chunks.length; ++i) {
            mcChunks[i] = new BukkitMCChunk(chunks[i]);
        }
        return mcChunks;
    }

    @Override
    public boolean isChunkLoaded(int x, int z) {
        return this.w.isChunkLoaded(x, z);
    }

    @Override
    public void setThundering(boolean b) {
        this.w.setThundering(b);
    }

    @Override
    public void setWeatherDuration(int time2) {
        this.w.setWeatherDuration(time2);
    }

    @Override
    public void setThunderDuration(int time2) {
        this.w.setThunderDuration(time2);
    }

    @Override
    public void setClearWeatherDuration(int time2) {
        this.w.setClearWeatherDuration(time2);
    }

    @Override
    public boolean isStorming() {
        return this.w.hasStorm();
    }

    @Override
    public boolean isThundering() {
        return this.w.isThundering();
    }

    @Override
    public void save() {
        this.w.save();
    }

    @Override
    public void setKeepSpawnInMemory(boolean keepLoaded) {
        try {
            this.w.setKeepSpawnInMemory(keepLoaded);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }
}

