/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs.generics;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.Either;
import com.laytonsmith.PureUtilities.ObjectHelpers;
import com.laytonsmith.PureUtilities.Pair;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.LeftHandSideType;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.constructs.generics.ConstraintValidator;
import com.laytonsmith.core.constructs.generics.Constraints;
import com.laytonsmith.core.constructs.generics.GenericDeclaration;
import com.laytonsmith.core.constructs.generics.LeftHandGenericUseParameter;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CREGenericConstraintException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class LeftHandGenericUse {
    @ObjectHelpers.StandardField
    private final List<LeftHandGenericUseParameter> parameters;

    private static void ValidateCount(int inputParameters, CClassType forType, Target t) {
        GenericDeclaration declaration = forType.getGenericDeclaration();
        List<Constraints> constraints = declaration.getConstraints();
        if (declaration.getParameterCount() != inputParameters) {
            if (!constraints.isEmpty() && constraints.get(constraints.size() - 1).isVariadic() && inputParameters >= constraints.size() - 1) {
                return;
            }
            throw new CREGenericConstraintException(forType.getSimpleName() + " expects " + StringUtils.PluralTemplateHelper(forType.getGenericDeclaration().getParameterCount(), "%d parameter", "%d parameters") + " but " + StringUtils.PluralTemplateHelper(inputParameters, "only %1 was found.", "%d were found."), t);
        }
    }

    public LeftHandGenericUse(CClassType forType, Target t, Environment env, Constraints ... constraints) {
        LeftHandGenericUse.ValidateCount(constraints.length, forType, t);
        ConstraintValidator.ValidateLHS(t, forType, Arrays.asList(constraints), env);
        this.parameters = new ArrayList<LeftHandGenericUseParameter>();
        for (Constraints c : constraints) {
            this.parameters.add(new LeftHandGenericUseParameter(Either.left(c)));
        }
    }

    public LeftHandGenericUse(CClassType forType, Target t, Environment env, Pair<String, Constraints> ... typenames) {
        LeftHandGenericUse.ValidateCount(typenames.length, forType, t);
        ConstraintValidator.ValidateLHS(t, forType, Arrays.asList(typenames).stream().map(item -> (Constraints)item.getValue()).collect(Collectors.toList()), env);
        this.parameters = new ArrayList<LeftHandGenericUseParameter>();
        for (Pair<String, Constraints> typename : typenames) {
            this.parameters.add(new LeftHandGenericUseParameter(Either.right(typename)));
        }
    }

    public LeftHandGenericUse(CClassType forType, Target t, Environment env, Either<Constraints, Pair<String, Constraints>> ... parameters) {
        LeftHandGenericUse.ValidateCount(parameters.length, forType, t);
        ArrayList<Constraints> constraints = new ArrayList<Constraints>();
        for (Either<Constraints, Pair<String, Constraints>> param : parameters) {
            Constraints c = param.hasLeft() ? param.getLeft().get() : param.getRight().get().getValue();
            constraints.add(c);
        }
        ConstraintValidator.ValidateLHS(t, forType, constraints, env);
        this.parameters = new ArrayList<LeftHandGenericUseParameter>();
        for (Either<Constraints, Pair<String, Constraints>> param : parameters) {
            this.parameters.add(new LeftHandGenericUseParameter(param));
        }
    }

    public LeftHandGenericUse(CClassType forType, Target t, Environment env, LeftHandGenericUseParameter ... parameters) {
        this(forType, t, env, (Either[])Arrays.asList(parameters).stream().map(item -> item.getValue()).collect(Collectors.toList()).toArray(Either[]::new));
    }

    public LeftHandGenericUse(CClassType forType, Target t, Environment env, List<LeftHandGenericUseParameter> parameters) {
        this(forType, t, env, (LeftHandGenericUseParameter[])parameters.toArray(LeftHandGenericUseParameter[]::new));
    }

    public static LeftHandGenericUse forNativeParameters(CClassType forType, LeftHandGenericUseParameter ... parameters) {
        return new LeftHandGenericUse(forType, Target.UNKNOWN, null, parameters);
    }

    public boolean equals(Object that) {
        return ObjectHelpers.DoEquals(this, that);
    }

    public int hashCode() {
        return ObjectHelpers.DoHashCode(this);
    }

    public List<LeftHandGenericUseParameter> getParameters() {
        return new ArrayList<LeftHandGenericUseParameter>(this.parameters);
    }

    public List<Constraints> getConstraints() {
        ArrayList<Constraints> constraints = new ArrayList<Constraints>();
        for (LeftHandGenericUseParameter param : this.parameters) {
            constraints.add(param.getConstraints());
        }
        return constraints;
    }

    public boolean isTypename(int parameterPlace) {
        return this.parameters.get(parameterPlace).getValue().hasRight();
    }

    public boolean hasTypename() {
        for (LeftHandGenericUseParameter param : this.parameters) {
            if (!param.getValue().hasRight()) continue;
            return true;
        }
        return false;
    }

    public String toSimpleString() {
        StringBuilder b = new StringBuilder();
        boolean doComma = false;
        for (LeftHandGenericUseParameter cc : this.parameters) {
            if (doComma) {
                b.append(", ");
            }
            doComma = true;
            b.append(cc.toSimpleString());
        }
        return b.toString();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        boolean doComma = false;
        for (LeftHandGenericUseParameter cc : this.parameters) {
            if (doComma) {
                b.append(", ");
            }
            doComma = true;
            b.append(cc.toString());
        }
        return b.toString();
    }

    public boolean isWithinBounds(Environment env, LeftHandSideType ... types) {
        if (this.getConstraints().size() != types.length) {
            return false;
        }
        for (int i = 0; i < this.getConstraints().size(); ++i) {
            LeftHandSideType type;
            Constraints lhs = this.parameters.get(i).getConstraints();
            if (lhs.withinBounds(type = types[i], env)) continue;
            return false;
        }
        return true;
    }

    public boolean isWithinBounds(Environment env, LeftHandGenericUse presumedSubtype) {
        boolean isVariadic;
        if (presumedSubtype == null) {
            return false;
        }
        List<Constraints> checkIfTheseConstraints = presumedSubtype.getConstraints();
        List<Constraints> areWithinBoundsOfThese = this.getConstraints();
        boolean bl = isVariadic = !areWithinBoundsOfThese.isEmpty() && areWithinBoundsOfThese.get(areWithinBoundsOfThese.size() - 1).isVariadic();
        if (isVariadic && checkIfTheseConstraints.size() < areWithinBoundsOfThese.size() - 1 || !isVariadic && checkIfTheseConstraints.size() != areWithinBoundsOfThese.size()) {
            return false;
        }
        for (int i = 0; i < Math.max(checkIfTheseConstraints.size(), areWithinBoundsOfThese.size()); ++i) {
            ArrayList<String> errors;
            Constraints lhs;
            Constraints definition = areWithinBoundsOfThese.get(Math.min(i, areWithinBoundsOfThese.size() - 1));
            if (definition.withinBounds(lhs = checkIfTheseConstraints.get(Math.min(i, checkIfTheseConstraints.size() - 1)), errors = new ArrayList<String>(), env)) continue;
            return false;
        }
        return true;
    }
}

