/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.persistence;

import com.laytonsmith.PureUtilities.DaemonManager;
import com.laytonsmith.annotations.MustUseOverride;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.SimpleDocumentation;
import com.laytonsmith.persistence.DataSourceException;
import com.laytonsmith.persistence.ReadOnlyException;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

@MustUseOverride
public interface DataSource
extends SimpleDocumentation {
    public Set<String[]> keySet(String[] var1) throws DataSourceException;

    public Set<String> stringKeySet(String[] var1) throws DataSourceException;

    public Set<String[]> getNamespace(String[] var1) throws DataSourceException;

    public String get(String[] var1) throws DataSourceException;

    public Map<String[], String> getValues(String[] var1) throws DataSourceException;

    public boolean set(DaemonManager var1, String[] var2, String var3) throws ReadOnlyException, DataSourceException, IOException, IllegalArgumentException;

    public void populate() throws DataSourceException;

    public void addModifier(DataSourceModifier var1);

    public EnumSet<DataSourceModifier> implicitModifiers();

    public EnumSet<DataSourceModifier> invalidModifiers();

    public Set<DataSourceModifier> getModifiers();

    public boolean hasModifier(DataSourceModifier var1);

    public boolean hasKey(String[] var1) throws DataSourceException;

    public void clearKey(DaemonManager var1, String[] var2) throws DataSourceException, ReadOnlyException, IOException;

    default public void clearDatabase(DaemonManager dm) throws DataSourceException, ReadOnlyException, IOException {
    }

    public void startTransaction(DaemonManager var1);

    public void stopTransaction(DaemonManager var1, boolean var2) throws DataSourceException, IOException;

    public void disconnect() throws DataSourceException;

    public static enum DataSourceModifier implements SimpleDocumentation
    {
        READONLY("Makes the connection read-only. That is to say, calls to store_data() on the keys mapped to this data source will always fail.", MSVersion.V3_3_1),
        TRANSIENT("The data from this source is not cached. Note that for file based data sources, this makes it incredibly inefficient for large data sources, but makes it possible for multiple things to read and write to a source at the same time. If the connection is not read-only, a lock file will be created while the file is being written to (which will be the filename with .lock appended), which should be respected by other applications to prevent corruption. During read/write operations, if the lock file exists, the call to retrieve that data will block until the lock file goes away. File based connections that are NOT transient are loaded up at startup, and only writes require file system access from that point on. It is assumed that nothing else will be editing the data source, and so data is not re-read again, which means that leaving off the transient flag makes connections much more efficient. Database driven connections are always transient. ", MSVersion.V3_3_1),
        HTTP("Makes the connection source be retrieved via http instead of assuming a local file. Connections via http are always read-only. If the connection is also transient, a call to get_value() cannot be used in synchronous mode, and will fail if async mode is not used. ", MSVersion.V3_3_1),
        HTTPS("Makes the connection source be retrieved via https instead of assuming a local file. Connections via http are always read-only. If the connection is also transient, a call to get_value() cannot be used in synchronous mode, and will fail if async mode is not used. ", MSVersion.V3_3_1),
        ASYNC("Forces retrievals to this connection to require asyncronous usage. This is handy if an otherwise blocking data source has gotten too large to allow synchonous connections, or if you are using a medium/large data source transiently.", MSVersion.V3_3_1),
        PRETTYPRINT("For text based files, where it is applicable and possible, if there is a way to \"Pretty Print\" the data, do so. This usually comes at the cost of file size, but makes it easier to read in a text editor. For some data sources, this is not possible, due to the file layout requirements of the protocol itself.", MSVersion.V3_3_1),
        SSH("Retrieves the file via SSH. This cannot be used in combination with the HTTP or HTTPS flags. The file path must match the syntax used by SCP connections, for instance: ssh:yml://user@host:/path/to/file/over/ssh.yml. This will only work with public-key authentication however, since there is no practical way to input your password otherwise. Since this is a remote IO connection, async is implied if this modifier is set.", MSVersion.V3_3_1);

        private final MSVersion since;
        private final String documentation;

        private DataSourceModifier(String documentation, MSVersion since) {
            this.documentation = documentation;
            this.since = since;
        }

        @Override
        public String getName() {
            return this.name().toLowerCase();
        }

        @Override
        public String docs() {
            return this.documentation;
        }

        @Override
        public MSVersion since() {
            return this.since;
        }

        public static boolean isModifier(String scheme) {
            for (DataSourceModifier modifier : DataSourceModifier.values()) {
                if (!modifier.getName().equalsIgnoreCase(scheme)) continue;
                return true;
            }
            return false;
        }

        public static DataSourceModifier getModifier(String scheme) {
            return DataSourceModifier.valueOf(scheme.toUpperCase());
        }
    }
}

