/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.enums.bukkit;

import com.laytonsmith.abstraction.enums.MCTrimMaterial;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.constructs.Target;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.inventory.meta.trim.TrimMaterial;

public class BukkitMCTrimMaterial
extends MCTrimMaterial<TrimMaterial> {
    private static final Map<TrimMaterial, MCTrimMaterial> BUKKIT_MAP = new HashMap<TrimMaterial, MCTrimMaterial>();

    public BukkitMCTrimMaterial(MCTrimMaterial.MCVanillaTrimMaterial vanillaTrimMaterial, TrimMaterial trimMaterial) {
        super(vanillaTrimMaterial, trimMaterial);
    }

    @Override
    public String name() {
        if (this.getAbstracted() == MCTrimMaterial.MCVanillaTrimMaterial.UNKNOWN) {
            ((TrimMaterial)this.getConcrete()).getKey().getKey().toUpperCase();
        }
        return ((MCTrimMaterial.MCVanillaTrimMaterial)((Object)this.getAbstracted())).name();
    }

    public static MCTrimMaterial valueOfConcrete(TrimMaterial test) {
        MCTrimMaterial trimMaterial = BUKKIT_MAP.get(test);
        if (trimMaterial == null) {
            MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.GENERAL, "Bukkit Trim Material missing in BUKKIT_MAP: " + test, Target.UNKNOWN);
            return new BukkitMCTrimMaterial(MCTrimMaterial.MCVanillaTrimMaterial.UNKNOWN, test);
        }
        return trimMaterial;
    }

    public static void build() {
        TrimMaterial trimMaterial;
        for (MCTrimMaterial.MCVanillaTrimMaterial mCVanillaTrimMaterial : MCTrimMaterial.MCVanillaTrimMaterial.values()) {
            if (mCVanillaTrimMaterial == MCTrimMaterial.MCVanillaTrimMaterial.UNKNOWN) continue;
            try {
                trimMaterial = BukkitMCTrimMaterial.getBukkitType(mCVanillaTrimMaterial);
            }
            catch (IllegalAccessException | NoSuchFieldException ex) {
                MSLog.GetLogger().w(MSLog.Tags.RUNTIME, "Could not find a Bukkit trim material type for " + mCVanillaTrimMaterial.name(), Target.UNKNOWN);
                continue;
            }
            BukkitMCTrimMaterial wrapper = new BukkitMCTrimMaterial(mCVanillaTrimMaterial, trimMaterial);
            MAP.put(mCVanillaTrimMaterial.name(), wrapper);
            BUKKIT_MAP.put(trimMaterial, wrapper);
        }
        for (Field field : TrimMaterial.class.getFields()) {
            try {
                trimMaterial = (TrimMaterial)field.get(null);
                if (BUKKIT_MAP.containsKey(trimMaterial)) continue;
                MAP.put(field.getName(), new BukkitMCTrimMaterial(MCTrimMaterial.MCVanillaTrimMaterial.UNKNOWN, trimMaterial));
                BUKKIT_MAP.put(trimMaterial, new BukkitMCTrimMaterial(MCTrimMaterial.MCVanillaTrimMaterial.UNKNOWN, trimMaterial));
            }
            catch (ClassCastException | IllegalAccessException exception) {
                // empty catch block
            }
        }
    }

    private static TrimMaterial getBukkitType(MCTrimMaterial.MCVanillaTrimMaterial v) throws NoSuchFieldException, IllegalAccessException {
        return (TrimMaterial)TrimMaterial.class.getField(v.name()).get(null);
    }
}

