/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.commandhelper;

import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.StaticLayer;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCPlayer;
import com.laytonsmith.abstraction.enums.MCChatColor;
import com.laytonsmith.commandhelper.CommandHelperFileLocations;
import com.laytonsmith.commandhelper.CommandHelperPlugin;
import com.laytonsmith.core.MethodScriptCompiler;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.compiler.TokenStream;
import com.laytonsmith.core.environments.CommandHelperEnvironment;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.environments.RuntimeMode;
import com.laytonsmith.core.environments.StaticRuntimeEnv;
import com.laytonsmith.core.exceptions.CancelCommandException;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import java.io.File;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class CommandHelperInterpreterListener
implements Listener {
    private final Set<String> interpreterMode = Collections.synchronizedSet(new HashSet());
    private final CommandHelperPlugin plugin;
    private Map<String, String> multilineMode = new HashMap<String, String>();

    public boolean isInInterpreterMode(String player2) {
        return this.interpreterMode.contains(player2);
    }

    public CommandHelperInterpreterListener(CommandHelperPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (this.interpreterMode.contains(event.getPlayer().getName())) {
            BukkitMCPlayer p2 = new BukkitMCPlayer((Entity)event.getPlayer());
            event.setCancelled(true);
            StaticLayer.SetFutureRunnable(null, 0L, () -> this.textLine(p2, event.getMessage()));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.interpreterMode.remove(event.getPlayer().getName());
        this.multilineMode.remove(event.getPlayer().getName());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.interpreterMode.contains(event.getPlayer().getName())) {
            BukkitMCPlayer p2 = new BukkitMCPlayer((Entity)event.getPlayer());
            this.textLine(p2, event.getMessage());
            event.setCancelled(true);
        }
    }

    public void textLine(MCPlayer p2, String line) {
        if (line.equals("-")) {
            this.interpreterMode.remove(p2.getName());
            Static.SendMessage(p2, MCChatColor.YELLOW + "Now exiting interpreter mode");
        } else if (line.equals(">>>")) {
            if (this.multilineMode.containsKey(p2.getName())) {
                Static.SendMessage(p2, MCChatColor.RED + "You are already in multiline mode!");
            } else {
                this.multilineMode.put(p2.getName(), "");
                Static.SendMessage(p2, MCChatColor.YELLOW + "You are now in multiline mode. Type <<< on a line by itself to execute.");
                Static.SendMessage(p2, ":" + MCChatColor.GRAY + ">>>");
            }
        } else if (line.equals("<<<")) {
            Static.SendMessage(p2, ":" + MCChatColor.GRAY + "<<<");
            String script = this.multilineMode.get(p2.getName());
            this.multilineMode.remove(p2.getName());
            try {
                this.execute(script, p2);
            }
            catch (ConfigCompileException e) {
                Static.SendMessage(p2, MCChatColor.RED + e.getMessage() + ":" + e.getLineNum());
            }
            catch (ConfigCompileGroupException ex) {
                for (ConfigCompileException e : ex.getList()) {
                    Static.SendMessage(p2, MCChatColor.RED + e.getMessage() + ":" + e.getLineNum());
                }
            }
        } else if (this.multilineMode.containsKey(p2.getName())) {
            this.multilineMode.put(p2.getName(), this.multilineMode.get(p2.getName()) + line + "\n");
            Static.SendMessage(p2, ":" + MCChatColor.GRAY + line);
        } else {
            try {
                this.execute(line, p2);
            }
            catch (ConfigCompileException ex) {
                Static.SendMessage(p2, MCChatColor.RED + ex.getMessage());
            }
            catch (ConfigCompileGroupException e) {
                for (ConfigCompileException ex : e.getList()) {
                    Static.SendMessage(p2, MCChatColor.RED + ex.getMessage());
                }
            }
        }
    }

    public void execute(String script, MCPlayer p2) throws ConfigCompileException, ConfigCompileGroupException {
        TokenStream stream = MethodScriptCompiler.lex(script, null, new File("Interpreter"), true);
        GlobalEnv gEnv = new GlobalEnv(CommandHelperFileLocations.getDefault().getConfigDirectory(), EnumSet.of(RuntimeMode.EMBEDDED, RuntimeMode.INTERPRETER));
        StaticRuntimeEnv staticRuntimeEnv = Static.getAliasCore().getStaticRuntimeEnv();
        gEnv.SetDynamicScriptingMode(true);
        CommandHelperEnvironment cEnv = new CommandHelperEnvironment();
        cEnv.SetPlayer(p2);
        CompilerEnvironment compilerEnv = new CompilerEnvironment();
        compilerEnv.setLogCompilerWarnings(false);
        Environment env = Environment.createEnvironment(gEnv, staticRuntimeEnv, cEnv, compilerEnv);
        ParseTree tree = MethodScriptCompiler.compile(stream, env, env.getEnvClasses());
        boolean isInterpeterMode = this.interpreterMode.remove(p2.getName());
        try {
            env.getEnv(StaticRuntimeEnv.class).getIncludeCache().executeAutoIncludes(env, null);
            MethodScriptCompiler.execute(tree, env, output -> {
                if ((output = output.trim()).isEmpty()) {
                    Static.SendMessage(p2, ":");
                } else if (output.startsWith("/")) {
                    Static.SendMessage(p2, ":" + MCChatColor.YELLOW + output);
                    p2.chat(output);
                } else {
                    Static.SendMessage(p2, ":" + MCChatColor.GREEN + output);
                }
                if (isInterpeterMode) {
                    this.interpreterMode.add(p2.getName());
                }
            }, null);
            return;
        }
        catch (CancelCommandException cancelCommandException) {
        }
        catch (ConfigRuntimeException e) {
            ConfigRuntimeException.HandleUncaughtException(e, env);
            Static.SendMessage(p2, MCChatColor.RED + e.toString());
        }
        catch (Exception e) {
            Static.SendMessage(p2, MCChatColor.RED + e.toString());
            Static.getLogger().log(Level.SEVERE, null, e);
        }
        if (isInterpeterMode) {
            this.interpreterMode.add(p2.getName());
        }
    }

    public void startInterpret(String playername) {
        this.interpreterMode.add(playername);
    }
}

