/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.postgresql.ssl;

import com.laytonsmith.libs.org.postgresql.core.Logger;
import com.laytonsmith.libs.org.postgresql.core.PGStream;
import com.laytonsmith.libs.org.postgresql.util.GT;
import com.laytonsmith.libs.org.postgresql.util.PSQLException;
import com.laytonsmith.libs.org.postgresql.util.PSQLState;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.Socket;
import java.util.Properties;
import javax.net.ssl.SSLSocketFactory;

public class MakeSSL {
    public static void convert(PGStream stream, Properties info, Logger logger) throws IOException, PSQLException {
        SSLSocketFactory factory;
        logger.debug("converting regular socket connection to ssl");
        String classname = info.getProperty("sslfactory");
        if (classname == null) {
            factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        } else {
            Object[] args2 = new Object[]{info.getProperty("sslfactoryarg")};
            try {
                Constructor<?> ctor;
                Class<?> factoryClass = Class.forName(classname);
                try {
                    ctor = factoryClass.getConstructor(String.class);
                }
                catch (NoSuchMethodException nsme) {
                    ctor = factoryClass.getConstructor(null);
                    args2 = null;
                }
                factory = (SSLSocketFactory)ctor.newInstance(args2);
            }
            catch (Exception e) {
                throw new PSQLException(GT.tr("The SSLSocketFactory class provided {0} could not be instantiated.", classname), PSQLState.CONNECTION_FAILURE, (Throwable)e);
            }
        }
        Socket newConnection = factory.createSocket(stream.getSocket(), stream.getHost(), stream.getPort(), true);
        stream.changeSocket(newConnection);
    }
}

