/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.enums.bukkit;

import com.laytonsmith.abstraction.MCColor;
import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.blocks.MCBlockData;
import com.laytonsmith.abstraction.bukkit.BukkitMCColor;
import com.laytonsmith.abstraction.bukkit.BukkitMCVibration;
import com.laytonsmith.abstraction.enums.MCParticle;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CDouble;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.Target;
import java.util.EnumMap;
import java.util.Map;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.ItemStack;

public class BukkitMCParticle
extends MCParticle<Particle> {
    private static final Map<Particle, MCParticle> BUKKIT_MAP = new EnumMap<Particle, MCParticle>(Particle.class);

    public BukkitMCParticle(MCParticle.MCVanillaParticle vanillaParticle, Particle particle) {
        super(vanillaParticle, particle);
    }

    @Override
    public String name() {
        return this.getAbstracted() == MCParticle.MCVanillaParticle.UNKNOWN ? ((Particle)this.getConcrete()).name() : ((MCParticle.MCVanillaParticle)((Object)this.getAbstracted())).name();
    }

    public static MCParticle valueOfConcrete(Particle test) {
        MCParticle type = BUKKIT_MAP.get(test);
        if (type == null) {
            MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.GENERAL, "Bukkit Particle missing in BUKKIT_MAP: " + test.name(), Target.UNKNOWN);
            return new BukkitMCParticle(MCParticle.MCVanillaParticle.UNKNOWN, test);
        }
        return type;
    }

    public static void build() {
        for (MCParticle.MCVanillaParticle mCVanillaParticle : MCParticle.MCVanillaParticle.values()) {
            Particle type;
            if (!mCVanillaParticle.existsIn(Static.getServer().getMinecraftVersion())) continue;
            try {
                type = BukkitMCParticle.getBukkitType(mCVanillaParticle);
            }
            catch (IllegalArgumentException | NoSuchFieldError ex) {
                MSLog.GetLogger().w(MSLog.Tags.RUNTIME, "Could not find a Bukkit Particle for " + mCVanillaParticle.name(), Target.UNKNOWN);
                continue;
            }
            BukkitMCParticle wrapper = new BukkitMCParticle(mCVanillaParticle, type);
            BUKKIT_MAP.put(type, wrapper);
            MAP.put(mCVanillaParticle.name(), wrapper);
        }
        for (MCParticle.MCVanillaParticle mCVanillaParticle : Particle.values()) {
            if (BUKKIT_MAP.containsKey((Object)mCVanillaParticle)) continue;
            MAP.put(mCVanillaParticle.name(), new BukkitMCParticle(MCParticle.MCVanillaParticle.UNKNOWN, (Particle)mCVanillaParticle));
            BUKKIT_MAP.put((Particle)mCVanillaParticle, new BukkitMCParticle(MCParticle.MCVanillaParticle.UNKNOWN, (Particle)mCVanillaParticle));
        }
    }

    private static Particle getBukkitType(MCParticle.MCVanillaParticle v) {
        return Particle.valueOf((String)v.name());
    }

    public Object getParticleData(MCLocation l, Object data) {
        switch ((MCParticle.MCVanillaParticle)((Object)this.getAbstracted())) {
            case BLOCK_DUST: 
            case BLOCK_CRACK: 
            case BLOCK_MARKER: 
            case FALLING_DUST: {
                BlockData bd = data instanceof MCBlockData ? (BlockData)((MCBlockData)data).getHandle() : (this.getAbstracted() == MCParticle.MCVanillaParticle.BLOCK_MARKER ? Material.BARRIER.createBlockData() : Material.STONE.createBlockData());
                return bd;
            }
            case ITEM_CRACK: {
                ItemStack is = data instanceof MCItemStack ? (ItemStack)((MCItemStack)data).getHandle() : new ItemStack(Material.STONE, 1);
                return is;
            }
            case REDSTONE: {
                Particle.DustOptions color2 = data instanceof MCColor ? new Particle.DustOptions(BukkitMCColor.GetColor((MCColor)data), 1.0f) : new Particle.DustOptions(Color.RED, 1.0f);
                return color2;
            }
            case DUST_COLOR_TRANSITION: {
                Particle.DustTransition dust;
                if (data instanceof MCColor[]) {
                    MCColor[] c = (MCColor[])data;
                    dust = new Particle.DustTransition(BukkitMCColor.GetColor(c[0]), BukkitMCColor.GetColor(c[1]), 1.0f);
                } else {
                    dust = new Particle.DustTransition(Color.TEAL, Color.RED, 1.0f);
                }
                return dust;
            }
            case VIBRATION: {
                BukkitMCVibration vibe = data instanceof MCLocation ? new BukkitMCVibration(l, (MCLocation)data, 5) : (data instanceof MCEntity ? new BukkitMCVibration(l, (MCEntity)data, 5) : new BukkitMCVibration(l, l, 5));
                return vibe.getHandle();
            }
            case SCULK_CHARGE: {
                Float f = data instanceof CDouble ? Float.valueOf((float)((CDouble)data).getDouble()) : Float.valueOf(1.0f);
                return f;
            }
            case SHRIEK: {
                Integer i = data instanceof CInt ? Integer.valueOf((int)((CInt)data).getInt()) : Integer.valueOf(0);
                return i;
            }
        }
        return null;
    }
}

