/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import com.laytonsmith.PureUtilities.Point3D;

public class Vector3D
extends Point3D {
    public static final Vector3D ZERO = new Vector3D(0.0, 0.0, 0.0);

    public Vector3D(Point3D other) {
        super(other);
    }

    public Vector3D(double x, double y) {
        super(x, y, 0.0);
    }

    public Vector3D(double x, double y, double z) {
        super(x, y, z);
    }

    public Vector3D add(Vector3D other) {
        return new Vector3D(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    public Vector3D subtract(Vector3D other) {
        return new Vector3D(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    public Vector3D multiply(Vector3D other) {
        return new Vector3D(this.x * other.x, this.y * other.y, this.z * other.z);
    }

    public Vector3D multiply(double m) {
        return new Vector3D(this.x * m, this.y * m, this.z * m);
    }

    public Vector3D divide(Vector3D other) {
        return new Vector3D(this.x / other.x, this.y / other.y, this.z / other.z);
    }

    public Vector3D divide(double m) {
        return new Vector3D(this.x / m, this.y / m, this.z / m);
    }

    public Vector3D normalize() {
        double length2 = this.length();
        if (length2 == 0.0) {
            return ZERO;
        }
        return new Vector3D(this.x / length2, this.y / length2, this.z / length2);
    }

    public double dot(Vector3D vec) {
        return this.x * vec.x + this.y * vec.y + this.z * vec.z;
    }

    public Vector3D cross(Vector3D vec) {
        return new Vector3D(this.y * vec.z - this.z * vec.y, this.z * vec.x - this.x * vec.z, this.x * vec.y - this.y * vec.x);
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }
}

