/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.DaemonManager;
import com.laytonsmith.abstraction.Convertor;
import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.abstraction.MCEnchantment;
import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.MCMetadataValue;
import com.laytonsmith.abstraction.MCPlugin;
import com.laytonsmith.abstraction.MCPotionData;
import com.laytonsmith.abstraction.MCRecipe;
import com.laytonsmith.abstraction.MCServer;
import com.laytonsmith.abstraction.MCWorld;
import com.laytonsmith.abstraction.blocks.MCMaterial;
import com.laytonsmith.abstraction.entities.MCTransformation;
import com.laytonsmith.abstraction.enums.MCPotionType;
import com.laytonsmith.abstraction.enums.MCRecipeType;
import com.laytonsmith.annotations.convert;
import com.laytonsmith.commandhelper.CommandHelperPlugin;
import java.util.Set;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public final class StaticLayer {
    private static Convertor convertor = null;

    private StaticLayer() {
    }

    private static synchronized void InitConvertor() {
        Set<Class<?>> classes = ClassDiscovery.getDefaultInstance().loadClassesWithAnnotation(convert.class);
        for (Class<?> c : classes) {
            convert convert2;
            if (!Convertor.class.isAssignableFrom(c)) {
                StreamUtils.GetSystemErr().println("The Convertor " + c.getSimpleName() + " doesn't implement Convertor!");
            }
            if ((convert2 = c.getAnnotation(convert.class)).type() != Implementation.GetServerType()) continue;
            try {
                if (convertor != null) {
                    System.out.println("More than one Convertor for this server type was detected!");
                }
                convertor = (Convertor)c.newInstance();
            }
            catch (Exception e) {
                StreamUtils.GetSystemErr().println("Tried to instantiate the Convertor, but couldn't!");
            }
        }
        if (convertor == null) {
            StreamUtils.GetSystemErr().println("Could not find a suitable convertor! You will experience serious issues with this plugin.");
        }
    }

    public static MCLocation GetLocation(MCWorld w, double x, double y, double z, float yaw, float pitch) {
        return convertor.GetLocation(w, x, y, z, yaw, pitch);
    }

    public static MCLocation GetLocation(MCWorld w, double x, double y, double z) {
        return StaticLayer.GetLocation(w, x, y, z, 0.0f, 0.0f);
    }

    public static Class<?> GetServerEventMixin() {
        return convertor.GetServerEventMixin();
    }

    public static MCMaterial GetMaterialFromLegacy(int type, int data) {
        return convertor.GetMaterialFromLegacy(type, data);
    }

    public static MCMaterial GetMaterialFromLegacy(String name, int data) {
        return convertor.GetMaterialFromLegacy(name, data);
    }

    public static MCItemStack GetItemStack(String type, int qty) {
        return convertor.GetItemStack(type, qty);
    }

    public static MCItemStack GetItemStack(MCMaterial type, int qty) {
        return convertor.GetItemStack(type, qty);
    }

    public static MCPotionData GetPotionData(MCPotionType type, boolean extended, boolean upgraded) {
        return convertor.GetPotionData(type, extended, upgraded);
    }

    public static MCServer GetServer() {
        return convertor.GetServer();
    }

    public static MCEnchantment GetEnchantmentByName(String name) {
        return convertor.GetEnchantmentByName(name);
    }

    public static MCMaterial[] GetMaterialValues() {
        return convertor.GetMaterialValues();
    }

    public static MCMaterial GetMaterial(String name) {
        return convertor.GetMaterial(name);
    }

    public static MCEnchantment[] GetEnchantmentValues() {
        return convertor.GetEnchantmentValues();
    }

    public static void Startup(CommandHelperPlugin chp) {
        convertor.Startup(chp);
    }

    public static MCMetadataValue GetMetadataValue(Object value, MCPlugin plugin) {
        return convertor.GetMetadataValue(value, plugin);
    }

    public static int SetFutureRunnable(DaemonManager dm, long ms, Runnable r) {
        return convertor.SetFutureRunnable(dm, ms, r);
    }

    public static int SetFutureRepeater(DaemonManager dm, long ms, long initialDelay, Runnable r) {
        return convertor.SetFutureRepeater(dm, ms, initialDelay, r);
    }

    public static void ClearAllRunnables() {
        convertor.ClearAllRunnables();
    }

    public static void ClearFutureRunnable(int id) {
        convertor.ClearFutureRunnable(id);
    }

    public static MCEntity GetCorrectEntity(MCEntity e) {
        return convertor.GetCorrectEntity(e);
    }

    public static MCRecipe GetNewRecipe(String key, MCRecipeType type, MCItemStack result) {
        return convertor.GetNewRecipe(key, type, result);
    }

    public static MCTransformation GetTransformation(Quaternionf leftRotation, Quaternionf rightRotation, Vector3f scale, Vector3f translation) {
        return convertor.GetTransformation(leftRotation, rightRotation, scale, translation);
    }

    public static String GetPluginName() {
        return convertor.GetPluginName();
    }

    public static MCPlugin GetPlugin() {
        return convertor.GetPlugin();
    }

    public static synchronized Convertor GetConvertor() {
        return convertor;
    }

    static {
        StaticLayer.InitConvertor();
    }
}

