/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.asm;

import com.laytonsmith.PureUtilities.Common.OSUtils;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.asm.AsmCommonLibTemplates;
import com.laytonsmith.core.asm.AsmCompiler;
import com.laytonsmith.core.asm.IRBuilder;
import com.laytonsmith.core.asm.IRData;
import com.laytonsmith.core.asm.IRDataBuilder;
import com.laytonsmith.core.asm.IRType;
import com.laytonsmith.core.asm.LLVMEnvironment;
import com.laytonsmith.core.asm.LLVMPlatformResolver;
import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CDouble;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.IVariable;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.HashSet;
import java.util.Set;

public final class LLVMArgumentValidation {
    private LLVMArgumentValidation() {
    }

    private static IRData handleFunction(Target t, IRType expectedType, IRBuilder builder, Environment env, ParseTree c) throws ConfigCompileException {
        IRData data = AsmCompiler.getIR(builder, c, env);
        return LLVMArgumentValidation.convert(t, expectedType, builder, env, data);
    }

    private static IRData convert(Target t, IRType expectedType, IRBuilder builder, Environment env, IRData data) throws ConfigCompileException {
        OSUtils.OS os = env.getEnv(CompilerEnvironment.class).getTargetOS();
        if (data.getResultType() == expectedType) {
            return data;
        }
        LLVMEnvironment llvmenv = env.getEnv(LLVMEnvironment.class);
        if (expectedType.getCategory() == IRType.Category.INTEGER && data.getResultType().getCategory() == IRType.Category.INTEGER) {
            int load = llvmenv.getNewLocalVariableReference(data.getResultType());
            builder.appendLine(t, "%" + load + " = load " + data.getResultType().getIRType() + ", " + data.getResultType().getIRType() + "* %" + data.getResultVariable());
            int ret = llvmenv.getNewLocalVariableReference(data.getResultType());
            if (expectedType.getBitDepth() >= data.getResultType().getBitDepth()) {
                builder.appendLine(t, "%" + ret + " = sext " + data.getResultType().getIRType() + " %" + load + " to " + expectedType.getIRType());
            } else {
                builder.appendLine(t, "%" + ret + " = trunc " + data.getResultType().getIRType() + " %" + load + " to " + expectedType.getIRType());
            }
            return IRDataBuilder.setReturnVariable(ret, expectedType);
        }
        if (expectedType == IRType.STRING) {
            if (os.isWindows()) {
                llvmenv.addSystemHeader("stdio.h");
            }
            llvmenv.addGlobalDeclaration(AsmCommonLibTemplates.SPRINTF, env);
            int alloca = llvmenv.getNewLocalVariableReference(IRType.OTHER);
            int gep = llvmenv.getNewLocalVariableReference(IRType.OTHER);
            int sprintf2 = llvmenv.getNewLocalVariableReference(IRType.INTEGER32);
            if (data.getResultType().getCategory() == IRType.Category.FLOAT) {
                String f = llvmenv.getOrPutStringConstant("%.17f");
                builder.appendLine(t, "%" + alloca + " = alloca [318 x i8]");
                builder.appendLine(t, "%" + gep + " = getelementptr inbounds [318 x i8], [318 x i8]* %" + alloca + ", i64 0, i64 0");
                builder.appendLine(t, "%" + sprintf2 + " = call i32 (i8*, i8*, ...) @sprintf(i8* %" + gep + ", i8* getelementptr inbounds ([6 x i8], [6 x i8]* @" + f + ", i64 0, i64 0), " + data.getReference() + ")");
                return IRDataBuilder.setReturnVariable(gep, IRType.STRING);
            }
            if (data.getResultType().getCategory() == IRType.Category.INTEGER) {
                String i = llvmenv.getOrPutStringConstant("%i");
                builder.appendLine(t, "%" + alloca + " = alloca [21 x i8]");
                builder.appendLine(t, "%" + gep + " = getelementptr inbounds [21 x i8], [21 x i8]* %" + alloca + ", i64 0, i64 0");
                builder.appendLine(t, "%" + sprintf2 + " = call i32 (i8*, i8*, ...) @sprintf(i8* %" + gep + ", i8* getelementptr inbounds ([3 x i8], [3 x i8]* @" + i + ", i64 0, i64 0), " + data.getReference() + ")");
                return IRDataBuilder.setReturnVariable(gep, IRType.STRING);
            }
        }
        throw new UnsupportedOperationException("Conversion of " + data.getResultType().getIRType() + " to " + expectedType.getIRType() + " is not implemented yet.");
    }

    public static IRData getInt64(IRBuilder builder, Environment env, ParseTree c, Target t) throws ConfigCompileException {
        if (c.isConst()) {
            Mixed data = c.getData();
            long i = ArgumentValidation.getInt(data, t);
            return IRDataBuilder.asConstant(IRType.INTEGER64, Long.toString(i));
        }
        if (c.getData() instanceof CFunction) {
            return LLVMArgumentValidation.handleFunction(t, IRType.INTEGER64, builder, env, c);
        }
        throw new UnsupportedOperationException();
    }

    public static IRData getInt32(IRBuilder builder, Environment env, ParseTree c, Target t) throws ConfigCompileException {
        if (c.isConst()) {
            Mixed data = c.getData();
            int i = ArgumentValidation.getInt32(data, t);
            return IRDataBuilder.asConstant(IRType.INTEGER32, Integer.toString(i));
        }
        if (c.getData() instanceof CFunction) {
            return LLVMArgumentValidation.handleFunction(t, IRType.INTEGER32, builder, env, c);
        }
        throw new UnsupportedOperationException();
    }

    public static IRData getDouble(IRBuilder builder, Environment env, ParseTree c, Target t) throws ConfigCompileException {
        if (c.isConst()) {
            Mixed data = c.getData();
            double i = ArgumentValidation.getDouble(data, t);
            return IRDataBuilder.asConstant(IRType.DOUBLE, Double.toString(i));
        }
        if (c.getData() instanceof CFunction) {
            return LLVMArgumentValidation.handleFunction(t, IRType.DOUBLE, builder, env, c);
        }
        throw new UnsupportedOperationException();
    }

    public static IRData getString(IRBuilder builder, Environment env, ParseTree c, Target t) throws ConfigCompileException {
        LLVMEnvironment e = env.getEnv(LLVMEnvironment.class);
        if (c.isConst()) {
            Mixed data = c.getData();
            String s = ArgumentValidation.getString(data, t);
            String id = e.getOrPutStringConstant(s);
            int length2 = s.length() + 1;
            String ref = "getelementptr inbounds ([" + length2 + " x i8], [" + length2 + " x i8]* @" + id + ", i64 0, i64 0)";
            return IRDataBuilder.asConstant(IRType.STRING, ref);
        }
        if (c.getData() instanceof CFunction) {
            return LLVMArgumentValidation.handleFunction(t, IRType.STRING, builder, env, c);
        }
        Mixed data = c.getData();
        if (data instanceof IVariable) {
            IVariable ivar = (IVariable)data;
            String name = ivar.getVariableName();
            IRType datatype = LLVMArgumentValidation.convertCClassTypeToIRType(e.getVariableType(name));
            int load = e.getVariableMapping(name);
            IRData data2 = IRDataBuilder.setReturnVariable(load, datatype);
            return LLVMArgumentValidation.convert(t, IRType.STRING, builder, env, data2);
        }
        throw new UnsupportedOperationException();
    }

    public static IRType convertCClassTypeToIRType(CClassType type) {
        try {
            if (CInt.TYPE.isExtendedBy(type)) {
                return IRType.INTEGER64;
            }
            if (CDouble.TYPE.isExtendedBy(type)) {
                return IRType.DOUBLE;
            }
            if (CString.TYPE.isExtendedBy(type)) {
                return IRType.STRING;
            }
        }
        catch (ClassNotFoundException ex) {
            throw new UnsupportedOperationException(ex);
        }
        throw new UnsupportedOperationException(type.getFQCN().getFQCN() + " is not yet supported");
    }

    public static String getValueFromConstant(IRBuilder builder, ParseTree data, Environment env) {
        if (!data.isConst()) {
            throw new Error();
        }
        Mixed value = data.getData();
        return LLVMPlatformResolver.outputConstant(builder, value, env).getReference();
    }

    public static IRData getAny(IRBuilder builder, Environment env, ParseTree c, Target t) throws ConfigCompileException {
        Cloneable exceptions;
        LLVMEnvironment e = env.getEnv(LLVMEnvironment.class);
        if (c.isConst()) {
            IRType datatype = LLVMArgumentValidation.convertCClassTypeToIRType(c.getData().typeof());
            String data = LLVMArgumentValidation.getValueFromConstant(builder, c, env);
            int alloca = e.getNewLocalVariableReference(datatype);
            int load = e.getNewLocalVariableReference(datatype);
            builder.generator(t, env).allocaStoreAndLoad(alloca, datatype, data, load);
            return IRDataBuilder.setReturnVariable(load, datatype);
        }
        Mixed datatype = c.getData();
        if (datatype instanceof CFunction) {
            CFunction cf = (CFunction)datatype;
            exceptions = new HashSet();
            CClassType retType = cf.getCachedFunction().typecheck(e.getStaticAnalysis(), c, env, (Set<ConfigCompileException>)((Object)exceptions));
            IRData data = LLVMArgumentValidation.handleFunction(t, LLVMArgumentValidation.convertCClassTypeToIRType(retType), builder, env, c);
            int alloca = e.getNewLocalVariableReference(data.getResultType());
            int load = e.getNewLocalVariableReference(data.getResultType());
            builder.generator(t, env).allocaStoreAndLoad(alloca, data.getResultType(), data.getResultVariable(), load);
            return IRDataBuilder.setReturnVariable(load, data.getResultType());
        }
        exceptions = c.getData();
        if (exceptions instanceof IVariable) {
            IVariable ivar = (IVariable)exceptions;
            String name = ivar.getVariableName();
            IRType datatype2 = LLVMArgumentValidation.convertCClassTypeToIRType(e.getVariableType(name));
            int load = e.getNewLocalVariableReference(datatype2);
            builder.generator(t, env).load(load, datatype2, e.getVariableMapping(name));
            return IRDataBuilder.setReturnVariable(load, datatype2);
        }
        throw new UnsupportedOperationException();
    }
}

