/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit;

import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.abstraction.MCBlockStateMeta;
import com.laytonsmith.abstraction.blocks.MCBlockState;
import com.laytonsmith.abstraction.bukkit.BukkitConvertor;
import com.laytonsmith.abstraction.bukkit.BukkitMCItemMeta;
import com.laytonsmith.abstraction.bukkit.BukkitMCServer;
import com.laytonsmith.abstraction.enums.MCVersion;
import com.laytonsmith.core.Static;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class BukkitMCBlockStateMeta
extends BukkitMCItemMeta
implements MCBlockStateMeta {
    BlockStateMeta bsm;
    Material mat;

    public BukkitMCBlockStateMeta(BlockStateMeta meta) {
        super((ItemMeta)meta);
        this.bsm = meta;
        this.mat = null;
    }

    public BukkitMCBlockStateMeta(BlockStateMeta meta, Material mat) {
        super((ItemMeta)meta);
        this.bsm = meta;
        this.mat = mat;
    }

    @Override
    public boolean hasBlockState() {
        return this.bsm.hasBlockState();
    }

    @Override
    public MCBlockState getBlockState() {
        return this.getBlockState(false);
    }

    @Override
    public MCBlockState getBlockState(boolean copy) {
        BlockStateMeta meta = this.bsm;
        if (copy && Static.getServer().getMinecraftVersion().lt(MCVersion.MC1_18_X)) {
            meta = (BlockStateMeta)meta.clone();
        } else if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_1) && this.mat == Material.DECORATED_POT) {
            try {
                Class<?> craftMetaBlockStateClass = Class.forName(((BukkitMCServer)Static.getServer()).getCraftBukkitPackage() + ".inventory.CraftMetaBlockState");
                Class<?> nbtTagCompoundClass = Class.forName("net.minecraft.nbt.NBTTagCompound");
                Object nbt = ReflectionUtils.get(craftMetaBlockStateClass, meta, "blockEntityTag");
                if (nbt != null) {
                    ReflectionUtils.invokeMethod(nbtTagCompoundClass, nbt, "a", new Class[]{String.class, String.class}, new Object[]{"id", "minecraft:decorated_pot"});
                }
            }
            catch (Exception ex) {
                Static.getLogger().log(Level.WARNING, "Failed to fix decorated pot tag.", ex);
            }
        }
        try {
            return BukkitConvertor.BukkitGetCorrectBlockState(meta.getBlockState());
        }
        catch (Exception ex) {
            Static.getLogger().log(Level.WARNING, ex.getMessage() + " when trying to get the BlockState from " + this.bsm.toString());
            return null;
        }
    }

    @Override
    public void setBlockState(MCBlockState state) {
        this.bsm.setBlockState((BlockState)state.getHandle());
    }
}

