/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.SmartComment;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Script;
import com.laytonsmith.core.constructs.Auto;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.IVariable;
import com.laytonsmith.core.constructs.InstanceofUtil;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.exceptions.CRE.AbstractCREException;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CREStackOverflowError;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.exceptions.FunctionReturnException;
import com.laytonsmith.core.exceptions.LoopManipulationException;
import com.laytonsmith.core.exceptions.StackTraceManager;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class Procedure
implements Cloneable {
    private final String name;
    private Map<String, IVariable> varList;
    private final Map<String, Mixed> originals = new HashMap<String, Mixed>();
    private final List<IVariable> varIndex = new ArrayList<IVariable>();
    private ParseTree tree;
    private CClassType returnType;
    private boolean possiblyConstant = false;
    private SmartComment procComment;
    private static final Pattern PROCEDURE_NAME_REGEX = Pattern.compile("^_[\\p{L}0-9]+[\\p{L}_0-9]*");
    private final Target definedAt;

    public Procedure(String name, CClassType returnType, List<IVariable> varList, SmartComment procComment, ParseTree tree, Target t) {
        this.name = name;
        this.definedAt = t;
        this.varList = new HashMap<String, IVariable>();
        this.procComment = procComment;
        for (int i = 0; i < varList.size(); ++i) {
            IVariable var = varList.get(i);
            if (var.getDefinedType().isVarargs() && i != varList.size() - 1) {
                throw new CREFormatException("Varargs can only be added to the last argument.", t);
            }
            try {
                this.varList.put(var.getVariableName(), var.clone());
            }
            catch (CloneNotSupportedException e) {
                this.varList.put(var.getVariableName(), var);
            }
            this.varIndex.add(var);
            if (var.getDefinedType().isVarargs() && var.ival() != CNull.UNDEFINED) {
                throw new CREFormatException("Varargs may not have default values", t);
            }
            this.originals.put(var.getVariableName(), var.ival());
        }
        this.tree = tree;
        if (!PROCEDURE_NAME_REGEX.matcher(name).matches()) {
            throw new CREFormatException("Procedure names must start with an underscore, and may only contain letters, underscores, and digits. (Found " + this.name + ")", t);
        }
        this.possiblyConstant = this.checkPossiblyConstant(tree);
        this.returnType = returnType;
    }

    private boolean checkPossiblyConstant(ParseTree tree) {
        return false;
    }

    public boolean isPossiblyConstant() {
        return this.possiblyConstant;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + "(" + StringUtils.Join(this.varList.keySet(), ", ") + ")";
    }

    public SmartComment getSmartComment() {
        return this.procComment;
    }

    public Mixed cexecute(List<ParseTree> args2, Environment env, Target t) {
        ArrayList<Mixed> list = new ArrayList<Mixed>();
        for (ParseTree arg : args2) {
            list.add(env.getEnv(GlobalEnv.class).GetScript().seval(arg, env));
        }
        return this.execute(list, env, t);
    }

    public Mixed execute(List<Mixed> args2, Environment oldEnv, Target t) {
        int varInd;
        Environment env;
        boolean prev = oldEnv.getEnv(GlobalEnv.class).getCloneVars();
        oldEnv.getEnv(GlobalEnv.class).setCloneVars(false);
        try {
            env = oldEnv.clone();
            env.getEnv(GlobalEnv.class).setCloneVars(true);
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
        oldEnv.getEnv(GlobalEnv.class).setCloneVars(prev);
        Script fakeScript = Script.GenerateScript(this.tree, env.getEnv(GlobalEnv.class).GetLabel(), null);
        CArray arguments = new CArray(Target.UNKNOWN, this.varIndex.size());
        CArray vararg = null;
        for (varInd = 0; varInd < args2.size(); ++varInd) {
            IVariable var;
            Mixed c = args2.get(varInd);
            arguments.push(c, t);
            if (this.varIndex.size() <= varInd && (this.varIndex.isEmpty() || !this.varIndex.get(this.varIndex.size() - 1).getDefinedType().isVarargs())) continue;
            boolean isVarArg = false;
            if (varInd < this.varIndex.size() - 1 || !this.varIndex.get(this.varIndex.size() - 1).getDefinedType().isVarargs()) {
                var = this.varIndex.get(varInd);
            } else {
                var = this.varIndex.get(this.varIndex.size() - 1);
                if (vararg == null) {
                    vararg = new CArray(t);
                    env.getEnv(GlobalEnv.class).GetVarList().set(new IVariable(CArray.TYPE, var.getVariableName(), vararg, c.getTarget()));
                }
                isVarArg = true;
            }
            if (c instanceof CVoid && !var.getDefinedType().equals(Auto.TYPE) && !var.getDefinedType().equals(CVoid.TYPE)) {
                throw new CRECastException("Procedure \"" + this.name + "\" expects a value of type " + var.getDefinedType().val() + " in argument " + (varInd + 1) + ", but a void value was found instead.", c.getTarget());
            }
            if (!(c instanceof CVoid) && c instanceof CNull || var.getDefinedType().equals(Auto.TYPE) || InstanceofUtil.isInstanceof(c, var.getDefinedType(), env)) {
                if (isVarArg) {
                    vararg.push(c, t);
                    continue;
                }
                env.getEnv(GlobalEnv.class).GetVarList().set(new IVariable(var.getDefinedType(), var.getVariableName(), c, c.getTarget()));
                continue;
            }
            throw new CRECastException("Procedure \"" + this.name + "\" expects a value of type " + var.getDefinedType().val() + " in argument " + (varInd + 1) + ", but a value of type " + c.typeof() + " was found instead.", c.getTarget());
        }
        while (varInd < this.varIndex.size()) {
            String varName = this.varIndex.get(varInd++).getVariableName();
            Mixed defVal = this.originals.get(varName);
            env.getEnv(GlobalEnv.class).GetVarList().set(new IVariable(Auto.TYPE, varName, defVal, defVal.getTarget()));
            arguments.push(defVal, t);
        }
        env.getEnv(GlobalEnv.class).GetVarList().set(new IVariable(CArray.TYPE, "@arguments", arguments, t));
        StackTraceManager stManager = env.getEnv(GlobalEnv.class).GetStackTraceManager();
        stManager.addStackTraceElement(new ConfigRuntimeException.StackTraceElement("proc " + this.name, this.getTarget()));
        try {
            if (this.tree.getData() instanceof CFunction && this.tree.getData().val().equals("sconcat")) {
                for (ParseTree child : this.tree.getChildren()) {
                    fakeScript.eval(child, env);
                }
            } else {
                fakeScript.eval(this.tree, env);
            }
        }
        catch (FunctionReturnException e) {
            Mixed ret = e.getReturn();
            if (this.returnType.equals(Auto.TYPE)) {
                Mixed mixed = ret;
                return mixed;
            }
            if (this.returnType.equals(CVoid.TYPE) != ret.equals(CVoid.VOID) || !ret.equals(CNull.NULL) && !ret.equals(CVoid.VOID) && !InstanceofUtil.isInstanceof(ret, this.returnType, env)) {
                throw new CRECastException("Expected procedure \"" + this.name + "\" to return a value of type " + this.returnType.val() + " but a value of type " + ret.typeof() + " was returned instead", ret.getTarget());
            }
            Mixed mixed = ret;
            return mixed;
        }
        catch (LoopManipulationException ex) {
            throw ConfigRuntimeException.CreateUncatchableException("Loop manipulation operations (e.g. break() or continue()) cannot bubble up past procedures.", t);
        }
        catch (ConfigRuntimeException e) {
            if (e instanceof AbstractCREException) {
                ((AbstractCREException)e).freezeStackTraceElements(stManager);
            }
            throw e;
        }
        catch (StackOverflowError e) {
            throw new CREStackOverflowError(null, t, e);
        }
        finally {
            stManager.popStackTraceElement();
        }
        if (!this.returnType.equals(Auto.TYPE) && !this.returnType.equals(CVoid.TYPE)) {
            throw new CRECastException("Expecting procedure \"" + this.name + "\" to return a value of type " + this.returnType.val() + ", but no value was returned.", this.tree.getTarget());
        }
        return CVoid.VOID;
    }

    public Target getTarget() {
        return this.definedAt;
    }

    public Procedure clone() throws CloneNotSupportedException {
        Procedure clone = (Procedure)super.clone();
        if (this.varList != null) {
            clone.varList = new HashMap<String, IVariable>(this.varList);
        }
        if (this.tree != null) {
            clone.tree = this.tree.clone();
        }
        return clone;
    }

    public void definitelyNotConstant() {
        this.possiblyConstant = false;
    }
}

