/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.redis.clients.jedis.search.schemafields;

import com.laytonsmith.libs.redis.clients.jedis.CommandArguments;
import com.laytonsmith.libs.redis.clients.jedis.search.FieldName;
import com.laytonsmith.libs.redis.clients.jedis.search.SearchProtocol;
import com.laytonsmith.libs.redis.clients.jedis.search.schemafields.SchemaField;
import java.util.LinkedHashMap;
import java.util.Map;

public class VectorField
extends SchemaField {
    private final VectorAlgorithm algorithm;
    private final Map<String, Object> attributes;

    public VectorField(String fieldName, VectorAlgorithm algorithm, Map<String, Object> attributes) {
        super(fieldName);
        this.algorithm = algorithm;
        this.attributes = attributes;
    }

    public VectorField(FieldName fieldName, VectorAlgorithm algorithm, Map<String, Object> attributes) {
        super(fieldName);
        this.algorithm = algorithm;
        this.attributes = attributes;
    }

    @Override
    public VectorField as(String attribute) {
        super.as(attribute);
        return this;
    }

    @Override
    public void addParams(CommandArguments args2) {
        args2.addParams(this.fieldName);
        args2.add(SearchProtocol.SearchKeyword.VECTOR);
        args2.add((Object)this.algorithm);
        args2.add(this.attributes.size() * 2);
        this.attributes.forEach((name, value) -> args2.add(name).add(value));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private FieldName fieldName;
        private VectorAlgorithm algorithm;
        private Map<String, Object> attributes;

        private Builder() {
        }

        public VectorField build() {
            if (this.fieldName == null || this.algorithm == null || this.attributes == null || this.attributes.isEmpty()) {
                throw new IllegalArgumentException("All required VectorField parameters are not set.");
            }
            return new VectorField(this.fieldName, this.algorithm, this.attributes);
        }

        public Builder fieldName(String fieldName) {
            this.fieldName = FieldName.of(fieldName);
            return this;
        }

        public Builder fieldName(FieldName fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder as(String attribute) {
            this.fieldName.as(attribute);
            return this;
        }

        public Builder algorithm(VectorAlgorithm algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder attributes(Map<String, Object> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder addAttribute(String name, Object value) {
            if (this.attributes == null) {
                this.attributes = new LinkedHashMap<String, Object>();
            }
            this.attributes.put(name, value);
            return this;
        }
    }

    public static enum VectorAlgorithm {
        FLAT,
        HNSW;

    }
}

