/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler;

import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.compiler.CompilerObject;
import com.laytonsmith.core.compiler.LexerObject;
import com.laytonsmith.core.compiler.NewScript;
import com.laytonsmith.core.compiler.OptimizerObject;
import com.laytonsmith.core.compiler.TokenStream;
import com.laytonsmith.core.constructs.CBareString;
import com.laytonsmith.core.constructs.CDouble;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.constructs.Token;
import com.laytonsmith.core.constructs.Variable;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class NewMethodScriptCompiler {
    public static TokenStream lex(String script, File file, boolean startInPureMscript) throws ConfigCompileException {
        script = ((String)script).replaceAll("\r\n", "\n");
        script = (String)script + "\n";
        LexerObject lo = new LexerObject((String)script, file, startInPureMscript);
        return lo.lex();
    }

    public static List<NewScript> preprocess(TokenStream tokenStream, Environment compilerEnvironment) throws ConfigCompileException {
        ArrayList<NewScript> scripts = new ArrayList<NewScript>();
        ArrayList commands = new ArrayList();
        ArrayList<Token> working = new ArrayList<Token>();
        for (int i = 0; i < tokenStream.size(); ++i) {
            Token token = (Token)tokenStream.get(i);
            if (token.type == Token.TType.NEWLINE) {
                commands.add(working);
                working = new ArrayList();
                continue;
            }
            working.add(token);
        }
        for (List list : commands) {
            ArrayList<Token> left = new ArrayList<Token>();
            TokenStream right = new TokenStream(new ArrayList<Token>(), tokenStream.getFileOptions());
            boolean inLeft = true;
            boolean hasLabel = false;
            for (Token t : list) {
                if (t.type == Token.TType.ALIAS_END) {
                    inLeft = false;
                    continue;
                }
                if (t.type == Token.TType.LABEL) {
                    hasLabel = true;
                }
                if (inLeft) {
                    left.add(t);
                    continue;
                }
                right.add(t);
            }
            ParseTree cright = NewMethodScriptCompiler.compile(right, compilerEnvironment);
            ArrayList<Construct> cleft = new ArrayList<Construct>();
            boolean atFinalVar = false;
            boolean atOptionalVars = false;
            boolean pastLabel = false;
            Object label = "";
            try {
                for (int i = 0; i < left.size(); ++i) {
                    Token t = (Token)left.get(i);
                    if (hasLabel && !pastLabel) {
                        if (t.type == Token.TType.LABEL) {
                            pastLabel = true;
                            continue;
                        }
                        label = (String)label + t.val();
                        continue;
                    }
                    if (atFinalVar) {
                        throw new ConfigCompileException("The final var must be the last declaration in the alias", t.getTarget());
                    }
                    if (t.type == Token.TType.LSQUARE_BRACKET) {
                        Token tname = (Token)left.get(i + 1);
                        atOptionalVars = true;
                        if (tname.val().equals("$")) {
                            atFinalVar = true;
                        }
                        if (tname.type != Token.TType.VARIABLE && tname.type != Token.TType.FINAL_VAR) {
                            throw new ConfigCompileException("Expecting a variable, but found " + tname.val(), tname.getTarget());
                        }
                        Token next = (Token)left.get(++i + 1);
                        if (next.type != Token.TType.OPT_VAR_ASSIGN && next.type != Token.TType.RSQUARE_BRACKET) {
                            throw new ConfigCompileException("Expecting either a variable assignment or right square bracket, but found " + next.val(), next.getTarget());
                        }
                        ++i;
                        String defaultVal = "";
                        if (next.type == Token.TType.OPT_VAR_ASSIGN) {
                            Token val = (Token)left.get(i + 1);
                            defaultVal = val.val();
                            next = (Token)left.get(++i + 1);
                        }
                        if (next.type != Token.TType.RSQUARE_BRACKET) {
                            throw new ConfigCompileException("Expecting a right square bracket, but found " + next.val() + " instead. (Did you forget to quote a multi word string?)", next.getTarget());
                        }
                        ++i;
                        Variable v = new Variable(tname.val(), defaultVal, true, tname.val().equals("$"), tname.getTarget());
                        cleft.add(v);
                        continue;
                    }
                    if (t.type == Token.TType.VARIABLE || t.type == Token.TType.FINAL_VAR) {
                        if (atOptionalVars) {
                            throw new ConfigCompileException("Only optional variables may come after the first optional variable", t.getTarget());
                        }
                        if (t.val().equals("$")) {
                            atFinalVar = true;
                        }
                        Variable v = new Variable(t.val(), "", false, t.val().equals("$"), t.getTarget());
                        cleft.add(v);
                        continue;
                    }
                    cleft.add(NewMethodScriptCompiler.tokenToConstruct(t));
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConfigCompileException("Expecting more tokens, but reached end of alias signature before tokens were resolved.", ((Token)left.get(0)).getTarget());
            }
            if (cleft.isEmpty()) continue;
            NewMethodScriptCompiler.link(cright, compilerEnvironment);
            scripts.add(new NewScript(cleft, cright, (String)label));
        }
        return scripts;
    }

    public static ParseTree compile(TokenStream tokenStream, Environment compilerEnvironment) throws ConfigCompileException {
        ParseTree root = new ParseTree(new CFunction("__autoconcat__", Target.UNKNOWN), tokenStream.getFileOptions());
        new CompilerObject(tokenStream).compile(root, compilerEnvironment);
        NewMethodScriptCompiler.link(root, compilerEnvironment);
        return root;
    }

    private static void link(ParseTree root, Environment compilerEnvirontment) throws ConfigCompileException {
        ParseTree master = new ParseTree(new CFunction("__autoconcat__", Target.UNKNOWN), root.getFileOptions());
        for (ParseTree include2 : compilerEnvirontment.getEnv(CompilerEnvironment.class).getIncludes()) {
            master.addChild(include2);
        }
        master.addChild(root);
        OptimizerObject optimizer = new OptimizerObject(root, compilerEnvirontment);
        optimizer.optimize();
    }

    private static Construct tokenToConstruct(Token t) {
        if (t.type == Token.TType.STRING) {
            return new CString(t.val(), t.getTarget());
        }
        if (t.type == Token.TType.BARE_STRING) {
            return new CBareString(t.val(), t.getTarget());
        }
        if (t.type == Token.TType.INTEGER) {
            return new CInt(Long.parseLong(t.val()), t.getTarget());
        }
        if (t.type == Token.TType.DOUBLE) {
            return new CDouble(Double.parseDouble(t.val()), t.getTarget());
        }
        return null;
    }

    public static void main(String[] args2) throws ConfigCompileException {
        CompilerEnvironment env = new CompilerEnvironment();
        env.setConstant("v.n", "value");
        TokenStream stream = NewMethodScriptCompiler.lex("<! strict; > @var", null, true);
        StreamUtils.GetSystemOut().println(stream + "\n");
        ParseTree tree = NewMethodScriptCompiler.compile(stream, Environment.createEnvironment(env));
        StreamUtils.GetSystemOut().println(tree.toStringVerbose());
    }
}

