/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.Common;

import com.laytonsmith.PureUtilities.Common.DateUtils;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LogUtils {
    private LogUtils() {
    }

    public static String LF() {
        return System.getProperty("line.separator");
    }

    public static void LoggerMessage(String filename, String message) throws IOException {
        String timestamp = DateUtils.ParseCalendarNotation("%Y-%M-%D %h:%m.%s - ");
        LogUtils.QuickAppend(LogUtils.GetLog(filename), timestamp + message + LogUtils.LF());
    }

    public static synchronized void LoggerMessage(String filename, String message, Logger logger) throws IOException {
        if (logger != null) {
            logger.log(Level.INFO, message);
        }
        LogUtils.LoggerMessage(filename, message);
    }

    public static synchronized void LoggerMessage(String filename, String message, PrintStream out) throws IOException {
        if (out != null) {
            out.println(message);
        }
        LogUtils.LoggerMessage(filename, message);
    }

    public static void QuickAppend(FileWriter f, String message) throws IOException {
        f.append(message);
        f.flush();
    }

    private static FileWriter GetLog(String filename) throws IOException {
        return new FileWriter(filename, true);
    }

    public static void Log(String filename, String message) throws IOException {
        LogUtils.QuickAppend(LogUtils.GetLog(filename), message + LogUtils.LF());
    }
}

