/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import com.laytonsmith.PureUtilities.MapBuilder;
import com.laytonsmith.PureUtilities.Web.HTTPHeaders;
import com.laytonsmith.PureUtilities.Web.HTTPMethod;
import com.laytonsmith.PureUtilities.Web.HTTPResponse;
import com.laytonsmith.PureUtilities.Web.RequestSettings;
import com.laytonsmith.PureUtilities.Web.WebUtility;
import com.laytonsmith.libs.org.json.simple.JSONArray;
import com.laytonsmith.libs.org.json.simple.JSONObject;
import com.laytonsmith.libs.org.json.simple.JSONValue;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GithubUtil {
    private static final String GITHUB_URL = "https://api.github.com";
    private static final String DATE_FORMAT = "YYYY-MM-DDTHH:MM:SSZ";
    private final String authToken;

    public GithubUtil(String bearerToken) {
        this.authToken = bearerToken;
    }

    public GithubResponse githubApiCall(HTTPMethod method, String path, Map<String, String> pathParams, Map<String, String> queryParams) throws GithubException {
        if (pathParams == null) {
            pathParams = new HashMap<String, String>();
        }
        if (queryParams == null) {
            queryParams = new HashMap<String, String>();
        }
        for (Map.Entry<String, String> e : pathParams.entrySet()) {
            path = path.replaceAll(":" + e.getKey(), e.getValue());
        }
        queryParams = new HashMap<String, String>(queryParams);
        queryParams.put("per_page", "100");
        GithubResponse r = new GithubResponse();
        Object url = GITHUB_URL + path;
        while (true) {
            Object value;
            HTTPResponse response;
            RequestSettings rs = new RequestSettings();
            rs.setMethod(method);
            rs.setHeaders(MapBuilder.start("Accept", Arrays.asList("application/vnd.github.v3+json")).set("Authorization", Arrays.asList("token " + this.authToken)));
            rs.setQueryParameters(queryParams);
            try {
                response = WebUtility.GetPage(new URL((String)url), rs);
            }
            catch (IOException ex) {
                throw new GithubException(ex);
            }
            if (response.getResponseCode() < 200 || response.getResponseCode() > 299) {
                throw new GithubException(response.getResponseCode(), response.getResponseText(), response.getContentAsString());
            }
            HTTPHeaders headers = response.getHeaderObject();
            r.remainingQuota = Integer.parseInt(headers.getFirstHeader("X-RateLimit-Remaining"));
            try {
                value = JSONValue.parse(response.getContentAsString(headers.getContentType().charset));
            }
            catch (UnsupportedEncodingException ex) {
                throw new GithubException(ex);
            }
            if (r.isObject == null) {
                r.isObject = value instanceof JSONObject;
            }
            if (r.content == null) {
                r.content = value;
            } else if (!r.isObject.booleanValue()) {
                JSONArray existing = (JSONArray)r.content;
                JSONArray current = (JSONArray)value;
                existing.addAll(current);
            }
            if (r.isObject.booleanValue() || headers.getLink("next") == null) break;
            url = headers.getLink("next");
            if (!((String)url).startsWith("/")) continue;
            url = GITHUB_URL + (String)url;
        }
        return r;
    }

    public List<Repository> listRepos(String visibility, String affiliation, String type, String sort, String direction) throws GithubException {
        GithubResponse r = this.githubApiCall(HTTPMethod.GET, "/user/repos", null, MapBuilder.empty(String.class, String.class).setIfValueNotNull("visibility", visibility).setIfValueNotNull("affiliation", affiliation).setIfValueNotNull("type", type).setIfValueNotNull("sort", sort).setIfValueNotNull("direction", direction));
        ArrayList<Repository> ret = new ArrayList<Repository>();
        for (Object o : r.asArray()) {
            ret.add(Repository.parse((JSONObject)o));
        }
        return ret;
    }

    public Repository getRepo(String owner, String repo) throws GithubException {
        GithubResponse r = this.githubApiCall(HTTPMethod.GET, "/repos/:owner/:repo", MapBuilder.start("owner", owner).set("repo", repo), null);
        return Repository.parse(r.asObject());
    }

    public Repository forkRepo(String owner, String repo, String organization) throws GithubException {
        GithubResponse r = this.githubApiCall(HTTPMethod.POST, "/repos/:owner/:repo/forks", MapBuilder.start("owner", owner).set("repo", repo), MapBuilder.empty(String.class, String.class).setIfValueNotNull("organization", organization));
        return Repository.parse(r.asObject());
    }

    public static class GithubResponse {
        public Object content;
        public Boolean isObject;
        public int remainingQuota;

        public JSONObject asObject() {
            return (JSONObject)this.content;
        }

        public JSONArray asArray() {
            return (JSONArray)this.content;
        }
    }

    public static class GithubException
    extends IOException {
        private final int responseCode;
        private final String responseCodeText;

        public GithubException(int responseCode, String responseCodeText, String message) {
            super(responseCode + " " + responseCodeText + ": " + message);
            this.responseCode = responseCode;
            this.responseCodeText = responseCodeText;
        }

        public GithubException(IOException ex) {
            super(ex.getMessage(), ex);
            this.responseCode = 0;
            this.responseCodeText = "";
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public String getResponesCodeText() {
            return this.responseCodeText;
        }
    }

    public static class Repository {
        public int id;
        public String name;
        public String fullName;
        public Owner owner;
        public String htmlUrl;
        public String cloneUrl;
        public String sshUrl;
        public boolean fork;
        public Repository parent;
        public Repository source;

        static Repository parse(JSONObject obj) {
            if (obj == null) {
                return null;
            }
            Repository r = new Repository();
            r.id = Integer.parseInt(obj.get("id").toString());
            r.name = obj.get("name").toString();
            r.fullName = obj.get("full_name").toString();
            r.owner = Owner.parse((JSONObject)obj.get("owner"));
            r.htmlUrl = obj.get("html_url").toString();
            r.cloneUrl = obj.get("clone_url").toString();
            r.sshUrl = obj.get("ssh_url").toString();
            r.fork = Boolean.parseBoolean(obj.get("fork").toString());
            if (r.fork) {
                r.parent = Repository.parse((JSONObject)obj.get("parent"));
                r.source = Repository.parse((JSONObject)obj.get("source"));
            }
            return r;
        }
    }

    public static class Owner {
        public String login;
        public int id;

        static Owner parse(JSONObject obj) {
            Owner o = new Owner();
            o.login = obj.get("login").toString();
            o.id = Integer.parseInt(obj.get("id").toString());
            return o;
        }
    }
}

