/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.ObjectHelpers;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Preferences {
    private final Map<GroupData, Map<String, Preference>> prefs = new HashMap<GroupData, Map<String, Preference>>();
    private final String appName;
    private final Logger logger;
    private File prefFile;
    private String header = "";
    private int lineLength = 120;

    public Preferences(String appName, Logger logger, List<Preference> defaults, String header) {
        this.appName = appName;
        this.logger = logger;
        for (Preference p2 : defaults) {
            if (!this.prefs.containsKey(p2.group)) {
                this.prefs.put(p2.group, new HashMap());
            }
            this.prefs.get(p2.group).put(p2.name, p2);
        }
        if (!header.trim().isEmpty()) {
            StringBuilder b = new StringBuilder();
            header = header.replace("\n", "\n# ");
            for (String line2 : StringUtils.lineSplit(header, this.lineLength)) {
                b.append("# ").append(line2).append(StringUtils.nl());
            }
            this.header = b.toString();
        }
    }

    public Preferences(String appName, Logger logger, List<Preference> defaults) {
        this(appName, logger, defaults, "");
    }

    private Preference getPrefFromKey(String key) {
        for (Map<String, Preference> m : this.prefs.values()) {
            if (!m.containsKey(key)) continue;
            return m.get(key);
        }
        return null;
    }

    public void init(File prefFile) throws IOException {
        this.prefFile = prefFile;
        if (prefFile != null && prefFile.exists()) {
            Properties userProperties = new Properties();
            try (FileInputStream in = new FileInputStream(prefFile);){
                userProperties.load(in);
            }
            for (String key : userProperties.stringPropertyNames()) {
                if (key.startsWith("[")) continue;
                Preference p2 = this.getPrefFromKey(key);
                String val = userProperties.getProperty(key);
                String value = Objects.toString(this.getObject(val, p2), null);
                Object ovalue = this.getObject(val, p2);
                Preference p22 = p2 != null ? new Preference(p2.name, value, p2.allowed, p2.description, p2.group, p2.sort) : new Preference(key, val, Type.STRING, "");
                p22.objectValue = ovalue;
                if (!this.prefs.containsKey(p22.group)) {
                    this.prefs.put(p22.group, new HashMap());
                }
                this.prefs.get(p22.group).put(key, p22);
            }
        }
        this.save();
    }

    private Object getObject(String value, Preference p2) {
        if (p2 == null) {
            return value;
        }
        if ("null".equalsIgnoreCase(value)) {
            return this.getObject(p2.value, p2);
        }
        switch (p2.allowed.ordinal()) {
            case 3: {
                try {
                    return Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    this.logger.log(Level.WARNING, "[" + this.appName + "] expects the value of " + p2.name + " to be an integer. Using the default of " + p2.value);
                    return Integer.parseInt(p2.value);
                }
            }
            case 4: {
                try {
                    return Double.parseDouble(value);
                }
                catch (NumberFormatException e) {
                    this.logger.log(Level.WARNING, "[" + this.appName + "] expects the value of " + p2.name + " to be an double. Using the default of " + p2.value);
                    return Double.parseDouble(p2.value);
                }
            }
            case 1: {
                Boolean v = Preferences.getBoolean(value);
                if (v == null) {
                    this.logger.log(Level.WARNING, "[" + this.appName + "] expects the value of " + p2.name + " to be an boolean. Using the default of " + p2.value);
                    return Preferences.getBoolean(p2.value);
                }
                return v;
            }
            case 0: {
                try {
                    return Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    try {
                        return Double.parseDouble(value);
                    }
                    catch (NumberFormatException f) {
                        this.logger.log(Level.WARNING, "[" + this.appName + "] expects the value of " + p2.name + " to be a number. Using the default of " + p2.value);
                        try {
                            return Integer.parseInt(p2.value);
                        }
                        catch (NumberFormatException g2) {
                            return Double.parseDouble(p2.value);
                        }
                    }
                }
            }
            case 5: {
                if (value == null || "".equals(value.trim())) {
                    return null;
                }
                return new File(value);
            }
        }
        return value;
    }

    public static Boolean getBoolean(String value) {
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        if (value.equalsIgnoreCase("yes")) {
            return true;
        }
        if (value.equalsIgnoreCase("no")) {
            return false;
        }
        if (value.equalsIgnoreCase("on")) {
            return true;
        }
        if (value.equalsIgnoreCase("off")) {
            return false;
        }
        try {
            double d = Double.parseDouble(value);
            return d != 0.0;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Object getSafePreference(String name, Type type) {
        Preference p2 = this.getPrefFromKey(name);
        if (p2.allowed != type) {
            throw new IllegalArgumentException("Expecting " + String.valueOf((Object)p2.allowed) + " but " + String.valueOf((Object)type) + " was requested");
        }
        if (p2.objectValue == null) {
            p2.objectValue = this.getObject(p2.value, p2);
        }
        return p2.objectValue;
    }

    public Boolean getBooleanPreference(String name) {
        return (Boolean)this.getSafePreference(name, Type.BOOLEAN);
    }

    public Double getDoublePreference(String name) {
        return (Double)this.getSafePreference(name, Type.DOUBLE);
    }

    public File getFilePreference(String name) {
        return (File)this.getSafePreference(name, Type.FILE);
    }

    public Integer getIntegerPreference(String name) {
        return (Integer)this.getSafePreference(name, Type.INT);
    }

    public Number getNumberPreference(String name) {
        return (Number)this.getSafePreference(name, Type.NUMBER);
    }

    public String getStringPreference(String name) {
        return (String)this.getSafePreference(name, Type.STRING);
    }

    private void save() {
        try {
            StringBuilder b = new StringBuilder();
            String nl = System.getProperty("line.separator");
            b.append("# This file is generated automatically. Changes made to the values of this file").append(nl).append("# will persist, but changes to comments will not. For windows file paths,").append(nl).append("# use either / or \\\\, but not a single \\.").append(nl).append(nl);
            if (!this.header.trim().isEmpty()) {
                b.append(this.header).append(nl).append(nl);
            }
            TreeSet<Preference> prfs = new TreeSet<Preference>((t, t1) -> {
                int groupSort = t.group.compareTo(t1.group);
                if (groupSort != 0) {
                    return groupSort;
                }
                if (t.sort == t1.sort) {
                    return t.name.compareTo(t1.name);
                }
                return t.sort < t1.sort ? -1 : 1;
            });
            for (Map<String, Preference> m : this.prefs.values()) {
                prfs.addAll(m.values());
            }
            GroupData currentGroup = null;
            for (Preference p2 : prfs) {
                if (!p2.group.equals(currentGroup)) {
                    b.append("[").append(p2.group.getName()).append("]\n");
                    if (p2.group.getDescription() != null && !p2.group.getDescription().trim().equals("")) {
                        for (String line2 : StringUtils.lineSplit(p2.group.getDescription(), this.lineLength)) {
                            b.append("# ").append(line2).append(nl);
                        }
                        b.append(nl);
                    }
                    currentGroup = p2.group;
                }
                Object description = "This value is not used in " + this.appName;
                if (!p2.description.trim().isEmpty()) {
                    description = p2.description;
                }
                StringBuilder c = new StringBuilder();
                boolean first = true;
                for (String line : ((String)description).split("\n|\r\n|\n\r")) {
                    for (String line2 : StringUtils.lineSplit(line, this.lineLength)) {
                        if (first) {
                            c.append("# ").append(line2);
                            first = false;
                            continue;
                        }
                        c.append(nl).append("# ").append(line2);
                    }
                }
                b.append((CharSequence)c).append(nl).append(p2.name).append("=");
                if (p2.allowed == Type.FILE && p2.value != null) {
                    b.append(p2.value.replace("\\", "\\\\"));
                } else {
                    b.append(p2.value);
                }
                b.append(nl).append(nl);
            }
            if (this.prefFile != null && !this.prefFile.exists()) {
                this.prefFile.getAbsoluteFile().getParentFile().mkdirs();
                this.prefFile.createNewFile();
            }
            if (this.prefFile != null) {
                FileUtil.write(b.toString(), this.prefFile);
            }
        }
        catch (Exception ex) {
            this.logger.log(Level.WARNING, "[" + this.appName + "] Could not write out preferences file: " + (this.prefFile != null ? this.prefFile.getAbsolutePath() : "null"), ex);
        }
    }

    public void setLineLength(int lineLength) {
        if (lineLength < 1) {
            throw new IllegalArgumentException();
        }
        this.lineLength = lineLength;
    }

    public static class Preference {
        @ObjectHelpers.StandardField
        public String name;
        @ObjectHelpers.ToString
        public String value;
        public Type allowed;
        public String description;
        public Object objectValue;
        @ObjectHelpers.ToString
        public GroupData group = new GroupData("General").setSortOrder(0);
        public int sort = 100;

        public Preference(String name, String def, Type allowed, String description) {
            this.name = name;
            this.value = def;
            this.allowed = allowed;
            this.description = description;
        }

        public Preference(String name, String def, Type allowed, String description, GroupData group) {
            this(name, def, allowed, description);
            this.group = group;
        }

        public Preference(String name, String def, Type allowed, String description, int sort) {
            this(name, def, allowed, description);
            this.sort = sort;
        }

        public Preference(String name, String def, Type allowed, String description, GroupData group, int sort) {
            this(name, def, allowed, description, group);
            this.sort = sort;
        }

        public String toString() {
            return ObjectHelpers.DoToString(this);
        }

        public boolean equals(Object o) {
            return ObjectHelpers.DoEquals(this, o);
        }

        public int hashCode() {
            return ObjectHelpers.DoHashCode(this);
        }
    }

    public static class GroupData
    implements Comparable<GroupData> {
        private final String name;
        private int sort = 100;
        private String description = null;

        public GroupData(String name) {
            this.name = name;
        }

        public GroupData setSortOrder(int sort) {
            this.sort = sort;
            return this;
        }

        public GroupData setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public int getSort() {
            return this.sort;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public int compareTo(GroupData o) {
            if (this.sort < o.sort) {
                return -1;
            }
            if (this.sort > o.sort) {
                return 1;
            }
            return this.name.compareTo(o.name);
        }
    }

    public static enum Type {
        NUMBER,
        BOOLEAN,
        STRING,
        INT,
        DOUBLE,
        FILE;

    }
}

