/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import com.laytonsmith.PureUtilities.SimpleVersion;
import com.laytonsmith.PureUtilities.Version;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SemVer2
implements Version,
Comparable<SemVer2> {
    private final int major;
    private final int minor;
    private final int patch;
    private final String prerelease;
    private final String buildMetaData;
    private static final Pattern PATTERN = Pattern.compile("(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");

    public SemVer2(String version) throws IllegalArgumentException {
        Matcher m = PATTERN.matcher(version);
        if (m.find()) {
            try {
                this.major = Integer.parseInt(m.group(1));
                this.minor = Integer.parseInt(m.group(2));
                this.patch = Integer.parseInt(m.group(3));
                this.prerelease = m.group(4) == null ? "" : m.group(4);
                this.buildMetaData = m.group(5) == null ? "" : m.group(5);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Version numbers must be integers", e);
            }
        } else {
            throw new IllegalArgumentException("Invalid version string provided");
        }
    }

    public SemVer2(int major, int minor, int patch, String prerelease) {
        this(major, minor, patch, prerelease, "");
    }

    public SemVer2(int major, int minor, int patch, String prerelease, String buildMetaData) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.prerelease = prerelease;
        this.buildMetaData = buildMetaData;
    }

    public SemVer2(int major, int minor, int patch) {
        this(major, minor, patch, "", "");
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }

    @Override
    public int getSupplemental() {
        return this.patch;
    }

    public int getPatch() {
        return this.patch;
    }

    public String getPrerelease() {
        return this.prerelease;
    }

    public String getBuildMetaData() {
        return this.buildMetaData;
    }

    @Override
    public String toString() {
        String s = this.major + "." + this.minor + "." + this.patch;
        if (!"".equals(this.prerelease)) {
            s = s + "-" + this.prerelease;
        }
        if (!"".equals(this.buildMetaData)) {
            s = s + "+" + this.buildMetaData;
        }
        return s;
    }

    private int compareIdentifiers(String a, String b) {
        boolean anum = false;
        try {
            Long.parseLong(a);
            anum = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        boolean bnum = false;
        try {
            Long.parseLong(b);
            bnum = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Integer r = a.equals(b) ? 0 : (anum && !bnum ? -1 : (bnum && !anum ? 1 : Integer.MAX_VALUE));
        if (r != Integer.MAX_VALUE) {
            return r;
        }
        if (anum && bnum) {
            return Long.valueOf(a).compareTo(Long.valueOf(b));
        }
        return a.compareTo(b);
    }

    private int comparePre(SemVer2 other) {
        String[] thisParts = this.prerelease.split("\\.", 0);
        if (this.prerelease.equals("")) {
            thisParts = new String[]{};
        }
        String[] thatParts = other.prerelease.split("\\.", 0);
        if (other.prerelease.equals("")) {
            thatParts = new String[]{};
        }
        if (thisParts.length > 0 && thatParts.length == 0) {
            return -1;
        }
        if (thisParts.length == 0 && thatParts.length > 0) {
            return 1;
        }
        if (thisParts.length == 0 && thatParts.length == 0) {
            return 0;
        }
        int i = 0;
        while (thisParts.length > i || thatParts.length > i) {
            if (thatParts.length <= i) {
                return 1;
            }
            if (thisParts.length <= i) {
                return -1;
            }
            String a = thisParts[i];
            String b = thatParts[i];
            if (!a.equals(b)) {
                return this.compareIdentifiers(a, b);
            }
            ++i;
        }
        return 0;
    }

    @Override
    public int compareTo(SemVer2 o) {
        int[] thisParts = new int[]{this.major, this.minor, this.patch};
        int[] otherParts = new int[]{o.getMajor(), o.getMinor(), o.getSupplemental()};
        for (int i = 0; i < thisParts.length; ++i) {
            int n1 = thisParts[i];
            int n2 = otherParts[i];
            if (n1 < n2) {
                return -1;
            }
            if (n1 <= n2) continue;
            return 1;
        }
        return this.comparePre(o);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SemVer2) {
            SemVer2 v = (SemVer2)obj;
            return this.major == v.getMajor() && this.minor == v.getMinor() && this.patch == v.getSupplemental() && this.comparePre(v) == 0;
        }
        if (obj instanceof Version) {
            Version v = (Version)obj;
            return this.major == v.getMajor() && this.minor == v.getMinor() && this.patch == v.getSupplemental();
        }
        return false;
    }

    public int hashCode() {
        int hash2 = 5;
        hash2 = 97 * hash2 + this.major;
        hash2 = 97 * hash2 + this.minor;
        hash2 = 97 * hash2 + this.patch;
        return hash2;
    }

    @Override
    public boolean lt(Version other) {
        if (other instanceof SemVer2) {
            return this.compareTo((SemVer2)other) < 0;
        }
        return SimpleVersion.checkLT(this, other);
    }

    @Override
    public boolean lte(Version other) {
        if (other instanceof SemVer2 ? this.compareTo((SemVer2)other) == 0 : this.equals(other)) {
            return true;
        }
        return this.lt(other);
    }

    @Override
    public boolean gt(Version other) {
        if (other instanceof SemVer2) {
            return this.compareTo((SemVer2)other) > 0;
        }
        return SimpleVersion.checkGT(this, other);
    }

    @Override
    public boolean gte(Version other) {
        if (other instanceof SemVer2 ? this.compareTo((SemVer2)other) == 0 : this.equals(other)) {
            return true;
        }
        return this.gt(other);
    }
}

