/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.VirtualFS;

import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.VirtualFS.VirtualFile;
import com.laytonsmith.PureUtilities.VirtualFS.VirtualFileSystem;
import com.laytonsmith.PureUtilities.VirtualFS.VirtualGlob;
import com.laytonsmith.libs.org.yaml.snakeyaml.DumperOptions;
import com.laytonsmith.libs.org.yaml.snakeyaml.Yaml;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class VirtualFileSystemSettings {
    public static final String GENERATED_LINE = "This file is automatically generated, to keep up-to-date with new features.\n# Comments you add to the file will not be retained.\n";
    private static final String SETTING_TYPES;
    private static final Map<VirtualFileSystemSetting, Object> META_DIRECTORY_SETTINGS;
    private Map<VirtualGlob, SettingGroup> settings;
    private boolean hasQuota = false;
    private boolean cordonedOff = false;

    public static String getDefaultSettingsString() {
        return StreamUtils.GetString(VirtualFileSystemSettings.class.getResourceAsStream("example_settings.yml")).replace("%%SETTING_TYPES%%", SETTING_TYPES).replace("%%GENERATED_LINE%%", GENERATED_LINE);
    }

    public static String serialize(Map<VirtualGlob, SettingGroup> settings) {
        DumperOptions options = new DumperOptions();
        options.setPrettyFlow(true);
        Yaml yaml = new Yaml(options);
        HashMap serializable = new HashMap();
        for (VirtualGlob glob : settings.keySet()) {
            HashMap<String, Object> inner = new HashMap<String, Object>();
            for (VirtualFileSystemSetting setting : settings.get((Object)glob).settingGroup.keySet()) {
                inner.put(setting.getName(), settings.get(glob).get(setting));
            }
            serializable.put(glob.toString(), inner);
        }
        return yaml.dump(serializable);
    }

    public static Map<VirtualGlob, SettingGroup> deserialize(String settings) {
        Yaml yaml = new Yaml();
        Map unserialized = (Map)yaml.load(settings);
        HashMap<VirtualGlob, SettingGroup> parsedSettings = new HashMap<VirtualGlob, SettingGroup>();
        if (unserialized != null) {
            for (String glob : unserialized.keySet()) {
                VirtualGlob vglob = new VirtualGlob(glob);
                Map settingGroup = (Map)unserialized.get(glob);
                SettingGroup group = new SettingGroup();
                for (String settingName : settingGroup.keySet()) {
                    VirtualFileSystemSetting s = VirtualFileSystemSetting.getSettingByName(settingName);
                    Object value = settingGroup.get(settingName);
                    group.set(s, value);
                }
                parsedSettings.put(vglob, group);
            }
        }
        return parsedSettings;
    }

    public VirtualFileSystemSettings(File settingsFile) throws IOException {
        this(settingsFile.exists() ? FileUtil.read(settingsFile) : "");
        FileUtil.write(VirtualFileSystemSettings.getDefaultSettingsString() + VirtualFileSystemSettings.serialize(this.settings), settingsFile);
    }

    public VirtualFileSystemSettings(String unparsedSettings) {
        this((HashMap)VirtualFileSystemSettings.deserialize(unparsedSettings));
    }

    public VirtualFileSystemSettings(Map<VirtualGlob, SettingGroup> settings) {
        this.settings = new HashMap<VirtualGlob, SettingGroup>(settings);
        this.settings.put(new VirtualGlob(VirtualFileSystem.META_DIRECTORY), new SettingGroup(META_DIRECTORY_SETTINGS));
        for (VirtualGlob g2 : settings.keySet()) {
            SettingGroup s = settings.get(g2);
            if (s.settingGroup.keySet().contains((Object)VirtualFileSystemSetting.QUOTA) && (Integer)s.settingGroup.get((Object)VirtualFileSystemSetting.QUOTA) >= 0) {
                if (g2.matches(new VirtualFile("/"))) {
                    this.hasQuota = true;
                } else {
                    throw new IllegalArgumentException("The \"quota\" setting can only be applied to the root of the file system at this time but it was set on " + g2.toString() + ".");
                }
            }
            if (!s.settingGroup.keySet().contains((Object)VirtualFileSystemSetting.CORDONED_OFF) || !((Boolean)s.settingGroup.get((Object)VirtualFileSystemSetting.CORDONED_OFF)).booleanValue()) continue;
            if (g2.matches(new VirtualFile("/"))) {
                this.cordonedOff = true;
                continue;
            }
            throw new IllegalArgumentException("The \"cordoned-off\" setting can only be applied to the root of the file system but it was set on " + g2.toString() + ".");
        }
    }

    public Object getSetting(VirtualFile file, VirtualFileSystemSetting setting) {
        TreeSet<VirtualGlob> matchedGlobs = new TreeSet<VirtualGlob>();
        for (VirtualGlob glob : this.settings.keySet()) {
            if (!glob.matches(file)) continue;
            matchedGlobs.add(glob);
        }
        if (matchedGlobs.isEmpty()) {
            return setting.getDef();
        }
        if (matchedGlobs.size() == 1) {
            return this.settings.get(matchedGlobs.first()).get(setting);
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean hasQuota() {
        return this.hasQuota;
    }

    public boolean isCordonedOff() {
        return this.cordonedOff;
    }

    static {
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        for (VirtualFileSystemSetting setting : VirtualFileSystemSetting.values()) {
            String s = "Setting name: " + setting.getName() + "\n# Default value: " + setting.getDef().toString() + "\n# Description: " + setting.getDescription() + "\n";
            list.add((CallSite)((Object)s));
        }
        SETTING_TYPES = StringUtils.Join(list, "\n# ");
        META_DIRECTORY_SETTINGS = new EnumMap<VirtualFileSystemSetting, Object>(VirtualFileSystemSetting.class);
        META_DIRECTORY_SETTINGS.put(VirtualFileSystemSetting.HIDDEN, true);
    }

    public static class SettingGroup {
        private Map<VirtualFileSystemSetting, Object> settingGroup;

        public SettingGroup() {
            this.settingGroup = new EnumMap<VirtualFileSystemSetting, Object>(VirtualFileSystemSetting.class);
        }

        public SettingGroup(Map<VirtualFileSystemSetting, Object> settingGroup) {
            this.settingGroup = settingGroup;
        }

        public void set(VirtualFileSystemSetting setting, Object value) {
            this.settingGroup.put(setting, value);
        }

        public Object get(VirtualFileSystemSetting setting) {
            if (this.settingGroup.containsKey((Object)setting)) {
                return this.settingGroup.get((Object)setting);
            }
            return setting.getDef();
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            for (VirtualFileSystemSetting s : this.settingGroup.keySet()) {
                b.append(s.getName()).append(": ").append(this.settingGroup.get((Object)s)).append("; ");
            }
            return b.toString().trim();
        }
    }

    public static enum VirtualFileSystemSetting {
        HIDDEN("hidden", false, "If true, the file system will not allow the file or directory to be created, and if a file or directory already exists, it will not be exposed. This is essentially a way to revoke both read and write privileges."),
        QUOTA("quota", -1, "Sets the quota for the total list of files or folders that match this glob. Quotas for a cordoned off file system will only affect files that are in the virtual file system, and file sizes of externally created files won't count, but in a uncordoned file system, all files that match this glob are calculated. Due to real time changes in file system size, for directory based globs, this quota may not be enforced precisely, however, it should generally be close. If the quota is set to -1, the quota is unrestricted, and if 0, it is \"full\". The unit of measure is bytes, so 1024 is a KB. This value is only applicable to the glob **, meaning that the quota can only be applied per entire virtual file system."),
        READONLY("readonly", false, "If true, this file or folder will not be writable."),
        CORDONED_OFF("cordoned-off", false, "If true, files and folders in this directory will not appear to the virtual file system, unless the file was created from within the virtual file system. This glob must be the ** glob, meaning that either the whole file system is cordoned off, or the whole file system is not cordoned off."),
        FOLDER_DEPTH("folder-depth", -1, "The number of folders deep that will be allowed to be created in this directory. The glob must be a directory if this is anything other than -1. -1 means that the number of sub folders is unrestricted, 0 means that no folders can be created inside this one. This does not affect existing folder structure.");

        private String name;
        private Object def;
        private String description;

        private VirtualFileSystemSetting(String name, Object def, String description) {
            this.name = name;
            this.def = def;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public Object getDef() {
            return this.def;
        }

        public String getDescription() {
            return this.description;
        }

        static VirtualFileSystemSetting getSettingByName(String name) {
            for (VirtualFileSystemSetting s : VirtualFileSystemSetting.values()) {
                if (!s.getName().equals(name)) continue;
                return s;
            }
            return null;
        }
    }
}

