/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.commandhelper;

import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.StaticLayer;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCPlayer;
import com.laytonsmith.abstraction.enums.MCChatColor;
import com.laytonsmith.commandhelper.CommandHelperFileLocations;
import com.laytonsmith.core.MethodScriptCompiler;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.compiler.TokenStream;
import com.laytonsmith.core.compiler.analysis.StaticAnalysis;
import com.laytonsmith.core.constructs.IVariable;
import com.laytonsmith.core.environments.CommandHelperEnvironment;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.environments.RuntimeMode;
import com.laytonsmith.core.environments.StaticRuntimeEnv;
import com.laytonsmith.core.exceptions.CancelCommandException;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.io.File;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class CommandHelperInterpreterListener
implements Listener {
    private final Set<String> interpreterMode = Collections.synchronizedSet(new HashSet());
    private final Map<String, String> multilineMode = new HashMap<String, String>();
    private final Map<String, Environment> interpreterEnvs = new HashMap<String, Environment>();
    private final Map<String, StaticAnalysis> interpreterSAs = new HashMap<String, StaticAnalysis>();

    public boolean isInInterpreterMode(String player2) {
        return this.interpreterMode.contains(player2);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (this.interpreterMode.contains(event.getPlayer().getName())) {
            BukkitMCPlayer p2 = new BukkitMCPlayer((Entity)event.getPlayer());
            event.setCancelled(true);
            StaticLayer.SetFutureRunnable(null, 0L, () -> this.textLine(p2, event.getMessage()));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.interpreterMode.remove(event.getPlayer().getName());
        this.multilineMode.remove(event.getPlayer().getName());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.interpreterMode.contains(event.getPlayer().getName())) {
            BukkitMCPlayer p2 = new BukkitMCPlayer((Entity)event.getPlayer());
            this.textLine(p2, event.getMessage());
            event.setCancelled(true);
        }
    }

    public void textLine(MCPlayer p2, String line) {
        switch (line) {
            case "-": {
                this.interpreterMode.remove(p2.getName());
                this.interpreterEnvs.remove(p2.getName());
                this.interpreterSAs.remove(p2.getName());
                Static.SendMessage(p2, String.valueOf((Object)MCChatColor.YELLOW) + "Now exiting interpreter mode");
                break;
            }
            case ">>>": {
                if (this.multilineMode.containsKey(p2.getName())) {
                    Static.SendMessage(p2, String.valueOf((Object)MCChatColor.RED) + "You are already in multiline mode!");
                    break;
                }
                this.multilineMode.put(p2.getName(), "");
                Static.SendMessage(p2, String.valueOf((Object)MCChatColor.YELLOW) + "You are now in multiline mode. Type <<< on a line by itself to execute.");
                Static.SendMessage(p2, ":" + String.valueOf((Object)MCChatColor.GRAY) + ">>>");
                break;
            }
            case "<<<": {
                Static.SendMessage(p2, ":" + String.valueOf((Object)MCChatColor.GRAY) + "<<<");
                String script = this.multilineMode.get(p2.getName());
                this.multilineMode.remove(p2.getName());
                try {
                    this.execute(script, p2);
                    break;
                }
                catch (ConfigCompileException e) {
                    Static.SendMessage(p2, String.valueOf((Object)MCChatColor.RED) + e.getMessage() + ":" + e.getLineNum());
                    break;
                }
                catch (ConfigCompileGroupException ex) {
                    for (ConfigCompileException e : ex.getList()) {
                        Static.SendMessage(p2, String.valueOf((Object)MCChatColor.RED) + e.getMessage() + ":" + e.getLineNum());
                    }
                    break;
                }
            }
            case "~": {
                if (this.interpreterEnvs.containsKey(p2.getName())) {
                    Environment env = this.interpreterEnvs.get(p2.getName());
                    Static.SendMessage(p2, String.valueOf((Object)MCChatColor.GRAY) + "Environment cleared.");
                    env.getEnv(GlobalEnv.class).GetProcs().clear();
                    env.getEnv(GlobalEnv.class).GetVarList().clear();
                    for (Thread t : env.getEnv(StaticRuntimeEnv.class).GetDaemonManager().getActiveThreads()) {
                        t.interrupt();
                    }
                    env.getEnv(StaticRuntimeEnv.class).getExecutionQueue().stopAll();
                    env.getEnv(StaticRuntimeEnv.class).getIncludeCache().clear();
                }
                if (!this.interpreterSAs.containsKey(p2.getName())) break;
                this.interpreterSAs.remove(p2.getName());
                break;
            }
            default: {
                if (this.multilineMode.containsKey(p2.getName())) {
                    this.multilineMode.put(p2.getName(), this.multilineMode.get(p2.getName()) + line + "\n");
                    Static.SendMessage(p2, ":" + String.valueOf((Object)MCChatColor.GRAY) + line);
                    break;
                }
                try {
                    this.execute(line, p2);
                    break;
                }
                catch (ConfigCompileException ex) {
                    Static.SendMessage(p2, String.valueOf((Object)MCChatColor.RED) + ex.getMessage());
                    break;
                }
                catch (ConfigCompileGroupException e) {
                    for (ConfigCompileException ex : e.getList()) {
                        Static.SendMessage(p2, String.valueOf((Object)MCChatColor.RED) + ex.getMessage());
                    }
                }
            }
        }
    }

    public void execute(String script, MCPlayer p2) throws ConfigCompileException, ConfigCompileGroupException {
        Mixed mixed;
        Environment env;
        TokenStream stream = MethodScriptCompiler.lex(script, null, new File("Interpreter"), true);
        ParseTree tree = MethodScriptCompiler.compile(stream, env = this.interpreterEnvs.computeIfAbsent(p2.getName(), player2 -> {
            StaticRuntimeEnv staticRuntimeEnv = Static.getAliasCore().getStaticRuntimeEnv();
            GlobalEnv gEnv = new GlobalEnv(CommandHelperFileLocations.getDefault().getConfigDirectory(), EnumSet.of(RuntimeMode.EMBEDDED, RuntimeMode.INTERPRETER));
            gEnv.SetDynamicScriptingMode(true);
            CommandHelperEnvironment cEnv = new CommandHelperEnvironment();
            cEnv.SetPlayer(p2);
            CompilerEnvironment compilerEnv = new CompilerEnvironment();
            compilerEnv.setLogCompilerWarnings(false);
            Environment e = Environment.createEnvironment(gEnv, staticRuntimeEnv, cEnv, compilerEnv);
            return e;
        }), env.getEnvClasses(), this.interpreterSAs.computeIfAbsent(p2.getName(), player2 -> {
            StaticAnalysis sa = new StaticAnalysis(true);
            sa.setLocalDisabled(true);
            return sa;
        }));
        if (tree.getChildren().size() == 1 && (mixed = tree.getChildAt(0).getData()) instanceof IVariable) {
            IVariable ivar = (IVariable)mixed;
            Mixed i = env.getEnv(GlobalEnv.class).GetVarList().get(ivar.getVariableName(), ivar.getTarget(), env).ival();
            Static.SendMessage(p2, ":" + String.valueOf((Object)MCChatColor.GREEN) + i.val());
            return;
        }
        boolean isInterpeterMode = this.interpreterMode.remove(p2.getName());
        try {
            env.getEnv(StaticRuntimeEnv.class).getIncludeCache().executeAutoIncludes(env, null);
            MethodScriptCompiler.execute(tree, env, output -> {
                if ((output = output.trim()).isEmpty()) {
                    Static.SendMessage(p2, ":");
                } else if (output.startsWith("/")) {
                    Static.SendMessage(p2, ":" + String.valueOf((Object)MCChatColor.YELLOW) + output);
                    p2.chat(output);
                } else {
                    Static.SendMessage(p2, ":" + String.valueOf((Object)MCChatColor.GREEN) + output);
                }
                if (isInterpeterMode) {
                    this.interpreterMode.add(p2.getName());
                } else {
                    Static.SendMessage(p2, String.valueOf((Object)MCChatColor.YELLOW) + "No longer in interpreter mode.");
                }
            }, null);
            return;
        }
        catch (CancelCommandException i) {
        }
        catch (ConfigRuntimeException e) {
            ConfigRuntimeException.HandleUncaughtException(e, env);
            Static.SendMessage(p2, String.valueOf((Object)MCChatColor.RED) + e.toString());
        }
        catch (Exception e) {
            Static.SendMessage(p2, String.valueOf((Object)MCChatColor.RED) + e.toString());
            Static.getLogger().log(Level.SEVERE, null, e);
        }
        if (isInterpeterMode) {
            this.interpreterMode.add(p2.getName());
        }
    }

    public void startInterpret(String playername) {
        this.interpreterMode.add(playername);
    }
}

