/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.asm;

import com.laytonsmith.PureUtilities.CommandExecutor;
import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.PureUtilities.Common.OSUtils;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.SimpleVersion;
import com.laytonsmith.PureUtilities.TermColors;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.PureUtilities.Web.RequestSettings;
import com.laytonsmith.PureUtilities.Web.WebUtility;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;

public class AsmInstaller {
    private static void log(String output) {
        StreamUtils.GetSystemOut().println(output + TermColors.RESET);
    }

    public void install(boolean nonInteractive) throws IOException, InterruptedException {
        if (OSUtils.GetOSBitDepth() != OSUtils.BitDepth.B64) {
            throw new UnsupportedOperationException("This is only supported on 64 bit systems currently.");
        }
        if (OSUtils.GetOS().isWindows()) {
            this.installWindows(nonInteractive);
        } else if (OSUtils.GetOS().isLinux()) {
            this.installLinux(nonInteractive);
        } else if (OSUtils.GetOS().isMac()) {
            this.installMac(nonInteractive);
        } else {
            throw new UnsupportedOperationException("Toolchain installation not supported on this platform");
        }
    }

    private void installWindows(boolean nonInteractive) throws IOException, InterruptedException {
        String installerUrl = null;
        String destFilename = null;
        HashMap<CallSite, String> llvmExtras = new HashMap<CallSite, String>();
        String extrasBase = "https://raw.githubusercontent.com/LadyCailin/MethodScriptExtra/master";
        String llvmExtrasBase = extrasBase + "/installers/llvm/12.0.1/x64/";
        llvmExtras.put((CallSite)((Object)(llvmExtrasBase + "llc/llc.exe")), "llc.exe");
        llvmExtras.put((CallSite)((Object)(llvmExtrasBase + "lli/lli.exe")), "lli.exe");
        llvmExtras.put((CallSite)((Object)(llvmExtrasBase + "llvm-as/llvm-as.exe")), "llvm-as.exe");
        llvmExtras.put((CallSite)((Object)(llvmExtrasBase + "llvm-dis/llvm-dis.exe")), "llvm-dis.exe");
        llvmExtras.put((CallSite)((Object)(llvmExtrasBase + "opt/opt.exe")), "opt.exe");
        llvmExtras.put((CallSite)((Object)(llvmExtrasBase + "llvm-link/llvm-link.exe")), "llvm-link.exe");
        String redistUrl = extrasBase + "/installers/winsdk/10.0.19041.0/winsdksetup.exe";
        String buildToolsUrl = extrasBase + "/installers/winsdk/MSVC/vs_BuildTools.exe";
        if (OSUtils.GetOSBitDepth() == OSUtils.BitDepth.B64) {
            AsmInstaller.log(TermColors.GREEN + "Detected 64 bit Windows");
            installerUrl = "https://github.com/llvm/llvm-project/releases/download/llvmorg-12.0.1/LLVM-12.0.1-win64.exe";
            destFilename = "LLVM-12.0.1-win64.exe";
        }
        String redistFileName = "winsdksetup.exe";
        String buildToolsFileName = "vs_BuildTools.exe";
        File lld = new File("C:\\Program Files\\LLVM\\bin\\lld-link.exe");
        File winSDK = new File("C:\\Program Files (x86)\\Windows Kits\\10\\Lib\\10.0.19041.0");
        AsmInstaller.log(TermColors.GREEN + "Installing LLVM...");
        if (!lld.exists() || !CommandExecutor.Execute(lld.getAbsolutePath(), "--version").contains("LLD 12.0.1")) {
            if (new File("C:\\ProgramData\\chocolatey\\bin\\choco.exe").exists()) {
                CommandExecutor.ExecuteWithRedirect("choco", "install", "llvm", "-y");
            } else {
                File exe = this.download(installerUrl, destFilename);
                AsmInstaller.log(TermColors.YELLOW + "Please note, when installing LLVM, install in the standard location, \"C:\\Program Files\\LLVM\", otherwise the toolchain will not work." + TermColors.reset());
                CommandExecutor.Execute(exe.getAbsolutePath());
            }
        }
        AsmInstaller.log(TermColors.GREEN + "Installing extras...");
        File root = new File("C:\\Program Files\\LLVM\\bin\\");
        for (Map.Entry entry : llvmExtras.entrySet()) {
            String url = (String)entry.getKey();
            String filename = (String)entry.getValue();
            File file = new File(root, filename);
            if (file.exists() && CommandExecutor.Execute(file.getAbsolutePath(), "--version").contains("LLVM version 12.0.1")) continue;
            AsmInstaller.log("Downloading " + filename);
            File exe = this.download(url, filename);
            AsmInstaller.log("Moving " + filename + " into " + file.getAbsolutePath() + ".");
            try {
                FileUtil.move(exe, file);
                exe.deleteOnExit();
            }
            catch (IOException ex) {
                AsmInstaller.log(TermColors.RED + ex.getMessage() + TermColors.reset());
            }
        }
        if (!winSDK.exists()) {
            File redist = this.download(redistUrl, redistFileName);
            AsmInstaller.log(TermColors.GREEN + "Installing Windows 10 SDK");
            CommandExecutor.Execute(redist.getAbsolutePath(), "/quiet");
        }
        boolean buildToolsUpToDate = false;
        SimpleVersion minBuildToolsVersion = new SimpleVersion(14, 29, 30037);
        Version installedVersion = AsmInstaller.getWindowsInstalledBuildToolsVersion(true);
        if (installedVersion != null && installedVersion.gte(minBuildToolsVersion)) {
            buildToolsUpToDate = true;
        }
        if (!buildToolsUpToDate) {
            File buildToolsInstaller = this.download(buildToolsUrl, buildToolsFileName);
            AsmInstaller.log(TermColors.GREEN + "Installing MSVC Build Tools");
            String[] args2 = new String[]{buildToolsInstaller.getAbsolutePath(), "--passive", "--norestart", "--downloadThenInstall", "--add", "Microsoft.VisualStudio.Component.VC.Tools.x86.x64"};
            CommandExecutor.Execute(args2);
        }
        AsmInstaller.log(TermColors.GREEN + "Done.");
    }

    public static Version getWindowsInstalledBuildToolsVersion(boolean verbose) {
        File[] buildToolLocations = new File[]{new File("C:\\Program Files (x86)\\Microsoft Visual Studio\\2019\\Enterprise\\VC\\Tools\\MSVC\\"), new File("C:\\Program Files (x86)\\Microsoft Visual Studio\\2019\\BuildTools\\VC\\Tools\\MSVC\\")};
        SimpleVersion latestVersion = new SimpleVersion(0, 0, 0);
        for (File buildTools : buildToolLocations) {
            if (!buildTools.exists() || buildTools.listFiles().length == 0) {
                if (!verbose) continue;
                System.out.println("No installed build tools found in " + buildTools.getAbsolutePath() + ".");
                continue;
            }
            for (File installedBuildToolVersion : buildTools.listFiles()) {
                String[] versionParts;
                SimpleVersion v;
                if (verbose) {
                    System.out.println("Found build tools version " + String.valueOf(installedBuildToolVersion));
                }
                if (!(v = new SimpleVersion(Integer.parseInt((versionParts = installedBuildToolVersion.getName().split("\\."))[0]), Integer.parseInt(versionParts[1]), Integer.parseInt(versionParts[2]))).gt(latestVersion)) continue;
                latestVersion = v;
            }
        }
        return latestVersion;
    }

    public static File getWindowsBuildToolsLocation() {
        File[] buildToolLocations;
        Version version = AsmInstaller.getWindowsInstalledBuildToolsVersion(false);
        if (version.equals(new SimpleVersion(0, 0, 0))) {
            return null;
        }
        for (File buildTool : buildToolLocations = new File[]{new File("C:\\Program Files (x86)\\Microsoft Visual Studio\\2019\\Enterprise\\VC\\Tools\\MSVC\\"), new File("C:\\Program Files (x86)\\Microsoft Visual Studio\\2019\\BuildTools\\VC\\Tools\\MSVC\\")}) {
            File withVersion = new File(buildTool, version.toString());
            if (withVersion.exists()) {
                return withVersion;
            }
            for (File fullVersion : buildTool.listFiles()) {
                try {
                    if (!fullVersion.getCanonicalPath().startsWith(withVersion.getCanonicalPath())) continue;
                    return fullVersion;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private void installLinux(boolean nonInteractive) throws IOException, InterruptedException {
        String distro = OSUtils.GetLinuxDistro().toLowerCase();
        if (!distro.contains("debian") && !distro.contains("ubuntu")) {
            throw new UnsupportedOperationException("Your linux distribution is not supported yet. It may be a simple matter to add support, however, please file an issue (or PR!) if you're interested in adding support for " + OSUtils.GetLinuxDistro());
        }
        this.installDebianBased(nonInteractive);
    }

    private void installDebianBased(boolean nonInteractive) throws IOException, InterruptedException {
        boolean isUbuntu = CommandExecutor.Execute("lsb_release", "-a").contains("buntu");
        if (!isUbuntu) {
            AsmInstaller.log(TermColors.RED + "Only Ubuntu flavors are officially supported. You may run into installation failures.");
        }
        if (OSUtils.GetOSBitDepth() != OSUtils.BitDepth.B64) {
            AsmInstaller.log(TermColors.RED + "Only 64 bit systems are supported.");
            return;
        }
        AsmInstaller.log(TermColors.GREEN + "Detected 64 bit Linux" + TermColors.RESET);
        AsmInstaller.log(TermColors.GREEN + "Updating apt db" + TermColors.RESET);
        new CommandExecutor("apt", "update").setSystemInputsAndOutputs().start().waitFor();
        AsmInstaller.log(TermColors.GREEN + "Installing llvm-12" + TermColors.RESET);
        new CommandExecutor("apt", "install", "llvm-12").setSystemInputsAndOutputs().start().waitFor();
        AsmInstaller.log(TermColors.GREEN + "Installing lld-12" + TermColors.RESET);
        new CommandExecutor("apt", "install", "lld-12").setSystemInputsAndOutputs().start().waitFor();
    }

    private void installMac(boolean nonInteractive) throws IOException, InterruptedException {
        String brewLocation = CommandExecutor.Execute("which", "brew");
        if (!"/usr/local/bin/brew\n".equals(brewLocation)) {
            AsmInstaller.log(TermColors.RED + "Homebrew is required for installation. Please install homebrew with " + TermColors.RESET + "/bin/bash -c \"$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/HEAD/install.sh)\"");
            return;
        }
        AsmInstaller.log(TermColors.GREEN + "Updating brew formulae" + TermColors.RESET);
        CommandExecutor.ExecuteWithRedirect("sudo", "brew", "update");
        AsmInstaller.log(TermColors.GREEN + "Installing llvm@12" + TermColors.RESET);
        CommandExecutor.ExecuteWithRedirect("sudo", "brew", "install", "llvm@12");
    }

    private File download(String installerUrl, String destFilename) throws IOException, InterruptedException {
        AsmInstaller.log("Downloading installer from " + installerUrl);
        Path tmp = Files.createTempDirectory("llvm-installer", new FileAttribute[0]);
        tmp.toFile().deleteOnExit();
        File dest = new File(tmp.toFile(), destFilename);
        RequestSettings rs = new RequestSettings();
        rs.setBlocking(true);
        rs.setDownloadTo(dest);
        WebUtility.GetPage(new URL(installerUrl), rs);
        return dest;
    }

    public static boolean validateToolchain() {
        if (OSUtils.GetOS().isWindows()) {
            return AsmInstaller.validateWindowsToolchain();
        }
        if (OSUtils.GetOS().isLinux()) {
            return AsmInstaller.validateLinuxToolchain();
        }
        if (OSUtils.GetOS().isMac()) {
            return AsmInstaller.validateMacToolchain();
        }
        AsmInstaller.log("Toolchain installation not supported on this platform");
        return false;
    }

    public static boolean validateWindowsToolchain() {
        try {
            File lld = new File("C:\\Program Files\\LLVM\\bin\\lld-link.exe");
            File llc = new File("C:\\Program Files\\LLVM\\bin\\llc.exe");
            File winSDK = new File("C:\\Program Files (x86)\\Windows Kits\\10\\Lib\\10.0.19041.0");
            File msvc = AsmInstaller.getWindowsBuildToolsLocation();
            if (!lld.exists() || !CommandExecutor.Execute(lld.getAbsolutePath(), "--version").contains("LLD 12.0.1")) {
                AsmInstaller.log("Missing correct version of lld tool, please re-install the toolchain.");
                return false;
            }
            if (!llc.exists() || !CommandExecutor.Execute(llc.getAbsolutePath(), "--version").contains("LLVM version 12.0.1")) {
                AsmInstaller.log("Missing correct version of llc tool, please re-install the toolchain.");
                return false;
            }
            if (!winSDK.exists()) {
                AsmInstaller.log("Missing correct version of Windows SDK, please re-install the toolchain.");
                return false;
            }
            if (msvc == null || !msvc.exists()) {
                AsmInstaller.log("Missing MSVC BuildTools, please re-install the toolchain.");
            }
            return true;
        }
        catch (IOException | InterruptedException ex) {
            return false;
        }
    }

    public static boolean validateLinuxToolchain() {
        String[] which = new String[]{"llc-12", "ld.lld-12"};
        try {
            for (String bin : which) {
                if (!CommandExecutor.Execute("which", bin).isBlank()) continue;
                AsmInstaller.log("Missing one or more toolchain file, please re-install the toolchain.");
                return false;
            }
            return true;
        }
        catch (IOException | InterruptedException e) {
            return false;
        }
    }

    public static boolean validateMacToolchain() {
        if (!new File("/usr/local/opt/llvm@12/bin/clang").exists()) {
            AsmInstaller.log("Please (re)-install the toolchain.");
            return false;
        }
        return true;
    }
}

