/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit.events;

import com.laytonsmith.abstraction.MCCraftingInventory;
import com.laytonsmith.abstraction.MCEnchantmentOffer;
import com.laytonsmith.abstraction.MCHumanEntity;
import com.laytonsmith.abstraction.MCInventory;
import com.laytonsmith.abstraction.MCInventoryView;
import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.MCRecipe;
import com.laytonsmith.abstraction.blocks.MCBlock;
import com.laytonsmith.abstraction.bukkit.BukkitConvertor;
import com.laytonsmith.abstraction.bukkit.BukkitMCCraftingInventory;
import com.laytonsmith.abstraction.bukkit.BukkitMCEnchantmentOffer;
import com.laytonsmith.abstraction.bukkit.BukkitMCInventory;
import com.laytonsmith.abstraction.bukkit.BukkitMCInventoryView;
import com.laytonsmith.abstraction.bukkit.BukkitMCItemStack;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCBlock;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCHumanEntity;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCPlayer;
import com.laytonsmith.abstraction.enums.MCClickType;
import com.laytonsmith.abstraction.enums.MCDragType;
import com.laytonsmith.abstraction.enums.MCEnchantment;
import com.laytonsmith.abstraction.enums.MCInventoryAction;
import com.laytonsmith.abstraction.enums.MCResult;
import com.laytonsmith.abstraction.enums.MCSlotType;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCClickType;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCEnchantment;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCInventoryAction;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCResult;
import com.laytonsmith.abstraction.events.MCEnchantItemEvent;
import com.laytonsmith.abstraction.events.MCInventoryClickEvent;
import com.laytonsmith.abstraction.events.MCInventoryCloseEvent;
import com.laytonsmith.abstraction.events.MCInventoryDragEvent;
import com.laytonsmith.abstraction.events.MCInventoryEvent;
import com.laytonsmith.abstraction.events.MCInventoryInteractEvent;
import com.laytonsmith.abstraction.events.MCInventoryOpenEvent;
import com.laytonsmith.abstraction.events.MCItemHeldEvent;
import com.laytonsmith.abstraction.events.MCItemSwapEvent;
import com.laytonsmith.abstraction.events.MCPrepareItemCraftEvent;
import com.laytonsmith.abstraction.events.MCPrepareItemEnchantEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentOffer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Event;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.inventory.InventoryInteractEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;

public class BukkitInventoryEvents {

    public static class BukkitMCPrepareItemCraftEvent
    extends BukkitMCInventoryEvent
    implements MCPrepareItemCraftEvent {
        PrepareItemCraftEvent e;

        public BukkitMCPrepareItemCraftEvent(PrepareItemCraftEvent event) {
            super((InventoryEvent)event);
            this.e = event;
        }

        @Override
        public MCRecipe getRecipe() {
            return BukkitConvertor.BukkitGetRecipe(this.e.getRecipe());
        }

        @Override
        public boolean isRepair() {
            return this.e.isRepair();
        }

        @Override
        public MCCraftingInventory getInventory() {
            return new BukkitMCCraftingInventory(this.e.getInventory());
        }
    }

    public static class BukkitMCItemSwapEvent
    implements MCItemSwapEvent {
        PlayerSwapHandItemsEvent is;

        public BukkitMCItemSwapEvent(PlayerSwapHandItemsEvent event) {
            this.is = event;
        }

        public BukkitMCItemSwapEvent(Event event) {
            this.is = (PlayerSwapHandItemsEvent)event;
        }

        @Override
        public MCPlayer getPlayer() {
            return new BukkitMCPlayer((Entity)this.is.getPlayer());
        }

        @Override
        public Object _GetObject() {
            return this.is;
        }

        @Override
        public MCItemStack getMainHandItem() {
            return new BukkitMCItemStack(this.is.getMainHandItem());
        }

        @Override
        public MCItemStack getOffHandItem() {
            return new BukkitMCItemStack(this.is.getOffHandItem());
        }

        @Override
        public void setMainHandItem(MCItemStack item) {
            this.is.setMainHandItem((ItemStack)item.getHandle());
        }

        @Override
        public void setOffHandItem(MCItemStack item) {
            this.is.setOffHandItem((ItemStack)item.getHandle());
        }
    }

    public static class BukkitMCItemHeldEvent
    implements MCItemHeldEvent {
        PlayerItemHeldEvent ih;

        public BukkitMCItemHeldEvent(PlayerItemHeldEvent event) {
            this.ih = event;
        }

        @Override
        public MCPlayer getPlayer() {
            return new BukkitMCPlayer((Entity)this.ih.getPlayer());
        }

        @Override
        public Object _GetObject() {
            return this.ih;
        }

        @Override
        public int getNewSlot() {
            return this.ih.getNewSlot();
        }

        @Override
        public int getPreviousSlot() {
            return this.ih.getPreviousSlot();
        }
    }

    public static class BukkitMCPrepareItemEnchantEvent
    extends BukkitMCInventoryEvent
    implements MCPrepareItemEnchantEvent {
        PrepareItemEnchantEvent pie;

        public BukkitMCPrepareItemEnchantEvent(PrepareItemEnchantEvent e) {
            super((InventoryEvent)e);
            this.pie = e;
        }

        @Override
        public MCBlock getEnchantBlock() {
            return new BukkitMCBlock(this.pie.getEnchantBlock());
        }

        @Override
        public MCPlayer getEnchanter() {
            return new BukkitMCPlayer((Entity)this.pie.getEnchanter());
        }

        @Override
        public int getEnchantmentBonus() {
            return this.pie.getEnchantmentBonus();
        }

        @Override
        public MCEnchantmentOffer[] getOffers() {
            EnchantmentOffer[] offers = this.pie.getOffers();
            MCEnchantmentOffer[] ret = new MCEnchantmentOffer[offers.length];
            for (int i = 0; i < offers.length; ++i) {
                ret[i] = new BukkitMCEnchantmentOffer(offers[i]);
            }
            return ret;
        }

        @Override
        public MCItemStack getItem() {
            return new BukkitMCItemStack(this.pie.getItem());
        }

        @Override
        public void setItem(MCItemStack i) {
            ItemStack item = this.pie.getItem();
            ItemStack is = ((BukkitMCItemStack)i).asItemStack();
            item.setAmount(is.getAmount());
            item.setType(is.getType());
            item.setItemMeta(is.getItemMeta());
        }
    }

    public static class BukkitMCEnchantItemEvent
    extends BukkitMCInventoryEvent
    implements MCEnchantItemEvent {
        EnchantItemEvent ei;

        public BukkitMCEnchantItemEvent(EnchantItemEvent e) {
            super((InventoryEvent)e);
            this.ei = e;
        }

        @Override
        public MCBlock getEnchantBlock() {
            return new BukkitMCBlock(this.ei.getEnchantBlock());
        }

        @Override
        public MCPlayer GetEnchanter() {
            return new BukkitMCPlayer((Entity)this.ei.getEnchanter());
        }

        @Override
        public Map<MCEnchantment, Integer> getEnchantsToAdd() {
            HashMap<MCEnchantment, Integer> ret = new HashMap<MCEnchantment, Integer>();
            for (Map.Entry ea : this.ei.getEnchantsToAdd().entrySet()) {
                Enchantment key = (Enchantment)ea.getKey();
                Integer value = (Integer)ea.getValue();
                ret.put(BukkitMCEnchantment.valueOfConcrete(key), value);
            }
            return ret;
        }

        @Override
        public void setEnchantsToAdd(Map<MCEnchantment, Integer> enchants) {
            Map ret = this.ei.getEnchantsToAdd();
            ret.clear();
            HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
            for (Map.Entry<MCEnchantment, Integer> ea : enchants.entrySet()) {
                MCEnchantment key = ea.getKey();
                Integer value = ea.getValue();
                enchantments.put((Enchantment)key.getConcrete(), value);
            }
            ItemStack item = this.ei.getItem();
            item.addUnsafeEnchantments(enchantments);
        }

        @Override
        public MCItemStack getItem() {
            return new BukkitMCItemStack(this.ei.getItem());
        }

        @Override
        public void setItem(MCItemStack i) {
            ItemStack item = this.ei.getItem();
            ItemStack is = ((BukkitMCItemStack)i).asItemStack();
            item.setAmount(is.getAmount());
            item.setType(is.getType());
            item.setItemMeta(is.getItemMeta());
        }

        @Override
        public void setExpLevelCost(int level) {
            this.ei.setExpLevelCost(level);
        }

        @Override
        public int getExpLevelCost() {
            return this.ei.getExpLevelCost();
        }

        @Override
        public int whichButton() {
            return this.ei.whichButton();
        }

        @Override
        public int getLevelHint() {
            return this.ei.getLevelHint();
        }

        @Override
        public MCEnchantment getEnchantmentHint() {
            return BukkitMCEnchantment.valueOfConcrete(this.ei.getEnchantmentHint());
        }
    }

    public static class BukkitMCInventoryDragEvent
    extends BukkitMCInventoryInteractEvent
    implements MCInventoryDragEvent {
        InventoryDragEvent id;

        public BukkitMCInventoryDragEvent(InventoryDragEvent e) {
            super((InventoryInteractEvent)e);
            this.id = e;
        }

        @Override
        public Map<Integer, MCItemStack> getNewItems() {
            HashMap<Integer, MCItemStack> ret = new HashMap<Integer, MCItemStack>();
            for (Map.Entry ni : this.id.getNewItems().entrySet()) {
                Integer key = (Integer)ni.getKey();
                ItemStack value = (ItemStack)ni.getValue();
                ret.put(key, new BukkitMCItemStack(value));
            }
            return ret;
        }

        @Override
        public Set<Integer> getRawSlots() {
            return this.id.getRawSlots();
        }

        @Override
        public Set<Integer> getInventorySlots() {
            return this.id.getInventorySlots();
        }

        @Override
        public MCItemStack getCursor() {
            return new BukkitMCItemStack(this.id.getCursor());
        }

        @Override
        public void setCursor(MCItemStack newCursor) {
            this.id.setCursor(((BukkitMCItemStack)newCursor).asItemStack());
        }

        @Override
        public MCItemStack getOldCursor() {
            return new BukkitMCItemStack(this.id.getOldCursor());
        }

        @Override
        public MCDragType getType() {
            return MCDragType.valueOf(this.id.getType().name());
        }
    }

    public static class BukkitMCInventoryClickEvent
    extends BukkitMCInventoryInteractEvent
    implements MCInventoryClickEvent {
        InventoryClickEvent ic;

        public BukkitMCInventoryClickEvent(InventoryClickEvent e) {
            super((InventoryInteractEvent)e);
            this.ic = e;
        }

        @Override
        public MCItemStack getCurrentItem() {
            return new BukkitMCItemStack(this.ic.getCurrentItem());
        }

        @Override
        public MCItemStack getCursor() {
            return new BukkitMCItemStack(this.ic.getCursor());
        }

        @Override
        public int getSlot() {
            return this.ic.getSlot();
        }

        @Override
        public int getRawSlot() {
            return this.ic.getRawSlot();
        }

        @Override
        public int getHotbarButton() {
            return this.ic.getHotbarButton();
        }

        @Override
        public MCSlotType getSlotType() {
            return MCSlotType.valueOf(this.ic.getSlotType().name());
        }

        @Override
        public boolean isLeftClick() {
            return this.ic.getClick().isLeftClick();
        }

        @Override
        public boolean isRightClick() {
            return this.ic.getClick().isRightClick();
        }

        @Override
        public boolean isShiftClick() {
            return this.ic.getClick().isShiftClick();
        }

        @Override
        public boolean isCreativeClick() {
            return this.ic.getClick().isCreativeAction();
        }

        @Override
        public boolean isKeyboardClick() {
            return this.ic.getClick().isKeyboardClick();
        }

        @Override
        public void setCurrentItem(MCItemStack slot) {
            if (slot != null) {
                this.ic.setCurrentItem(((BukkitMCItemStack)slot).asItemStack());
            } else {
                this.ic.setCurrentItem(null);
            }
        }

        @Override
        public void setCursor(MCItemStack cursor) {
            this.ic.setCursor(((BukkitMCItemStack)cursor).asItemStack());
        }

        @Override
        public MCInventoryAction getAction() {
            return (MCInventoryAction)((Object)BukkitMCInventoryAction.getConvertor().getAbstractedEnum(this.ic.getAction()));
        }

        @Override
        public MCClickType getClickType() {
            return (MCClickType)((Object)BukkitMCClickType.getConvertor().getAbstractedEnum(this.ic.getClick()));
        }
    }

    public static class BukkitMCInventoryCloseEvent
    extends BukkitMCInventoryEvent
    implements MCInventoryCloseEvent {
        InventoryCloseEvent ice;

        public BukkitMCInventoryCloseEvent(InventoryCloseEvent e) {
            super((InventoryEvent)e);
            this.ice = e;
        }

        @Override
        public MCHumanEntity getPlayer() {
            return new BukkitMCHumanEntity((Entity)this.ice.getPlayer());
        }
    }

    public static class BukkitMCInventoryOpenEvent
    extends BukkitMCInventoryEvent
    implements MCInventoryOpenEvent {
        InventoryOpenEvent ioe;

        public BukkitMCInventoryOpenEvent(InventoryOpenEvent e) {
            super((InventoryEvent)e);
            this.ioe = e;
        }

        @Override
        public MCHumanEntity getPlayer() {
            return new BukkitMCHumanEntity((Entity)this.ioe.getPlayer());
        }
    }

    public static class BukkitMCInventoryInteractEvent
    extends BukkitMCInventoryEvent
    implements MCInventoryInteractEvent {
        InventoryInteractEvent iie;

        public BukkitMCInventoryInteractEvent(InventoryInteractEvent e) {
            super((InventoryEvent)e);
            this.iie = e;
        }

        @Override
        public MCHumanEntity getWhoClicked() {
            return new BukkitMCHumanEntity((Entity)this.iie.getWhoClicked());
        }

        @Override
        public void setResult(MCResult newResult) {
            this.iie.setResult(Event.Result.valueOf((String)newResult.name()));
        }

        @Override
        public MCResult getResult() {
            return (MCResult)((Object)BukkitMCResult.getConvertor().getAbstractedEnum(this.iie.getResult()));
        }

        @Override
        public boolean isCancelled() {
            return this.iie.isCancelled();
        }

        @Override
        public void setCancelled(boolean cancelled) {
            this.iie.setCancelled(cancelled);
        }
    }

    public static class BukkitMCInventoryEvent
    implements MCInventoryEvent {
        InventoryEvent event;

        public BukkitMCInventoryEvent(InventoryEvent e) {
            this.event = e;
        }

        @Override
        public List<MCHumanEntity> getViewers() {
            ArrayList<MCHumanEntity> viewers = new ArrayList<MCHumanEntity>();
            for (HumanEntity viewer : this.event.getViewers()) {
                viewers.add(new BukkitMCHumanEntity((Entity)viewer));
            }
            return viewers;
        }

        @Override
        public MCInventoryView getView() {
            return new BukkitMCInventoryView(this.event.getView());
        }

        @Override
        public MCInventory getInventory() {
            return new BukkitMCInventory(this.event.getInventory());
        }

        @Override
        public Object _GetObject() {
            return this.event;
        }
    }
}

