/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.enums.bukkit;

import com.laytonsmith.abstraction.enums.MCPotionType;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.Target;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.potion.PotionType;

public class BukkitMCPotionType
extends MCPotionType<PotionType> {
    private static final Map<PotionType, MCPotionType> BUKKIT_MAP = new HashMap<PotionType, MCPotionType>();

    public BukkitMCPotionType(MCPotionType.MCVanillaPotionType vanillaEffect, PotionType effect) {
        super(vanillaEffect, effect);
    }

    @Override
    public String name() {
        return this.getAbstracted() == MCPotionType.MCVanillaPotionType.UNKNOWN ? ((PotionType)this.getConcrete()).name() : ((MCPotionType.MCVanillaPotionType)((Object)this.getAbstracted())).name();
    }

    public static MCPotionType valueOfConcrete(PotionType test) {
        MCPotionType type = BUKKIT_MAP.get(test);
        if (type == null) {
            MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.GENERAL, "Bukkit PotionType missing in BUKKIT_MAP: " + test.name(), Target.UNKNOWN);
            return new BukkitMCPotionType(MCPotionType.MCVanillaPotionType.UNKNOWN, test);
        }
        return type;
    }

    public static void build() {
        for (MCPotionType.MCVanillaPotionType mCVanillaPotionType : MCPotionType.MCVanillaPotionType.values()) {
            if (!mCVanillaPotionType.existsIn(Static.getServer().getMinecraftVersion())) continue;
            PotionType type = BukkitMCPotionType.getBukkitType(mCVanillaPotionType);
            if (type == null) {
                MSLog.GetLogger().w(MSLog.Tags.RUNTIME, "Could not find a Bukkit potion type for " + mCVanillaPotionType.name(), Target.UNKNOWN);
                continue;
            }
            BukkitMCPotionType wrapper = new BukkitMCPotionType(mCVanillaPotionType, type);
            MAP.put(mCVanillaPotionType.name(), wrapper);
            BUKKIT_MAP.put(type, wrapper);
        }
        for (MCPotionType.MCVanillaPotionType mCVanillaPotionType : PotionType.values()) {
            if (mCVanillaPotionType == null || BUKKIT_MAP.containsKey((Object)mCVanillaPotionType)) continue;
            MAP.put(mCVanillaPotionType.name(), new BukkitMCPotionType(MCPotionType.MCVanillaPotionType.UNKNOWN, (PotionType)mCVanillaPotionType));
            BUKKIT_MAP.put((PotionType)mCVanillaPotionType, new BukkitMCPotionType(MCPotionType.MCVanillaPotionType.UNKNOWN, (PotionType)mCVanillaPotionType));
        }
    }

    private static PotionType getBukkitType(MCPotionType.MCVanillaPotionType v) {
        return PotionType.valueOf((String)v.name());
    }
}

