/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.exceptions;

import com.laytonsmith.PureUtilities.Common.StackTraceUtils;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.TermColors;
import com.laytonsmith.abstraction.MCCommandSender;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.enums.MCChatColor;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.ObjectGenerator;
import com.laytonsmith.core.Prefs;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CClosure;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.CommandHelperEnvironment;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.StaticRuntimeEnv;
import com.laytonsmith.core.exceptions.CRE.AbstractCREException;
import com.laytonsmith.core.exceptions.CRE.CRECausedByWrapper;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ConfigRuntimeException
extends RuntimeException {
    private Environment env;
    private Target target;

    protected ConfigRuntimeException(String msg2, Target t) {
        super(msg2);
        this.createException(t);
    }

    protected ConfigRuntimeException(String msg2, Target t, Throwable cause) {
        super(msg2, cause);
        this.createException(t);
    }

    public void setEnv(Environment env) {
        this.env = env;
    }

    public Environment getEnv() {
        return this.env;
    }

    public static Reaction GetReaction(ConfigRuntimeException e, Environment env) {
        if (env.getEnv(StaticRuntimeEnv.class).getExceptionHandler() != null) {
            CClosure c = env.getEnv(StaticRuntimeEnv.class).getExceptionHandler();
            CArray ex = ObjectGenerator.GetGenerator().exception(e, env, Target.UNKNOWN);
            if (e.getEnv() != null) {
                MCCommandSender sender = e.getEnv().getEnv(CommandHelperEnvironment.class).GetCommandSender();
                c.getEnv().getEnv(CommandHelperEnvironment.class).SetCommandSender(sender);
            }
            try {
                Mixed ret = c.executeCallable(env, Target.UNKNOWN, ex);
                if (ret instanceof CNull || ret instanceof CVoid || Prefs.ScreamErrors().booleanValue()) {
                    return Reaction.REPORT;
                }
                return ArgumentValidation.getBooleanObject(ret, Target.UNKNOWN) ? Reaction.IGNORE : Reaction.FATAL;
            }
            catch (ConfigRuntimeException cre) {
                ConfigRuntimeException.HandleUncaughtException(cre, env, Reaction.REPORT);
                return Reaction.REPORT;
            }
        }
        return Reaction.REPORT;
    }

    public static void HandleUncaughtException(ConfigCompileException e, String optionalMessage, MCPlayer player2) {
        if (optionalMessage != null) {
            ConfigRuntimeException.DoWarning(optionalMessage);
        }
        ConfigRuntimeException.DoReport(e, player2);
    }

    public static void HandleUncaughtException(ConfigCompileGroupException e, MCPlayer player2) {
        for (ConfigCompileException ce : e.getList()) {
            ConfigRuntimeException.HandleUncaughtException(ce, null, player2);
        }
    }

    public static void HandleUncaughtException(ConfigCompileGroupException e, String optionalMessage, MCPlayer player2) {
        ConfigRuntimeException.DoWarning(optionalMessage);
        ConfigRuntimeException.HandleUncaughtException(e, player2);
    }

    public static void HandleUncaughtException(ConfigRuntimeException e, Environment env) {
        ConfigRuntimeException.HandleUncaughtException(e, env, ConfigRuntimeException.GetReaction(e, env));
    }

    private static void HandleUncaughtException(ConfigRuntimeException e, Environment env, Reaction r) {
        if (r == Reaction.IGNORE) {
            MSLog.GetLogger().Log((MSLog.Tag)MSLog.Tags.RUNTIME, LogLevel.DEBUG, "An exception bubbled to the top, but was instructed by an event handler to not cause output.", e.getTarget());
        } else if (r == Reaction.REPORT) {
            ConfigRuntimeException.DoReport(e, env);
        } else if (r == Reaction.FATAL) {
            ConfigRuntimeException.DoReport(e, env);
        }
    }

    private static void PrintMessage(StringBuilder log, StringBuilder console2, StringBuilder player2, String type, String message, Throwable ex, List<StackTraceElement> st, Target top) {
        log.append(type).append(message).append("\n");
        console2.append(TermColors.RED).append(type).append(TermColors.WHITE).append(message).append("\n");
        player2.append((Object)MCChatColor.RED).append(type).append((Object)MCChatColor.WHITE).append(message).append("\n");
        if (st.isEmpty()) {
            st.add(new StackTraceElement("<<main code>>", top));
        }
        for (StackTraceElement e : st) {
            String filepath;
            String simplepath;
            Target t = e.getDefinedAt();
            String proc2 = e.getProcedureName();
            File file = t.file();
            int line = t.line();
            int column = t.col();
            if (file == null) {
                simplepath = "Unknown Source";
                filepath = "Unknown Source";
            } else {
                filepath = file.getPath();
                simplepath = file.getName();
            }
            log.append("\tat ").append(proc2).append(":").append(filepath).append(":").append(line).append(".").append(column).append("\n");
            console2.append("\t").append(TermColors.WHITE).append("at ").append(TermColors.GREEN).append(proc2).append(TermColors.WHITE).append(":").append(TermColors.YELLOW).append(filepath).append(TermColors.WHITE).append(":").append(TermColors.CYAN).append(line).append(".").append(column).append("\n");
            player2.append("\t").append((Object)MCChatColor.WHITE).append("at ").append((Object)MCChatColor.GREEN).append(proc2).append((Object)MCChatColor.WHITE).append(":").append((Object)MCChatColor.YELLOW).append(simplepath).append((Object)MCChatColor.WHITE).append(":").append((Object)MCChatColor.AQUA).append(line).append(".").append(column).append("\n");
        }
    }

    private static void DoReport(String message, String exceptionType, ConfigRuntimeException ex, List<StackTraceElement> stacktrace, MCPlayer currentPlayer) {
        String type = exceptionType;
        if (exceptionType == null) {
            type = "FATAL";
        }
        ArrayList<StackTraceElement> st = new ArrayList<StackTraceElement>(stacktrace);
        if (message == null) {
            message = "";
        }
        if (!"".equals(((String)message).trim())) {
            message = ": " + (String)message;
        }
        Target top = Target.UNKNOWN;
        if (ex != null) {
            top = ex.getTarget();
        }
        for (StackTraceElement e : st) {
            Target t = e.getDefinedAt();
            if (top != Target.UNKNOWN) continue;
            top = t;
        }
        StringBuilder log = new StringBuilder();
        StringBuilder console2 = new StringBuilder();
        StringBuilder player2 = new StringBuilder();
        ConfigRuntimeException.PrintMessage(log, console2, player2, type, (String)message, ex, st, top);
        if (ex != null) {
            if (ex.getCause() != null && ex.getCause() instanceof ConfigRuntimeException) {
                ex = (ConfigRuntimeException)ex.getCause();
            }
            while (ex instanceof CRECausedByWrapper) {
                Target t = ex.getTarget();
                log.append("Caused by:\n");
                console2.append(TermColors.CYAN).append("Caused by:\n");
                player2.append((Object)MCChatColor.AQUA).append("Caused by:\n");
                CArray exception = ((CRECausedByWrapper)ex).getException();
                CArray stackTrace = ArgumentValidation.getArray(exception.get("stackTrace", t), t);
                ArrayList<StackTraceElement> newSt = new ArrayList<StackTraceElement>();
                for (Mixed consElement : stackTrace.asList()) {
                    CArray element = ArgumentValidation.getArray(consElement, t);
                    int line = ArgumentValidation.getInt32(element.get("line", t), t);
                    File file = new File(element.get("file", t).val());
                    int col = ArgumentValidation.getInt32(element.get("col", t), t);
                    Target stElementTarget = new Target(line, file, col);
                    newSt.add(new StackTraceElement(element.get("id", t).val(), stElementTarget));
                }
                String nType = exception.get("classType", t).val();
                Object nMessage = exception.get("message", t).val();
                if (!"".equals(((String)nMessage).trim())) {
                    nMessage = ": " + (String)nMessage;
                }
                ConfigRuntimeException.PrintMessage(log, console2, player2, nType, (String)nMessage, ex, newSt, top);
                ex = (ConfigRuntimeException)ex.getCause();
            }
        }
        MSLog.GetLogger().Log((MSLog.Tag)("COMPILE ERROR".equals(exceptionType) ? MSLog.Tags.COMPILER : MSLog.Tags.RUNTIME), LogLevel.ERROR, log.toString(), top, false);
        StreamUtils.GetSystemOut().println(console2.toString() + TermColors.reset());
        if (currentPlayer != null) {
            currentPlayer.sendMessage(player2.toString());
        }
    }

    private static void DoReport(ConfigRuntimeException e, Environment env) {
        MCPlayer p2 = null;
        if (e.getEnv() != null && e.getEnv().hasEnv(CommandHelperEnvironment.class) && e.getEnv().getEnv(CommandHelperEnvironment.class).GetPlayer() != null) {
            p2 = e.getEnv().getEnv(CommandHelperEnvironment.class).GetPlayer();
        }
        ArrayList<StackTraceElement> st = new ArrayList();
        if (e instanceof AbstractCREException) {
            st = ((AbstractCREException)e).getCREStackTrace();
        }
        ConfigRuntimeException.DoReport(e.getMessage(), AbstractCREException.getExceptionName(e), e, st, p2);
        if (Prefs.DebugMode().booleanValue()) {
            if (e.getCause() != null && !(e.getCause() instanceof CRECausedByWrapper)) {
                StreamUtils.GetSystemErr().println("The previous MethodScript error had an attached cause:");
                e.getCause().printStackTrace(StreamUtils.GetSystemErr());
            }
            if (e.getTarget().equals(Target.UNKNOWN)) {
                StreamUtils.GetSystemErr().println("Since the exception has an unknown code target, here is additional information that may help:");
                StreamUtils.GetSystemErr().println(StackTraceUtils.GetStacktrace(new Exception()));
            }
        }
    }

    private static void DoReport(ConfigCompileException e, MCPlayer player2) {
        ArrayList<StackTraceElement> st = new ArrayList<StackTraceElement>();
        st.add(0, new StackTraceElement("", e.getTarget()));
        ConfigRuntimeException.DoReport(e.getMessage(), "COMPILE ERROR", null, st, player2);
    }

    public static void DoWarning(Exception e) {
        ConfigRuntimeException.DoWarning(e, null, true);
    }

    public static void DoWarning(String optionalMessage) {
        ConfigRuntimeException.DoWarning(null, optionalMessage, true);
    }

    public static void DoWarning(Exception e, String optionalMessage, boolean checkPrefs) {
        if (e == null && (optionalMessage == null || optionalMessage.isEmpty())) {
            throw new NullPointerException("Both the exception and the message cannot be empty");
        }
        if (!checkPrefs || Prefs.ShowWarnings().booleanValue()) {
            Object exceptionMessage = "";
            Target t = Target.UNKNOWN;
            if (e instanceof ConfigRuntimeException) {
                ConfigRuntimeException cre = (ConfigRuntimeException)e;
                exceptionMessage = String.valueOf((Object)MCChatColor.YELLOW) + cre.getMessage() + String.valueOf((Object)MCChatColor.WHITE) + " :: " + String.valueOf((Object)MCChatColor.GREEN) + AbstractCREException.getExceptionName(cre) + String.valueOf((Object)MCChatColor.WHITE) + ":" + String.valueOf((Object)MCChatColor.YELLOW) + String.valueOf(cre.target.file()) + String.valueOf((Object)MCChatColor.WHITE) + ":" + String.valueOf((Object)MCChatColor.AQUA) + cre.target.line();
                t = cre.getTarget();
            } else if (e != null) {
                exceptionMessage = String.valueOf((Object)MCChatColor.YELLOW) + e.getMessage();
            }
            String message = (String)exceptionMessage + String.valueOf((Object)MCChatColor.WHITE) + optionalMessage;
            MSLog.GetLogger().Log((MSLog.Tag)MSLog.Tags.GENERAL, LogLevel.WARNING, Static.MCToANSIColors(message) + TermColors.reset(), t);
        }
    }

    private void createException(Target t) {
        this.target = t;
    }

    public void setTarget(Target t) {
        this.target = t;
    }

    public static ConfigRuntimeException CreateUncatchableException(String msg2, Target t) {
        return new ConfigRuntimeException(msg2, t, null);
    }

    public static ConfigRuntimeException CreateUncatchableException(String msg2, Target t, Throwable cause) {
        return new ConfigRuntimeException(msg2, t, cause);
    }

    public Target getTarget() {
        return this.target;
    }

    public String getSimpleFile() {
        if (this.target.file() != null) {
            return this.target.file().getName();
        }
        return null;
    }

    public static enum Reaction {
        IGNORE,
        REPORT,
        FATAL;

    }

    public static class StackTraceElement {
        private final String procedureName;
        private Target definedAt;

        public StackTraceElement(String procedureName, Target definedAt) {
            this.procedureName = procedureName;
            this.definedAt = definedAt;
        }

        public String getProcedureName() {
            return this.procedureName;
        }

        public Target getDefinedAt() {
            return this.definedAt;
        }

        public String toString() {
            return this.procedureName + " (Defined at " + String.valueOf(this.definedAt) + ")";
        }

        public CArray getObjectFor() {
            CArray element = CArray.GetAssociativeArray(Target.UNKNOWN);
            element.set("id", this.getProcedureName());
            try {
                String name = "Unknown file";
                if (this.getDefinedAt().file() != null) {
                    name = this.getDefinedAt().file().getCanonicalPath();
                }
                element.set("file", name);
            }
            catch (IOException ex) {
                String name = "Unknown file";
                if (this.getDefinedAt().file() != null) {
                    name = this.getDefinedAt().file().getAbsolutePath();
                }
                element.set("file", name);
            }
            element.set("line", (Mixed)new CInt(this.getDefinedAt().line(), Target.UNKNOWN), Target.UNKNOWN);
            element.set("col", (Mixed)new CInt(this.getDefinedAt().col(), Target.UNKNOWN), Target.UNKNOWN);
            return element;
        }

        void setDefinedAt(Target target) {
            this.definedAt = target;
        }
    }
}

