/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.tools.docgen.localization;

import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.PureUtilities.Common.FileWriteMode;
import com.laytonsmith.PureUtilities.Common.MutableObject;
import com.laytonsmith.PureUtilities.ProgressIterator;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.constructs.NativeTypeList;
import com.laytonsmith.core.functions.FunctionList;
import com.laytonsmith.tools.docgen.localization.Locale;
import com.laytonsmith.tools.docgen.localization.MasterSearchIndex;
import com.laytonsmith.tools.docgen.localization.ResultType;
import com.laytonsmith.tools.docgen.localization.TranslationMemory;
import com.laytonsmith.tools.docgen.localization.TranslationSummary;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class TranslationMaster {
    private static final ProgressIterator NULLPI = (current, total) -> {};
    private final Map<Locale, LocaleTranslationMaster> allLocales = new HashMap<Locale, LocaleTranslationMaster>();
    private final File translationDb;
    private final TranslationSummary translationSummary;
    private final ProgressIterator progressCallback;
    private final MasterSearchIndex masterSearchIndex = new MasterSearchIndex();
    private static final String[] SEGMENT_SEP = new String[]{"==+", "\n\n", "\n\\*", "\n#"};
    private static final Pattern SPLIT_PATTERN;
    private static final Set<String> FUNCTION_IDENTIFIERS;
    private static final Set<String> FUNCTION_NAMES;
    private static final Set<String> CLASS_NAMES;
    private static final String URL_PATTERN = "(?:https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
    private static final String TABLE_PATTERN_STRING = "(?s)(\\{\\|.*?\n\\|\\})";
    private static final Pattern TABLE_PATTERN;
    private static final String[] UNIQUE_SEGMENTS;
    private static final Set<String> USELESS_SEGMENTS;
    private static final Set<String> NO_REMOVE_TEMPLATES;
    private static final Set<String> FRAME_SEGMENTS;

    public TranslationMaster(File translationDb) throws IOException {
        this(translationDb, NULLPI);
    }

    public File getTranslationDb() {
        return this.translationDb;
    }

    public TranslationMaster(File translationDb, ProgressIterator callback) throws IOException {
        this.translationDb = translationDb;
        this.progressCallback = callback == null ? NULLPI : callback;
        this.translationSummary = new TranslationSummary(translationDb);
        this.initialize();
    }

    private void initialize() throws IOException {
        File[] locales = this.translationDb.listFiles(file -> file.isDirectory());
        int total = 0;
        for (File locale : locales) {
            if (locale.getName().equals(".git")) continue;
            total += this.prepLocale(locale);
        }
        MutableObject<Integer> current = new MutableObject<Integer>(0);
        for (File locale : locales) {
            if (locale.getName().equals(".git")) continue;
            Locale l = Locale.fromLocale(locale.getName());
            this.initLocale(l, locale, current, total);
        }
    }

    private void initNewLocale(Locale locale) {
        if (!this.allLocales.containsKey((Object)locale)) {
            LocaleTranslationMaster ltm = new LocaleTranslationMaster();
            ltm.locale = locale;
            ltm.master = new HashMap<String, TranslationMemory>();
            ltm.pages = new HashMap<File, PageTranslations>();
            this.allLocales.put(locale, ltm);
        }
    }

    private int prepLocale(File locale) throws IOException {
        MutableObject<Integer> i = new MutableObject<Integer>(0);
        FileUtil.recursiveFind(locale, f -> {
            if (f.isDirectory()) {
                return;
            }
            i.setObject((Integer)i.getObject() + 1);
        });
        return i.getObject();
    }

    private void initLocale(Locale locale, File localeFile, MutableObject<Integer> current, int total) throws IOException {
        this.initNewLocale(locale);
        LocaleTranslationMaster ltm = this.allLocales.get((Object)locale);
        File master = new File(localeFile, "master.tmem.xml").getCanonicalFile();
        FileUtil.recursiveFind(localeFile, f -> {
            if (f.isDirectory()) {
                return;
            }
            Map<String, TranslationMemory> tmem = TranslationMemory.fromTmemFile(locale, FileUtil.read(f));
            if (f.getCanonicalFile().equals(master)) {
                ltm.master = tmem;
                for (TranslationMemory t : ltm.master.values()) {
                    ltm.maxId = Math.max(ltm.maxId, t.getId());
                }
            } else if (f.getName().endsWith(".tmem.xml")) {
                PageTranslations pt = new PageTranslations();
                pt.file = f;
                pt.blocks = new HashSet<String>(tmem.keySet());
                pt.locale = locale;
                ltm.pages.put(f, pt);
            } else {
                System.out.println("Skipping non tmem file " + f.getAbsolutePath());
            }
            current.setObject((Integer)current.getObject() + 1);
            this.progressCallback.progressChanged(((Integer)current.getObject()).intValue(), total);
        });
        if (ltm.master == null) {
            throw new IOException("Missing master translation file!");
        }
    }

    private File standardizeFile(File page) {
        try {
            return page.getCanonicalFile();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean hasMasterTranslation(Locale locale, String key) {
        this.initNewLocale(locale);
        return this.allLocales.get((Object)((Object)locale)).master.containsKey(key);
    }

    public void createTranslationMemory(String title2, String toLocation, ResultType type, String inputString) {
        for (String searchSegment : TranslationMaster.findSegments(inputString, true)) {
            this.masterSearchIndex.addSegment(title2, toLocation, type, searchSegment);
        }
        Set<String> segments = TranslationMaster.findSegments(inputString, false);
        for (String segment : segments) {
            int id;
            if (!this.translationSummary.containsTranslation(segment)) {
                id = this.getNewId();
                this.translationSummary.addTranslation(segment, id);
            } else {
                id = this.translationSummary.getMemory(segment).getId();
            }
            for (Locale locale : Locale.values()) {
                File location = new File(this.translationDb, String.format(toLocation, locale.getLocale()));
                TranslationMemory tm = this.hasMasterTranslation(locale, segment) ? this.getLocaleMaster(locale).get(segment) : this.generateNewTranslation(locale, segment, id);
                this.addTranslation(locale, location, tm);
            }
        }
    }

    private void addTranslation(Locale locale, File page, TranslationMemory memory) {
        PageTranslations pt;
        this.initNewLocale(locale);
        page = this.standardizeFile(page);
        LocaleTranslationMaster ltm = this.allLocales.get((Object)locale);
        ltm.master.put(memory.getEnglishKey(), memory);
        if (!ltm.pages.containsKey(page)) {
            pt = new PageTranslations();
            pt.file = page;
            pt.locale = locale;
            pt.blocks = new HashSet<String>();
            ltm.pages.put(page, pt);
        } else {
            pt = ltm.pages.get(page);
        }
        pt.blocks.add(memory.getEnglishKey());
    }

    public Map<String, TranslationMemory> getLocaleMaster(Locale locale) {
        return this.allLocales.get((Object)((Object)locale)).master;
    }

    public void save() throws IOException {
        this.save(NULLPI);
    }

    public void save(ProgressIterator pi) throws IOException {
        if (pi == null) {
            pi = NULLPI;
        }
        int total = 1;
        int current = 1;
        if (pi != NULLPI) {
            for (LocaleTranslationMaster ltm : this.allLocales.values()) {
                for (Map.Entry<File, PageTranslations> fpt : ltm.pages.entrySet()) {
                    ++total;
                }
            }
        }
        this.translationSummary.save();
        pi.progressChanged(current, total);
        for (LocaleTranslationMaster ltm : this.allLocales.values()) {
            File masterFile = new File(this.translationDb, ltm.locale.getLocale() + "/master.tmem.xml");
            FileUtil.write(TranslationMemory.generateTranslationFile(ltm.master), masterFile, FileWriteMode.OVERWRITE, true);
            for (Map.Entry<File, PageTranslations> fpt : ltm.pages.entrySet()) {
                File f = fpt.getKey();
                PageTranslations pt = fpt.getValue();
                HashMap<String, TranslationMemory> blocks = new HashMap<String, TranslationMemory>();
                pt.blocks.forEach(key -> blocks.put((String)key, ltm.master.get(key)));
                String page = TranslationMemory.generateTranslationFile(blocks);
                FileUtil.write(page, f, FileWriteMode.OVERWRITE, true);
                pi.progressChanged(++current, total);
            }
        }
    }

    public int getNewId() {
        return this.translationSummary.getNextId();
    }

    public List<Locale> getLocales() {
        return new ArrayList<Locale>(this.allLocales.keySet());
    }

    public List<String> getPages() {
        ArrayList<String> pages = new ArrayList<String>();
        String toReplace = new File(this.translationDb.getAbsolutePath(), "art").getAbsolutePath();
        for (File f : this.allLocales.get((Object)((Object)Locale.ART)).pages.keySet()) {
            pages.add(f.getAbsolutePath().replaceFirst(Pattern.quote(toReplace), ""));
        }
        Collections.sort(pages);
        return pages;
    }

    public List<TranslationMemory> getMemoriesForPage(Locale locale, String page) {
        Map<String, TranslationMemory> master = this.allLocales.get((Object)((Object)locale)).master;
        Set<String> keys2 = this.allLocales.get((Object)((Object)locale)).pages.get((Object)new File((File)this.translationDb, (String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001/\u0001"}, (String)locale.getLocale(), (String)page)))).blocks;
        return new ArrayList<TranslationMemory>(keys2.stream().map(key -> (TranslationMemory)master.get(key)).collect(Collectors.toList()));
    }

    public List<TranslationMemory> getMemoriesForLocale(Locale locale) {
        return new ArrayList<TranslationMemory>(this.allLocales.get((Object)((Object)locale)).master.values());
    }

    public List<TranslationSummary.TranslationSummaryEntry> getMasterMemories() {
        return this.translationSummary.getAllMemories();
    }

    public TranslationSummary.TranslationSummaryEntry getSummaryForKey(String key) {
        return this.translationSummary.getMemory(key);
    }

    public TranslationMemory generateNewTranslation(Locale locale, String englishKey, int id) {
        return new TranslationMemory(englishKey, locale, "", "", "", id);
    }

    public MasterSearchIndex getSearchIndex() {
        return this.masterSearchIndex;
    }

    public static Set<String> findSegments(String inputString, boolean forSearch) {
        HashSet<String> segments = new HashSet<String>();
        inputString = inputString.replaceAll("\r", "");
        inputString = inputString.replaceAll("\\\\\n", "");
        inputString = inputString.replaceAll("(?s)<script.*?</script>", "");
        inputString = inputString.replaceAll("%%CURRENT_VERSION%%", "%s");
        inputString = inputString.replaceAll("<%CURRENT_VERSION%>", "%s");
        inputString = inputString.replaceAll("(?s)%%.*?%%", "");
        int count = 0;
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < inputString.length(); ++i) {
            char c1 = inputString.charAt(i);
            int c2 = 0;
            if (i + 1 < inputString.length()) {
                c2 = inputString.charAt(i + 1);
            }
            if (c1 == '<' && c2 == 37) {
                ++count;
                ++i;
                continue;
            }
            if (c1 == '%' && c2 == 62) {
                --count;
                ++i;
                continue;
            }
            if (count > 0) continue;
            b.append(c1);
        }
        inputString = b.toString();
        inputString = inputString.replaceAll("(?s)<pre.*?</pre>", "");
        inputString = inputString.replaceAll("\\{\\{.*?\\}\\}", "%s");
        inputString = inputString.replaceAll("\\[\\[.*?\\|(.*?)\\]\\]", "[[%s|$1]]");
        inputString = inputString.replaceAll("\\[\\[File:.*?\\]\\]", "");
        inputString = inputString.replaceAll("\\[\\[Image:.*?\\]\\]", "");
        inputString = inputString.replaceAll("\\[(?:https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]( .*?)\\]", "[%s$1]");
        inputString = inputString.replaceAll(URL_PATTERN, "%s");
        inputString = inputString.replaceAll("(?s)<.*?>", "%s");
        if (!forSearch) {
            for (String uniqueSegment : UNIQUE_SEGMENTS) {
                if (!inputString.contains(uniqueSegment)) continue;
                segments.add(uniqueSegment);
                inputString = inputString.replace(uniqueSegment, "");
            }
            for (String functionNames : FUNCTION_IDENTIFIERS) {
                inputString = inputString.replaceAll(functionNames, "%s");
            }
        }
        Matcher m = TABLE_PATTERN.matcher(inputString);
        while (m.find()) {
            String table = m.group(1);
            table = table.replaceAll("\\{\\|.*\n", "");
            table = table.replaceAll("\\|\\}", "");
            table = table.replaceAll("\\|\\-\\s*\n", "");
            table = table.replaceAll("!.*\n", "");
            for (String cell : Arrays.asList(table.split("\\|\\||(?:(?:^|\n)\\|)"))) {
                segments.addAll(Arrays.asList(SPLIT_PATTERN.split(cell)));
            }
        }
        inputString = inputString.replaceAll(TABLE_PATTERN_STRING, "");
        segments.addAll(Arrays.asList(SPLIT_PATTERN.split(inputString)));
        segments.addAll(FRAME_SEGMENTS);
        return segments.stream().filter(string -> string != null).map(string -> {
            string = string.trim();
            string = string.replace("\n", " ");
            if (!forSearch) {
                for (String className : CLASS_NAMES) {
                    string = string.replace(className, "%s");
                }
            }
            string = string.replaceAll("^(?:%s|\\s|[,#*])*(.*?)(?:%s|\\s)*$", "$1");
            string = string.replaceAll("%s(?:%s)+", "%s");
            return string;
        }).filter(string -> {
            if (string.isEmpty()) {
                return false;
            }
            if (string.matches("(?:\\s*%s\\s*)+")) {
                return false;
            }
            return !string.matches("\\s*");
        }).filter(string -> !string.matches("^(?:[^a-zA-Z]|%s)+$")).filter(string -> !forSearch ? !FUNCTION_NAMES.contains(string) : true).filter(string -> !USELESS_SEGMENTS.contains(string)).collect(Collectors.toSet());
    }

    public Set<String> validate() {
        HashSet<String> errors = new HashSet<String>();
        errors.addAll(this.translationSummary.validate());
        for (LocaleTranslationMaster ltm : this.allLocales.values()) {
            for (TranslationMemory tm : ltm.master.values()) {
                for (TranslationMemory tm2 : ltm.master.values()) {
                    if (tm == tm2) continue;
                    if (tm.getId() == tm2.getId()) {
                        errors.add("Two entries in the master.tmem.xml file for the " + String.valueOf((Object)ltm.locale) + " locale have the same id: " + tm.getId());
                    }
                    if (!tm.getEnglishKey().equals(tm2.getEnglishKey())) continue;
                    errors.add("Two entries in the master.tmem.xml file for the " + String.valueOf((Object)ltm.locale) + " locale have the same key: " + String.valueOf((Object)ltm.locale) + "-" + tm.getId() + " and " + String.valueOf((Object)ltm.locale) + "-" + tm2.getId());
                }
                int summaryId = this.translationSummary.getTranslationId(tm.getEnglishKey());
                if (summaryId == tm.getId()) continue;
                errors.add("The id defined in master.tmem.xml for the " + String.valueOf((Object)ltm.locale) + " locale for " + tm.getId() + " does not exist in the summary file!");
            }
        }
        return errors;
    }

    public int size() {
        return this.translationSummary.size();
    }

    static {
        FUNCTION_IDENTIFIERS = FunctionList.getFunctionList(api.Platforms.INTERPRETER_JAVA, null).stream().map(function -> "\\[\\[%s\\|" + function.getName() + "\\]\\]\\(?\\)?").collect(Collectors.toSet());
        FUNCTION_NAMES = FunctionList.getFunctionList(api.Platforms.INTERPRETER_JAVA, null).stream().map(f -> f.getName()).collect(Collectors.toSet());
        CLASS_NAMES = NativeTypeList.getNativeTypeList().stream().map(f -> f.getFQCN()).collect(Collectors.toSet());
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (String s : SEGMENT_SEP) {
            if (!first) {
                b.append("|");
            }
            b.append(s);
            first = false;
        }
        SPLIT_PATTERN = Pattern.compile("(?:" + b.toString() + ")");
        TABLE_PATTERN = Pattern.compile(TABLE_PATTERN_STRING);
        UNIQUE_SEGMENTS = new String[]{"%s([[%s|Examples...]])", "%sFind a bug in this page? %sEdit this page yourself, then submit a pull request.%s%s", "%sFind a bug in this page? %sEdit this page yourself, then submit a pull request.%s (Note this page is automatically generated from the documentation in the source code.)%s", "The output would be:", "The output might be:"};
        USELESS_SEGMENTS = new HashSet<String>(Arrays.asList(",", "%%", "<%", "%>"));
        NO_REMOVE_TEMPLATES = new HashSet<String>(Arrays.asList("NOTE"));
        FRAME_SEGMENTS = new HashSet<String>(Arrays.asList("Home", "Docs", "Help", "%s Team. All rights reserved.", "About", "Privacy Policy", "Sponsors"));
    }

    private class LocaleTranslationMaster {
        int maxId = 0;
        Locale locale;
        Map<String, TranslationMemory> master;
        Map<File, PageTranslations> pages;

        private LocaleTranslationMaster() {
        }
    }

    private class PageTranslations {
        File file;
        Set<String> blocks;
        Locale locale;

        private PageTranslations() {
        }
    }
}

