/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.functions;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.RunnableQueue;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.abstraction.StaticLayer;
import com.laytonsmith.annotations.api;
import com.laytonsmith.annotations.core;
import com.laytonsmith.annotations.seealso;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.ObjectGenerator;
import com.laytonsmith.core.Optimizable;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Profiles;
import com.laytonsmith.core.ProfilesImpl;
import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.compiler.CompilerWarning;
import com.laytonsmith.core.compiler.FileOptions;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CByteArray;
import com.laytonsmith.core.constructs.CClosure;
import com.laytonsmith.core.constructs.CDouble;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.StaticRuntimeEnv;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CRESQLException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.AbstractFunction;
import com.laytonsmith.core.functions.ExampleScript;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.database.SQLProfile;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@core
public class SQL {
    public static String docs() {
        return "This class of functions provides methods for accessing various SQL servers.";
    }

    @api
    @seealso(value={query.class, com.laytonsmith.tools.docgen.templates.SQL.class, com.laytonsmith.tools.docgen.templates.Profiles.class})
    public static class query_async
    extends AbstractFunction {
        RunnableQueue queue = null;
        boolean started = false;

        private synchronized void startup() {
            if (this.queue == null) {
                this.queue = new RunnableQueue("MethodScript-queryAsync");
            }
            if (!this.started) {
                this.queue.invokeLater(null, new Runnable(){

                    @Override
                    public void run() {
                    }
                });
                StaticLayer.GetConvertor().addShutdownHook(new Runnable(){

                    @Override
                    public void run() {
                        queue.shutdown();
                        queue = null;
                        started = false;
                    }
                });
                this.started = true;
            }
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class};
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(final Target t, final Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            this.startup();
            Mixed arg = args2[args2.length - 1];
            if (!arg.isInstanceOf(CClosure.TYPE)) {
                throw new CRECastException("The last argument to " + this.getName() + " must be a closure.", t);
            }
            final CClosure closure2 = (CClosure)arg;
            final Mixed[] newArgs = new Mixed[args2.length - 1];
            System.arraycopy(args2, 0, newArgs, 0, newArgs.length);
            this.queue.invokeLater(environment.getEnv(StaticRuntimeEnv.class).GetDaemonManager(), new Runnable(){

                @Override
                public void run() {
                    Mixed returnValue = CNull.NULL;
                    Construct exception = CNull.NULL;
                    try {
                        returnValue = new query().exec(t, environment, newArgs);
                    }
                    catch (ConfigRuntimeException ex) {
                        exception = ObjectGenerator.GetGenerator().exception(ex, environment, t);
                    }
                    final Mixed cret = returnValue;
                    final Construct cex = exception;
                    StaticLayer.GetConvertor().runOnMainThreadLater(environment.getEnv(StaticRuntimeEnv.class).GetDaemonManager(), new Runnable(){

                        @Override
                        public void run() {
                            closure2.executeCallable(cret, cex);
                        }
                    });
                }
            });
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "query_async";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{Integer.MAX_VALUE};
        }

        @Override
        public String docs() {
            return "void {profile, query, [params...], callback} Asynchronously makes a query to an SQL server. The profile, query, and params arguments work the same as {{function|query}}, so see the documentation of that function for details about those parameters. The callback should have the following signature: closure(@contents, @exception){ &lt;code&gt; }. @contents will contain the return value that query would normally return. If @exception is not null, then an exception occurred during the query, and that exception will be passed in. If @exception is null, then no error occurred, though @contents may still be null if query() would otherwise have returned null.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_1;
        }
    }

    @api
    @seealso(value={query.class, com.laytonsmith.tools.docgen.templates.SQL.class, com.laytonsmith.tools.docgen.templates.Profiles.class})
    public static class unsafe_query
    extends query {
        public unsafe_query() {
            super(false);
        }

        @Override
        public String docs() {
            return "mixed {profile, query, [parameters...]} Executes a query, just like the {{function|query}} function, however, no validation is done to ensure that SQL injections might occur (essentially allowing for concatenation directly in the query). Otherwise, functions exactly the same as query().";
        }

        @Override
        public String getName() {
            return "unsafe_query";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return null;
        }
    }

    @api
    @seealso(value={unsafe_query.class, query_async.class, com.laytonsmith.tools.docgen.templates.SQL.class, com.laytonsmith.tools.docgen.templates.Profiles.class})
    public static class query
    extends AbstractFunction
    implements Optimizable {
        private final boolean doWarn;
        private static final Object CONNECTION_POOL_LOCK = new Object();
        private static Map<String, Connection> connectionPool = null;
        private static final boolean USE_CONNECTION_POOL = true;

        public query() {
            this(true);
        }

        protected query(boolean doWarn) {
            this.doWarn = doWarn;
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRESQLException.class};
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Connection getConnection(String connectionString, Target t) throws SQLException {
            Object object = CONNECTION_POOL_LOCK;
            synchronized (object) {
                if (connectionPool == null) {
                    connectionPool = new HashMap<String, Connection>();
                    StaticLayer.GetConvertor().addShutdownHook(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = CONNECTION_POOL_LOCK;
                            synchronized (object) {
                                for (Connection c : connectionPool.values()) {
                                    try {
                                        c.close();
                                    }
                                    catch (SQLException sQLException) {}
                                }
                                connectionPool = null;
                            }
                        }
                    });
                }
                if (!connectionPool.containsKey(connectionString)) {
                    connectionPool.put(connectionString, DriverManager.getConnection(connectionString));
                }
                Connection c = connectionPool.get(connectionString);
                boolean isValid = false;
                try {
                    isValid = c.isValid(3);
                }
                catch (AbstractMethodError ex) {
                    MSLog.GetLogger().Log((MSLog.Tag)MSLog.Tags.GENERAL, LogLevel.WARNING, "SQL driver does not support the \"isValid\" method, which is causing " + Implementation.GetServerType().getBranding() + " to use a slower method.", t);
                }
                if (c.isClosed() || !isValid) {
                    c = DriverManager.getConnection(connectionString);
                    connectionPool.put(connectionString, c);
                }
                return c;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
            try {
                PreparedStatement ps;
                block48: {
                    Profiles.Profile profile;
                    if (args2[0].isInstanceOf(CArray.TYPE)) {
                        HashMap<String, String> data = new HashMap<String, String>();
                        for (String key : ((CArray)args2[0]).stringKeySet()) {
                            data.put(key, ((CArray)args2[0]).get(key, t).val());
                        }
                        profile = ProfilesImpl.getProfile(data);
                    } else {
                        Profiles profiles = environment.getEnv(StaticRuntimeEnv.class).getProfiles();
                        profile = profiles.getProfileById(args2[0].val());
                    }
                    if (!(profile instanceof SQLProfile)) {
                        throw new CRECastException("Profile must be an SQL type profile, but found \"" + profile.getType() + "\"", t);
                    }
                    String query2 = args2[1].val();
                    Mixed[] params = new Mixed[args2.length - 2];
                    for (int i = 2; i < args2.length; ++i) {
                        int index = i - 2;
                        params[index] = args2[i];
                        if (!(params[index] instanceof CNull)) continue;
                        params[index] = null;
                    }
                    SQLProfile sqlProfile = (SQLProfile)profile;
                    Connection conn = this.getConnection(sqlProfile.getConnectionString(), t);
                    int autogeneratedKeys = 1;
                    if (!sqlProfile.getAutogeneratedKeys(query2)) {
                        autogeneratedKeys = 2;
                    }
                    ps = conn.prepareStatement(query2, autogeneratedKeys);
                    for (int i = 0; i < params.length; ++i) {
                        int type;
                        int n = type = sqlProfile.providesParameterTypes() ? ps.getParameterMetaData().getParameterType(i + 1) : 12;
                        if (params[i] == null) {
                            try {
                                if (ps.getParameterMetaData().isNullable(i + 1) == 0) {
                                    throw new CRESQLException("Parameter " + (i + 1) + " cannot be set to null. Check your parameters and try again.", t);
                                }
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                            ps.setNull(i + 1, type);
                            continue;
                        }
                        try {
                            if (params[i].isInstanceOf(CInt.TYPE)) {
                                ps.setLong(i + 1, ArgumentValidation.getInt(params[i], t));
                                continue;
                            }
                            if (params[i].isInstanceOf(CDouble.TYPE)) {
                                ps.setDouble(i + 1, ArgumentValidation.getDouble(params[i], t));
                                continue;
                            }
                            if (params[i].isInstanceOf(CString.TYPE)) {
                                if (type == -15 || type == -9 || type == -16) {
                                    ps.setNString(i + 1, params[i].val());
                                    continue;
                                }
                                ps.setString(i + 1, params[i].val());
                                continue;
                            }
                            if (params[i].isInstanceOf(CByteArray.TYPE)) {
                                ps.setBytes(i + 1, ((CByteArray)params[i]).asByteArrayCopy());
                                continue;
                            }
                            if (!params[i].isInstanceOf(CBoolean.TYPE)) throw new CRECastException("The type " + params[i].getClass().getSimpleName() + " of parameter " + (i + 1) + " is not supported.", t);
                            ps.setBoolean(i + 1, ArgumentValidation.getBoolean(params[i], t));
                            continue;
                        }
                        catch (ClassCastException ex) {
                            throw new CRECastException("Could not cast parameter " + (i + 1) + " to " + ps.getParameterMetaData().getParameterTypeName(i + 1) + " from " + params[i].getClass().getSimpleName() + ".", t, ex);
                        }
                    }
                    boolean isResultSet = ps.execute();
                    if (!isResultSet) {
                        ResultSet rs = ps.getGeneratedKeys();
                        if (rs.next()) {
                            CInt cInt = new CInt(rs.getInt(1), t);
                            return cInt;
                        }
                        CNull cNull = CNull.NULL;
                        return cNull;
                    }
                    break block48;
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                }
                CArray ret = new CArray(t);
                ResultSetMetaData md = ps.getMetaData();
                ResultSet rs = ps.getResultSet();
                while (true) {
                    CArray row;
                    if (rs != null && rs.next()) {
                        row = CArray.GetAssociativeArray(t);
                    } else {
                        CArray cArray = ret;
                        return cArray;
                    }
                    for (int i = 1; i <= md.getColumnCount(); ++i) {
                        int columnType = md.getColumnType(i);
                        Construct value = switch (columnType) {
                            case -6, -5, 4, 5 -> new CInt(rs.getLong(i), t);
                            case 2, 3, 6, 7, 8 -> new CDouble(rs.getDouble(i), t);
                            case -16, -15, -9 -> new CString(rs.getNString(i), t);
                            case -1, 1, 12 -> new CString(rs.getString(i), t);
                            case -4, -3, -2, 2004 -> CByteArray.wrap(rs.getBytes(i), t);
                            case 91, 92, 93 -> {
                                if (md.getColumnTypeName(i).equals("YEAR")) {
                                    yield new CInt(rs.getLong(i), t);
                                }
                                if (rs.getTimestamp(i) == null) {
                                    yield CNull.NULL;
                                }
                                yield new CInt(rs.getTimestamp(i).getTime(), t);
                            }
                            case -7, 16 -> CBoolean.get(rs.getBoolean(i));
                            default -> throw new CRECastException("SQL returned a unhandled column type " + md.getColumnTypeName(i) + " for column " + md.getColumnName(i) + ".", t);
                        };
                        if (rs.wasNull()) {
                            value = CNull.NULL;
                        }
                        row.set(md.getColumnLabel(i), (Mixed)value, t);
                    }
                    ret.push(row, t);
                }
            }
            catch (Profiles.InvalidProfileException | SQLException ex) {
                throw new CRESQLException(ex.getMessage(), t, ex);
            }
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException {
            if (children.size() < 2) {
                throw new ConfigCompileException(this.getName() + " expects at least 2 arguments", t);
            }
            Mixed queryData = children.get(1).getData();
            if (queryData instanceof CFunction) {
                if (this.doWarn && ("sconcat".equals(queryData.val()) || "concat".equals(queryData.val()))) {
                    String msg2 = "Use of concatenated query detected! This is very bad practice, and could lead to SQL injection vulnerabilities in your code. It is highly recommended that you use prepared queries, which ensure that your parameters are properly escaped. If you really must use concatenation, and you promise you know what you're doing, you can use " + new unsafe_query().getName() + "() to suppress this warning.";
                    env.getEnv(CompilerEnvironment.class).addCompilerWarning(fileOptions, new CompilerWarning(msg2, t, null));
                }
            } else if (queryData.isInstanceOf(CString.TYPE)) {
                String query2 = queryData.val();
                int count = 0;
                for (char c : query2.toCharArray()) {
                    if (c != '?') continue;
                    ++count;
                }
                if (children.size() - 2 != count) {
                    throw new ConfigCompileException(StringUtils.PluralTemplateHelper(count, "%d parameter token was", "%d parameter tokens were") + " found in the query, but " + StringUtils.PluralTemplateHelper(children.size() - 2, "%d parameter was", "%d parameters were") + " provided to query().", t);
                }
            }
            return null;
        }

        @Override
        public String getName() {
            return "query";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{Integer.MAX_VALUE};
        }

        @Override
        public String docs() {
            return this.getBundledDocs();
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC);
        }
    }
}

