/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.Common;

import com.laytonsmith.PureUtilities.Common.ArrayUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import java.util.Objects;

public class GNUErrorMessageFormat {
    private final String messageLine;
    private String file;
    private int fromLine = -1;
    private int fromColumn = 0;
    private int toLine = -1;
    private int toColumn = 0;
    private MessageType probableMessageType = MessageType.UNKNOWN;
    private String message;
    private boolean parsed = false;

    public GNUErrorMessageFormat(String messageLine) {
        this.messageLine = messageLine;
    }

    public GNUErrorMessageFormat parse() throws IllegalArgumentException {
        if (this.parsed) {
            return this;
        }
        this.parsed = true;
        String[] errorParts = this.messageLine.split(" ", 2);
        this.message = errorParts[1].trim();
        if ("".equals((errorParts = errorParts[0].split(":", -1))[errorParts.length - 1])) {
            errorParts = ArrayUtils.slice(errorParts, 0, errorParts.length - 2);
        }
        if (errorParts.length > 3) {
            throw new IllegalArgumentException("Not a supported error message format");
        }
        switch (errorParts.length) {
            case 2: {
                this.file = errorParts[0];
                String middle = errorParts[1];
                if (middle.matches("\\d+")) {
                    this.fromLine = Integer.parseInt(middle);
                    break;
                }
                if (middle.matches("\\d+\\.\\d+")) {
                    String[] s = middle.split("\\.");
                    this.fromLine = Integer.parseInt(s[0]);
                    this.fromColumn = this.toColumn = Integer.parseInt(s[1]);
                    break;
                }
                if (middle.matches("\\d+\\.\\d+-\\d+\\.\\d+")) {
                    String[] s = middle.split("-");
                    String[] s0 = s[0].split("\\.");
                    String[] s1 = s[1].split("\\.");
                    this.fromLine = Integer.parseInt(s0[0]);
                    this.fromColumn = Integer.parseInt(s0[1]);
                    this.toLine = Integer.parseInt(s1[0]);
                    this.toColumn = Integer.parseInt(s1[1]);
                    break;
                }
                if (middle.matches("\\d+\\.\\d+-\\d+")) {
                    String[] s = middle.split("\\.");
                    String[] c = s[1].split("-");
                    this.fromLine = this.toLine = Integer.parseInt(s[0]);
                    this.fromColumn = Integer.parseInt(c[0]);
                    this.toColumn = Integer.parseInt(c[1]);
                    break;
                }
                if (middle.matches("\\d+-\\d+")) {
                    String[] s = middle.split("-");
                    this.fromLine = Integer.parseInt(s[0]);
                    this.toLine = Integer.parseInt(s[1]);
                    break;
                }
                throw new IllegalArgumentException("Could not parse message");
            }
            case 3: {
                this.file = errorParts[0];
                this.fromLine = Integer.parseInt(errorParts[1]);
                this.fromColumn = this.toColumn = Integer.parseInt(errorParts[2]);
            }
        }
        if (StringUtils.containsIgnoreCase(this.message, "error")) {
            this.probableMessageType = MessageType.ERROR;
        } else if (StringUtils.containsIgnoreCase(this.message, "warning")) {
            this.probableMessageType = MessageType.WARNING;
        } else if (StringUtils.containsIgnoreCase(this.message, "info")) {
            this.probableMessageType = MessageType.INFO;
        }
        if (this.toLine == -1) {
            this.toLine = this.fromLine;
        }
        if (this.toColumn == -1) {
            this.toColumn = this.fromColumn;
        }
        return this;
    }

    public String file() {
        this.parse();
        return this.file;
    }

    public int fromLine() {
        this.parse();
        return this.fromLine;
    }

    public int fromColumn() {
        this.parse();
        return this.fromColumn;
    }

    public int toLine() {
        this.parse();
        return this.toLine;
    }

    public int toColumn() {
        this.parse();
        return this.toColumn;
    }

    public MessageType messageType() {
        this.parse();
        return this.probableMessageType;
    }

    public String message() {
        this.parse();
        return this.message;
    }

    public String getOriginalErrorLine() {
        return this.messageLine;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GNUErrorMessageFormat) {
            return this.messageLine.equals(((GNUErrorMessageFormat)obj).messageLine);
        }
        return false;
    }

    public int hashCode() {
        int hash2 = 7;
        hash2 = 17 * hash2 + Objects.hashCode(this.messageLine);
        return hash2;
    }

    public String toString() {
        return this.file + ":" + this.fromLine + "." + this.fromColumn + "-" + this.toLine + "." + this.toColumn + ": " + this.message;
    }

    public static enum MessageType {
        ERROR,
        WARNING,
        INFO,
        UNKNOWN;

    }
}

