/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import java.net.URI;
import java.net.URISyntaxException;

public final class URIUtils {
    private URIUtils() {
    }

    public static URI canonicalize(URI uri) {
        URI newURI;
        if (uri.getScheme().equals("untitled")) {
            return uri;
        }
        uri = uri.normalize();
        try {
            newURI = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException ex) {
            throw new Error(ex);
        }
        return newURI;
    }

    public static URI canonicalize(String uri) {
        return URIUtils.canonicalize(URI.create(uri));
    }
}

