/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.blocks;

import com.laytonsmith.PureUtilities.ClassLoading.DynamicEnum;
import com.laytonsmith.abstraction.AbstractionObject;
import com.laytonsmith.abstraction.blocks.MCBlockData;
import com.laytonsmith.abstraction.enums.MCVersion;
import com.laytonsmith.annotations.MDynamicEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@MDynamicEnum(value="com.commandhelper.Material")
public abstract class MCMaterial<Concrete>
extends DynamicEnum<MCVanillaMaterial, Concrete>
implements AbstractionObject {
    protected static final Map<String, MCMaterial> BY_STRING = new HashMap<String, MCMaterial>();

    public MCMaterial(MCVanillaMaterial mcVanillaMaterial, Concrete concrete) {
        super(mcVanillaMaterial, concrete);
    }

    public static MCMaterial valueOf(String materialName) throws IllegalArgumentException {
        MCMaterial ret = MCMaterial.get(materialName);
        if (ret == null) {
            throw new IllegalArgumentException("Unknown material type: " + materialName);
        }
        return ret;
    }

    public static MCMaterial get(String materialName) {
        return BY_STRING.get(materialName);
    }

    public static Set<String> types() {
        if (BY_STRING.isEmpty()) {
            HashSet<String> dummy = new HashSet<String>();
            for (MCVanillaMaterial t : MCVanillaMaterial.values()) {
                if (!t.existsIn(MCVersion.CURRENT)) continue;
                dummy.add(t.name());
            }
            return dummy;
        }
        return BY_STRING.keySet();
    }

    public static List<MCMaterial> values() {
        if (BY_STRING.isEmpty()) {
            ArrayList<MCMaterial> dummy = new ArrayList<MCMaterial>();
            for (final MCVanillaMaterial t : MCVanillaMaterial.values()) {
                if (!t.existsIn(MCVersion.CURRENT)) continue;
                dummy.add(new MCMaterial<Object>(t, null){

                    @Override
                    public String name() {
                        return t.name();
                    }
                });
            }
            return dummy;
        }
        return new ArrayList<MCMaterial>(BY_STRING.values());
    }

    public MCBlockData createBlockData() {
        throw new UnsupportedOperationException();
    }

    public short getMaxDurability() {
        throw new UnsupportedOperationException();
    }

    public int getType() {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.name();
    }

    public int getMaxStackSize() {
        throw new UnsupportedOperationException();
    }

    public boolean hasGravity() {
        throw new UnsupportedOperationException();
    }

    public boolean isBlock() {
        throw new UnsupportedOperationException();
    }

    public boolean isItem() {
        throw new UnsupportedOperationException();
    }

    public boolean isBurnable() {
        throw new UnsupportedOperationException();
    }

    public boolean isEdible() {
        throw new UnsupportedOperationException();
    }

    public boolean isFlammable() {
        throw new UnsupportedOperationException();
    }

    public boolean isOccluding() {
        throw new UnsupportedOperationException();
    }

    public boolean isRecord() {
        throw new UnsupportedOperationException();
    }

    public boolean isSolid() {
        throw new UnsupportedOperationException();
    }

    public boolean isTransparent() {
        throw new UnsupportedOperationException();
    }

    public boolean isInteractable() {
        throw new UnsupportedOperationException();
    }

    public boolean isAir() {
        return this.getAbstracted() == MCVanillaMaterial.AIR || this.getAbstracted() == MCVanillaMaterial.VOID_AIR;
    }

    public boolean isLegacy() {
        return false;
    }

    public float getHardness() {
        throw new UnsupportedOperationException();
    }

    public float getBlastResistance() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getHandle() {
        return this.getConcrete();
    }

    public static enum MCVanillaMaterial {
        AIR,
        STONE,
        GRANITE,
        POLISHED_GRANITE,
        DIORITE,
        POLISHED_DIORITE,
        ANDESITE,
        POLISHED_ANDESITE,
        GRASS_BLOCK,
        DIRT,
        COARSE_DIRT,
        PODZOL,
        CRIMSON_NYLIUM,
        WARPED_NYLIUM,
        COBBLESTONE,
        OAK_PLANKS,
        SPRUCE_PLANKS,
        BIRCH_PLANKS,
        JUNGLE_PLANKS,
        ACACIA_PLANKS,
        DARK_OAK_PLANKS,
        CRIMSON_PLANKS,
        WARPED_PLANKS,
        OAK_SAPLING,
        SPRUCE_SAPLING,
        BIRCH_SAPLING,
        JUNGLE_SAPLING,
        ACACIA_SAPLING,
        DARK_OAK_SAPLING,
        BEDROCK,
        SAND,
        RED_SAND,
        GRAVEL,
        COAL_ORE,
        IRON_ORE,
        GOLD_ORE,
        REDSTONE_ORE,
        EMERALD_ORE,
        LAPIS_ORE,
        DIAMOND_ORE,
        NETHER_GOLD_ORE,
        NETHER_QUARTZ_ORE,
        ANCIENT_DEBRIS,
        COAL_BLOCK,
        IRON_BLOCK,
        GOLD_BLOCK,
        DIAMOND_BLOCK,
        NETHERITE_BLOCK,
        OAK_LOG,
        SPRUCE_LOG,
        BIRCH_LOG,
        JUNGLE_LOG,
        ACACIA_LOG,
        DARK_OAK_LOG,
        CRIMSON_STEM,
        WARPED_STEM,
        STRIPPED_OAK_LOG,
        STRIPPED_SPRUCE_LOG,
        STRIPPED_BIRCH_LOG,
        STRIPPED_JUNGLE_LOG,
        STRIPPED_ACACIA_LOG,
        STRIPPED_DARK_OAK_LOG,
        STRIPPED_CRIMSON_STEM,
        STRIPPED_WARPED_STEM,
        STRIPPED_OAK_WOOD,
        STRIPPED_SPRUCE_WOOD,
        STRIPPED_BIRCH_WOOD,
        STRIPPED_JUNGLE_WOOD,
        STRIPPED_ACACIA_WOOD,
        STRIPPED_DARK_OAK_WOOD,
        STRIPPED_CRIMSON_HYPHAE,
        STRIPPED_WARPED_HYPHAE,
        OAK_WOOD,
        SPRUCE_WOOD,
        BIRCH_WOOD,
        JUNGLE_WOOD,
        ACACIA_WOOD,
        DARK_OAK_WOOD,
        CRIMSON_HYPHAE,
        WARPED_HYPHAE,
        OAK_LEAVES,
        SPRUCE_LEAVES,
        BIRCH_LEAVES,
        JUNGLE_LEAVES,
        ACACIA_LEAVES,
        DARK_OAK_LEAVES,
        SPONGE,
        WET_SPONGE,
        GLASS,
        LAPIS_BLOCK,
        SANDSTONE,
        CHISELED_SANDSTONE,
        CUT_SANDSTONE,
        COBWEB,
        GRASS(MCVersion.MC1_0, MCVersion.MC1_20_2),
        SHORT_GRASS(MCVersion.MC1_20_4),
        FERN,
        DEAD_BUSH,
        SEAGRASS,
        SEA_PICKLE,
        WHITE_WOOL,
        ORANGE_WOOL,
        MAGENTA_WOOL,
        LIGHT_BLUE_WOOL,
        YELLOW_WOOL,
        LIME_WOOL,
        PINK_WOOL,
        GRAY_WOOL,
        LIGHT_GRAY_WOOL,
        CYAN_WOOL,
        PURPLE_WOOL,
        BLUE_WOOL,
        BROWN_WOOL,
        GREEN_WOOL,
        RED_WOOL,
        BLACK_WOOL,
        DANDELION,
        POPPY,
        BLUE_ORCHID,
        ALLIUM,
        AZURE_BLUET,
        RED_TULIP,
        ORANGE_TULIP,
        WHITE_TULIP,
        PINK_TULIP,
        OXEYE_DAISY,
        CORNFLOWER,
        LILY_OF_THE_VALLEY,
        WITHER_ROSE,
        BROWN_MUSHROOM,
        RED_MUSHROOM,
        CRIMSON_FUNGUS,
        WARPED_FUNGUS,
        CRIMSON_ROOTS,
        WARPED_ROOTS,
        NETHER_SPROUTS,
        WEEPING_VINES,
        TWISTING_VINES,
        SUGAR_CANE,
        KELP,
        BAMBOO,
        OAK_SLAB,
        SPRUCE_SLAB,
        BIRCH_SLAB,
        JUNGLE_SLAB,
        ACACIA_SLAB,
        DARK_OAK_SLAB,
        CRIMSON_SLAB,
        WARPED_SLAB,
        STONE_SLAB,
        SMOOTH_STONE_SLAB,
        SANDSTONE_SLAB,
        CUT_SANDSTONE_SLAB,
        PETRIFIED_OAK_SLAB,
        COBBLESTONE_SLAB,
        BRICK_SLAB,
        STONE_BRICK_SLAB,
        NETHER_BRICK_SLAB,
        QUARTZ_SLAB,
        RED_SANDSTONE_SLAB,
        CUT_RED_SANDSTONE_SLAB,
        PURPUR_SLAB,
        PRISMARINE_SLAB,
        PRISMARINE_BRICK_SLAB,
        DARK_PRISMARINE_SLAB,
        SMOOTH_QUARTZ,
        SMOOTH_RED_SANDSTONE,
        SMOOTH_SANDSTONE,
        SMOOTH_STONE,
        BRICKS,
        BOOKSHELF,
        MOSSY_COBBLESTONE,
        OBSIDIAN,
        TORCH,
        END_ROD,
        CHORUS_PLANT,
        CHORUS_FLOWER,
        PURPUR_BLOCK,
        PURPUR_PILLAR,
        PURPUR_STAIRS,
        SPAWNER,
        OAK_STAIRS,
        CHEST,
        CRAFTING_TABLE,
        FARMLAND,
        FURNACE,
        LADDER,
        COBBLESTONE_STAIRS,
        SNOW,
        ICE,
        SNOW_BLOCK,
        CACTUS,
        CLAY,
        JUKEBOX,
        OAK_FENCE,
        SPRUCE_FENCE,
        BIRCH_FENCE,
        JUNGLE_FENCE,
        ACACIA_FENCE,
        DARK_OAK_FENCE,
        CRIMSON_FENCE,
        WARPED_FENCE,
        PUMPKIN,
        CARVED_PUMPKIN,
        JACK_O_LANTERN,
        NETHERRACK,
        SOUL_SAND,
        SOUL_SOIL,
        BASALT,
        POLISHED_BASALT,
        SOUL_TORCH,
        GLOWSTONE,
        INFESTED_STONE,
        INFESTED_COBBLESTONE,
        INFESTED_STONE_BRICKS,
        INFESTED_MOSSY_STONE_BRICKS,
        INFESTED_CRACKED_STONE_BRICKS,
        INFESTED_CHISELED_STONE_BRICKS,
        STONE_BRICKS,
        MOSSY_STONE_BRICKS,
        CRACKED_STONE_BRICKS,
        CHISELED_STONE_BRICKS,
        BROWN_MUSHROOM_BLOCK,
        RED_MUSHROOM_BLOCK,
        MUSHROOM_STEM,
        IRON_BARS,
        CHAIN,
        GLASS_PANE,
        MELON,
        VINE,
        BRICK_STAIRS,
        STONE_BRICK_STAIRS,
        MYCELIUM,
        LILY_PAD,
        NETHER_BRICKS,
        CRACKED_NETHER_BRICKS,
        CHISELED_NETHER_BRICKS,
        NETHER_BRICK_FENCE,
        NETHER_BRICK_STAIRS,
        ENCHANTING_TABLE,
        END_PORTAL_FRAME,
        END_STONE,
        END_STONE_BRICKS,
        DRAGON_EGG,
        SANDSTONE_STAIRS,
        ENDER_CHEST,
        EMERALD_BLOCK,
        SPRUCE_STAIRS,
        BIRCH_STAIRS,
        JUNGLE_STAIRS,
        CRIMSON_STAIRS,
        WARPED_STAIRS,
        COMMAND_BLOCK,
        BEACON,
        COBBLESTONE_WALL,
        MOSSY_COBBLESTONE_WALL,
        BRICK_WALL,
        PRISMARINE_WALL,
        RED_SANDSTONE_WALL,
        MOSSY_STONE_BRICK_WALL,
        GRANITE_WALL,
        STONE_BRICK_WALL,
        NETHER_BRICK_WALL,
        ANDESITE_WALL,
        RED_NETHER_BRICK_WALL,
        SANDSTONE_WALL,
        END_STONE_BRICK_WALL,
        DIORITE_WALL,
        BLACKSTONE_WALL,
        POLISHED_BLACKSTONE_WALL,
        POLISHED_BLACKSTONE_BRICK_WALL,
        ANVIL,
        CHIPPED_ANVIL,
        DAMAGED_ANVIL,
        CHISELED_QUARTZ_BLOCK,
        QUARTZ_BLOCK,
        QUARTZ_BRICKS,
        QUARTZ_PILLAR,
        QUARTZ_STAIRS,
        WHITE_TERRACOTTA,
        ORANGE_TERRACOTTA,
        MAGENTA_TERRACOTTA,
        LIGHT_BLUE_TERRACOTTA,
        YELLOW_TERRACOTTA,
        LIME_TERRACOTTA,
        PINK_TERRACOTTA,
        GRAY_TERRACOTTA,
        LIGHT_GRAY_TERRACOTTA,
        CYAN_TERRACOTTA,
        PURPLE_TERRACOTTA,
        BLUE_TERRACOTTA,
        BROWN_TERRACOTTA,
        GREEN_TERRACOTTA,
        RED_TERRACOTTA,
        BLACK_TERRACOTTA,
        BARRIER,
        HAY_BLOCK,
        WHITE_CARPET,
        ORANGE_CARPET,
        MAGENTA_CARPET,
        LIGHT_BLUE_CARPET,
        YELLOW_CARPET,
        LIME_CARPET,
        PINK_CARPET,
        GRAY_CARPET,
        LIGHT_GRAY_CARPET,
        CYAN_CARPET,
        PURPLE_CARPET,
        BLUE_CARPET,
        BROWN_CARPET,
        GREEN_CARPET,
        RED_CARPET,
        BLACK_CARPET,
        TERRACOTTA,
        PACKED_ICE,
        ACACIA_STAIRS,
        DARK_OAK_STAIRS,
        SUNFLOWER,
        LILAC,
        ROSE_BUSH,
        PEONY,
        TALL_GRASS,
        LARGE_FERN,
        WHITE_STAINED_GLASS,
        ORANGE_STAINED_GLASS,
        MAGENTA_STAINED_GLASS,
        LIGHT_BLUE_STAINED_GLASS,
        YELLOW_STAINED_GLASS,
        LIME_STAINED_GLASS,
        PINK_STAINED_GLASS,
        GRAY_STAINED_GLASS,
        LIGHT_GRAY_STAINED_GLASS,
        CYAN_STAINED_GLASS,
        PURPLE_STAINED_GLASS,
        BLUE_STAINED_GLASS,
        BROWN_STAINED_GLASS,
        GREEN_STAINED_GLASS,
        RED_STAINED_GLASS,
        BLACK_STAINED_GLASS,
        WHITE_STAINED_GLASS_PANE,
        ORANGE_STAINED_GLASS_PANE,
        MAGENTA_STAINED_GLASS_PANE,
        LIGHT_BLUE_STAINED_GLASS_PANE,
        YELLOW_STAINED_GLASS_PANE,
        LIME_STAINED_GLASS_PANE,
        PINK_STAINED_GLASS_PANE,
        GRAY_STAINED_GLASS_PANE,
        LIGHT_GRAY_STAINED_GLASS_PANE,
        CYAN_STAINED_GLASS_PANE,
        PURPLE_STAINED_GLASS_PANE,
        BLUE_STAINED_GLASS_PANE,
        BROWN_STAINED_GLASS_PANE,
        GREEN_STAINED_GLASS_PANE,
        RED_STAINED_GLASS_PANE,
        BLACK_STAINED_GLASS_PANE,
        PRISMARINE,
        PRISMARINE_BRICKS,
        DARK_PRISMARINE,
        PRISMARINE_STAIRS,
        PRISMARINE_BRICK_STAIRS,
        DARK_PRISMARINE_STAIRS,
        SEA_LANTERN,
        RED_SANDSTONE,
        CHISELED_RED_SANDSTONE,
        CUT_RED_SANDSTONE,
        RED_SANDSTONE_STAIRS,
        REPEATING_COMMAND_BLOCK,
        CHAIN_COMMAND_BLOCK,
        MAGMA_BLOCK,
        NETHER_WART_BLOCK,
        WARPED_WART_BLOCK,
        RED_NETHER_BRICKS,
        BONE_BLOCK,
        STRUCTURE_VOID,
        SHULKER_BOX,
        WHITE_SHULKER_BOX,
        ORANGE_SHULKER_BOX,
        MAGENTA_SHULKER_BOX,
        LIGHT_BLUE_SHULKER_BOX,
        YELLOW_SHULKER_BOX,
        LIME_SHULKER_BOX,
        PINK_SHULKER_BOX,
        GRAY_SHULKER_BOX,
        LIGHT_GRAY_SHULKER_BOX,
        CYAN_SHULKER_BOX,
        PURPLE_SHULKER_BOX,
        BLUE_SHULKER_BOX,
        BROWN_SHULKER_BOX,
        GREEN_SHULKER_BOX,
        RED_SHULKER_BOX,
        BLACK_SHULKER_BOX,
        WHITE_GLAZED_TERRACOTTA,
        ORANGE_GLAZED_TERRACOTTA,
        MAGENTA_GLAZED_TERRACOTTA,
        LIGHT_BLUE_GLAZED_TERRACOTTA,
        YELLOW_GLAZED_TERRACOTTA,
        LIME_GLAZED_TERRACOTTA,
        PINK_GLAZED_TERRACOTTA,
        GRAY_GLAZED_TERRACOTTA,
        LIGHT_GRAY_GLAZED_TERRACOTTA,
        CYAN_GLAZED_TERRACOTTA,
        PURPLE_GLAZED_TERRACOTTA,
        BLUE_GLAZED_TERRACOTTA,
        BROWN_GLAZED_TERRACOTTA,
        GREEN_GLAZED_TERRACOTTA,
        RED_GLAZED_TERRACOTTA,
        BLACK_GLAZED_TERRACOTTA,
        WHITE_CONCRETE,
        ORANGE_CONCRETE,
        MAGENTA_CONCRETE,
        LIGHT_BLUE_CONCRETE,
        YELLOW_CONCRETE,
        LIME_CONCRETE,
        PINK_CONCRETE,
        GRAY_CONCRETE,
        LIGHT_GRAY_CONCRETE,
        CYAN_CONCRETE,
        PURPLE_CONCRETE,
        BLUE_CONCRETE,
        BROWN_CONCRETE,
        GREEN_CONCRETE,
        RED_CONCRETE,
        BLACK_CONCRETE,
        WHITE_CONCRETE_POWDER,
        ORANGE_CONCRETE_POWDER,
        MAGENTA_CONCRETE_POWDER,
        LIGHT_BLUE_CONCRETE_POWDER,
        YELLOW_CONCRETE_POWDER,
        LIME_CONCRETE_POWDER,
        PINK_CONCRETE_POWDER,
        GRAY_CONCRETE_POWDER,
        LIGHT_GRAY_CONCRETE_POWDER,
        CYAN_CONCRETE_POWDER,
        PURPLE_CONCRETE_POWDER,
        BLUE_CONCRETE_POWDER,
        BROWN_CONCRETE_POWDER,
        GREEN_CONCRETE_POWDER,
        RED_CONCRETE_POWDER,
        BLACK_CONCRETE_POWDER,
        TURTLE_EGG,
        DEAD_TUBE_CORAL_BLOCK,
        DEAD_BRAIN_CORAL_BLOCK,
        DEAD_BUBBLE_CORAL_BLOCK,
        DEAD_FIRE_CORAL_BLOCK,
        DEAD_HORN_CORAL_BLOCK,
        TUBE_CORAL_BLOCK,
        BRAIN_CORAL_BLOCK,
        BUBBLE_CORAL_BLOCK,
        FIRE_CORAL_BLOCK,
        HORN_CORAL_BLOCK,
        TUBE_CORAL,
        BRAIN_CORAL,
        BUBBLE_CORAL,
        FIRE_CORAL,
        HORN_CORAL,
        DEAD_BRAIN_CORAL,
        DEAD_BUBBLE_CORAL,
        DEAD_FIRE_CORAL,
        DEAD_HORN_CORAL,
        DEAD_TUBE_CORAL,
        TUBE_CORAL_FAN,
        BRAIN_CORAL_FAN,
        BUBBLE_CORAL_FAN,
        FIRE_CORAL_FAN,
        HORN_CORAL_FAN,
        DEAD_TUBE_CORAL_FAN,
        DEAD_BRAIN_CORAL_FAN,
        DEAD_BUBBLE_CORAL_FAN,
        DEAD_FIRE_CORAL_FAN,
        DEAD_HORN_CORAL_FAN,
        BLUE_ICE,
        CONDUIT,
        POLISHED_GRANITE_STAIRS,
        SMOOTH_RED_SANDSTONE_STAIRS,
        MOSSY_STONE_BRICK_STAIRS,
        POLISHED_DIORITE_STAIRS,
        MOSSY_COBBLESTONE_STAIRS,
        END_STONE_BRICK_STAIRS,
        STONE_STAIRS,
        SMOOTH_SANDSTONE_STAIRS,
        SMOOTH_QUARTZ_STAIRS,
        GRANITE_STAIRS,
        ANDESITE_STAIRS,
        RED_NETHER_BRICK_STAIRS,
        POLISHED_ANDESITE_STAIRS,
        DIORITE_STAIRS,
        POLISHED_GRANITE_SLAB,
        SMOOTH_RED_SANDSTONE_SLAB,
        MOSSY_STONE_BRICK_SLAB,
        POLISHED_DIORITE_SLAB,
        MOSSY_COBBLESTONE_SLAB,
        END_STONE_BRICK_SLAB,
        SMOOTH_SANDSTONE_SLAB,
        SMOOTH_QUARTZ_SLAB,
        GRANITE_SLAB,
        ANDESITE_SLAB,
        RED_NETHER_BRICK_SLAB,
        POLISHED_ANDESITE_SLAB,
        DIORITE_SLAB,
        SCAFFOLDING,
        REDSTONE,
        REDSTONE_TORCH,
        REDSTONE_BLOCK,
        REPEATER,
        COMPARATOR,
        PISTON,
        STICKY_PISTON,
        SLIME_BLOCK,
        HONEY_BLOCK,
        OBSERVER,
        HOPPER,
        DISPENSER,
        DROPPER,
        LECTERN,
        TARGET,
        LEVER,
        DAYLIGHT_DETECTOR,
        TRIPWIRE_HOOK,
        TRAPPED_CHEST,
        TNT,
        REDSTONE_LAMP,
        NOTE_BLOCK,
        STONE_BUTTON,
        POLISHED_BLACKSTONE_BUTTON,
        OAK_BUTTON,
        SPRUCE_BUTTON,
        BIRCH_BUTTON,
        JUNGLE_BUTTON,
        ACACIA_BUTTON,
        DARK_OAK_BUTTON,
        CRIMSON_BUTTON,
        WARPED_BUTTON,
        STONE_PRESSURE_PLATE,
        POLISHED_BLACKSTONE_PRESSURE_PLATE,
        LIGHT_WEIGHTED_PRESSURE_PLATE,
        HEAVY_WEIGHTED_PRESSURE_PLATE,
        OAK_PRESSURE_PLATE,
        SPRUCE_PRESSURE_PLATE,
        BIRCH_PRESSURE_PLATE,
        JUNGLE_PRESSURE_PLATE,
        ACACIA_PRESSURE_PLATE,
        DARK_OAK_PRESSURE_PLATE,
        CRIMSON_PRESSURE_PLATE,
        WARPED_PRESSURE_PLATE,
        IRON_DOOR,
        OAK_DOOR,
        SPRUCE_DOOR,
        BIRCH_DOOR,
        JUNGLE_DOOR,
        ACACIA_DOOR,
        DARK_OAK_DOOR,
        CRIMSON_DOOR,
        WARPED_DOOR,
        IRON_TRAPDOOR,
        OAK_TRAPDOOR,
        SPRUCE_TRAPDOOR,
        BIRCH_TRAPDOOR,
        JUNGLE_TRAPDOOR,
        ACACIA_TRAPDOOR,
        DARK_OAK_TRAPDOOR,
        CRIMSON_TRAPDOOR,
        WARPED_TRAPDOOR,
        OAK_FENCE_GATE,
        SPRUCE_FENCE_GATE,
        BIRCH_FENCE_GATE,
        JUNGLE_FENCE_GATE,
        ACACIA_FENCE_GATE,
        DARK_OAK_FENCE_GATE,
        CRIMSON_FENCE_GATE,
        WARPED_FENCE_GATE,
        POWERED_RAIL,
        DETECTOR_RAIL,
        RAIL,
        ACTIVATOR_RAIL,
        SADDLE,
        MINECART,
        CHEST_MINECART,
        FURNACE_MINECART,
        TNT_MINECART,
        HOPPER_MINECART,
        CARROT_ON_A_STICK,
        WARPED_FUNGUS_ON_A_STICK,
        ELYTRA,
        OAK_BOAT,
        SPRUCE_BOAT,
        BIRCH_BOAT,
        JUNGLE_BOAT,
        ACACIA_BOAT,
        DARK_OAK_BOAT,
        STRUCTURE_BLOCK,
        JIGSAW,
        TURTLE_HELMET,
        SCUTE(MCVersion.MC1_13, MCVersion.MC1_20_4),
        TURTLE_SCUTE(MCVersion.MC1_20_6),
        FLINT_AND_STEEL,
        APPLE,
        BOW,
        ARROW,
        COAL,
        CHARCOAL,
        DIAMOND,
        EMERALD,
        LAPIS_LAZULI,
        QUARTZ,
        IRON_INGOT,
        GOLD_INGOT,
        NETHERITE_INGOT,
        NETHERITE_SCRAP,
        WOODEN_SWORD,
        WOODEN_SHOVEL,
        WOODEN_PICKAXE,
        WOODEN_AXE,
        WOODEN_HOE,
        STONE_SWORD,
        STONE_SHOVEL,
        STONE_PICKAXE,
        STONE_AXE,
        STONE_HOE,
        GOLDEN_SWORD,
        GOLDEN_SHOVEL,
        GOLDEN_PICKAXE,
        GOLDEN_AXE,
        GOLDEN_HOE,
        IRON_SWORD,
        IRON_SHOVEL,
        IRON_PICKAXE,
        IRON_AXE,
        IRON_HOE,
        DIAMOND_SWORD,
        DIAMOND_SHOVEL,
        DIAMOND_PICKAXE,
        DIAMOND_AXE,
        DIAMOND_HOE,
        NETHERITE_SWORD,
        NETHERITE_SHOVEL,
        NETHERITE_PICKAXE,
        NETHERITE_AXE,
        NETHERITE_HOE,
        STICK,
        BOWL,
        MUSHROOM_STEW,
        STRING,
        FEATHER,
        GUNPOWDER,
        WHEAT_SEEDS,
        WHEAT,
        BREAD,
        LEATHER_HELMET,
        LEATHER_CHESTPLATE,
        LEATHER_LEGGINGS,
        LEATHER_BOOTS,
        CHAINMAIL_HELMET,
        CHAINMAIL_CHESTPLATE,
        CHAINMAIL_LEGGINGS,
        CHAINMAIL_BOOTS,
        IRON_HELMET,
        IRON_CHESTPLATE,
        IRON_LEGGINGS,
        IRON_BOOTS,
        DIAMOND_HELMET,
        DIAMOND_CHESTPLATE,
        DIAMOND_LEGGINGS,
        DIAMOND_BOOTS,
        GOLDEN_HELMET,
        GOLDEN_CHESTPLATE,
        GOLDEN_LEGGINGS,
        GOLDEN_BOOTS,
        NETHERITE_HELMET,
        NETHERITE_CHESTPLATE,
        NETHERITE_LEGGINGS,
        NETHERITE_BOOTS,
        FLINT,
        PORKCHOP,
        COOKED_PORKCHOP,
        PAINTING,
        GOLDEN_APPLE,
        ENCHANTED_GOLDEN_APPLE,
        OAK_SIGN,
        SPRUCE_SIGN,
        BIRCH_SIGN,
        JUNGLE_SIGN,
        ACACIA_SIGN,
        DARK_OAK_SIGN,
        CRIMSON_SIGN,
        WARPED_SIGN,
        BUCKET,
        WATER_BUCKET,
        LAVA_BUCKET,
        SNOWBALL,
        LEATHER,
        MILK_BUCKET,
        PUFFERFISH_BUCKET,
        SALMON_BUCKET,
        COD_BUCKET,
        TROPICAL_FISH_BUCKET,
        BRICK,
        CLAY_BALL,
        DRIED_KELP_BLOCK,
        PAPER,
        BOOK,
        SLIME_BALL,
        EGG,
        COMPASS,
        FISHING_ROD,
        CLOCK,
        GLOWSTONE_DUST,
        COD,
        SALMON,
        TROPICAL_FISH,
        PUFFERFISH,
        COOKED_COD,
        COOKED_SALMON,
        INK_SAC,
        COCOA_BEANS,
        WHITE_DYE,
        ORANGE_DYE,
        MAGENTA_DYE,
        LIGHT_BLUE_DYE,
        YELLOW_DYE,
        LIME_DYE,
        PINK_DYE,
        GRAY_DYE,
        LIGHT_GRAY_DYE,
        CYAN_DYE,
        PURPLE_DYE,
        BLUE_DYE,
        BROWN_DYE,
        GREEN_DYE,
        RED_DYE,
        BLACK_DYE,
        BONE_MEAL,
        BONE,
        SUGAR,
        CAKE,
        WHITE_BED,
        ORANGE_BED,
        MAGENTA_BED,
        LIGHT_BLUE_BED,
        YELLOW_BED,
        LIME_BED,
        PINK_BED,
        GRAY_BED,
        LIGHT_GRAY_BED,
        CYAN_BED,
        PURPLE_BED,
        BLUE_BED,
        BROWN_BED,
        GREEN_BED,
        RED_BED,
        BLACK_BED,
        COOKIE,
        FILLED_MAP,
        SHEARS,
        MELON_SLICE,
        DRIED_KELP,
        PUMPKIN_SEEDS,
        MELON_SEEDS,
        BEEF,
        COOKED_BEEF,
        CHICKEN,
        COOKED_CHICKEN,
        ROTTEN_FLESH,
        ENDER_PEARL,
        BLAZE_ROD,
        GHAST_TEAR,
        GOLD_NUGGET,
        NETHER_WART,
        POTION,
        GLASS_BOTTLE,
        SPIDER_EYE,
        FERMENTED_SPIDER_EYE,
        BLAZE_POWDER,
        MAGMA_CREAM,
        BREWING_STAND,
        CAULDRON,
        ENDER_EYE,
        GLISTERING_MELON_SLICE,
        BAT_SPAWN_EGG,
        BEE_SPAWN_EGG,
        BLAZE_SPAWN_EGG,
        CAT_SPAWN_EGG,
        CAVE_SPIDER_SPAWN_EGG,
        CHICKEN_SPAWN_EGG,
        COD_SPAWN_EGG,
        COW_SPAWN_EGG,
        CREEPER_SPAWN_EGG,
        DOLPHIN_SPAWN_EGG,
        DONKEY_SPAWN_EGG,
        DROWNED_SPAWN_EGG,
        ELDER_GUARDIAN_SPAWN_EGG,
        ENDERMAN_SPAWN_EGG,
        ENDERMITE_SPAWN_EGG,
        EVOKER_SPAWN_EGG,
        FOX_SPAWN_EGG,
        GHAST_SPAWN_EGG,
        GUARDIAN_SPAWN_EGG,
        HOGLIN_SPAWN_EGG,
        HORSE_SPAWN_EGG,
        HUSK_SPAWN_EGG,
        LLAMA_SPAWN_EGG,
        MAGMA_CUBE_SPAWN_EGG,
        MOOSHROOM_SPAWN_EGG,
        MULE_SPAWN_EGG,
        OCELOT_SPAWN_EGG,
        PANDA_SPAWN_EGG,
        PARROT_SPAWN_EGG,
        PHANTOM_SPAWN_EGG,
        PIG_SPAWN_EGG,
        PIGLIN_SPAWN_EGG,
        PIGLIN_BRUTE_SPAWN_EGG,
        PILLAGER_SPAWN_EGG,
        POLAR_BEAR_SPAWN_EGG,
        PUFFERFISH_SPAWN_EGG,
        RABBIT_SPAWN_EGG,
        RAVAGER_SPAWN_EGG,
        SALMON_SPAWN_EGG,
        SHEEP_SPAWN_EGG,
        SHULKER_SPAWN_EGG,
        SILVERFISH_SPAWN_EGG,
        SKELETON_SPAWN_EGG,
        SKELETON_HORSE_SPAWN_EGG,
        SLIME_SPAWN_EGG,
        SPIDER_SPAWN_EGG,
        SQUID_SPAWN_EGG,
        STRAY_SPAWN_EGG,
        STRIDER_SPAWN_EGG,
        TRADER_LLAMA_SPAWN_EGG,
        TROPICAL_FISH_SPAWN_EGG,
        TURTLE_SPAWN_EGG,
        VEX_SPAWN_EGG,
        VILLAGER_SPAWN_EGG,
        VINDICATOR_SPAWN_EGG,
        WANDERING_TRADER_SPAWN_EGG,
        WITCH_SPAWN_EGG,
        WITHER_SKELETON_SPAWN_EGG,
        WOLF_SPAWN_EGG,
        ZOGLIN_SPAWN_EGG,
        ZOMBIE_SPAWN_EGG,
        ZOMBIE_HORSE_SPAWN_EGG,
        ZOMBIE_VILLAGER_SPAWN_EGG,
        ZOMBIFIED_PIGLIN_SPAWN_EGG,
        EXPERIENCE_BOTTLE,
        FIRE_CHARGE,
        WRITABLE_BOOK,
        WRITTEN_BOOK,
        ITEM_FRAME,
        FLOWER_POT,
        CARROT,
        POTATO,
        BAKED_POTATO,
        POISONOUS_POTATO,
        MAP,
        GOLDEN_CARROT,
        SKELETON_SKULL,
        WITHER_SKELETON_SKULL,
        PLAYER_HEAD,
        ZOMBIE_HEAD,
        CREEPER_HEAD,
        DRAGON_HEAD,
        NETHER_STAR,
        PUMPKIN_PIE,
        FIREWORK_ROCKET,
        FIREWORK_STAR,
        ENCHANTED_BOOK,
        NETHER_BRICK,
        PRISMARINE_SHARD,
        PRISMARINE_CRYSTALS,
        RABBIT,
        COOKED_RABBIT,
        RABBIT_STEW,
        RABBIT_FOOT,
        RABBIT_HIDE,
        ARMOR_STAND,
        IRON_HORSE_ARMOR,
        GOLDEN_HORSE_ARMOR,
        DIAMOND_HORSE_ARMOR,
        LEATHER_HORSE_ARMOR,
        LEAD,
        NAME_TAG,
        COMMAND_BLOCK_MINECART,
        MUTTON,
        COOKED_MUTTON,
        WHITE_BANNER,
        ORANGE_BANNER,
        MAGENTA_BANNER,
        LIGHT_BLUE_BANNER,
        YELLOW_BANNER,
        LIME_BANNER,
        PINK_BANNER,
        GRAY_BANNER,
        LIGHT_GRAY_BANNER,
        CYAN_BANNER,
        PURPLE_BANNER,
        BLUE_BANNER,
        BROWN_BANNER,
        GREEN_BANNER,
        RED_BANNER,
        BLACK_BANNER,
        END_CRYSTAL,
        CHORUS_FRUIT,
        POPPED_CHORUS_FRUIT,
        BEETROOT,
        BEETROOT_SEEDS,
        BEETROOT_SOUP,
        DRAGON_BREATH,
        SPLASH_POTION,
        SPECTRAL_ARROW,
        TIPPED_ARROW,
        LINGERING_POTION,
        SHIELD,
        TOTEM_OF_UNDYING,
        SHULKER_SHELL,
        IRON_NUGGET,
        KNOWLEDGE_BOOK,
        DEBUG_STICK,
        MUSIC_DISC_13,
        MUSIC_DISC_CAT,
        MUSIC_DISC_BLOCKS,
        MUSIC_DISC_CHIRP,
        MUSIC_DISC_FAR,
        MUSIC_DISC_MALL,
        MUSIC_DISC_MELLOHI,
        MUSIC_DISC_STAL,
        MUSIC_DISC_STRAD,
        MUSIC_DISC_WARD,
        MUSIC_DISC_11,
        MUSIC_DISC_WAIT,
        MUSIC_DISC_PIGSTEP,
        TRIDENT,
        PHANTOM_MEMBRANE,
        NAUTILUS_SHELL,
        HEART_OF_THE_SEA,
        CROSSBOW,
        SUSPICIOUS_STEW,
        LOOM,
        FLOWER_BANNER_PATTERN,
        CREEPER_BANNER_PATTERN,
        SKULL_BANNER_PATTERN,
        MOJANG_BANNER_PATTERN,
        GLOBE_BANNER_PATTERN,
        PIGLIN_BANNER_PATTERN,
        COMPOSTER,
        BARREL,
        SMOKER,
        BLAST_FURNACE,
        CARTOGRAPHY_TABLE,
        FLETCHING_TABLE,
        GRINDSTONE,
        SMITHING_TABLE,
        STONECUTTER,
        BELL,
        LANTERN,
        SOUL_LANTERN,
        SWEET_BERRIES,
        CAMPFIRE,
        SOUL_CAMPFIRE,
        SHROOMLIGHT,
        HONEYCOMB,
        BEE_NEST,
        BEEHIVE,
        HONEY_BOTTLE,
        HONEYCOMB_BLOCK,
        LODESTONE,
        CRYING_OBSIDIAN,
        BLACKSTONE,
        BLACKSTONE_SLAB,
        BLACKSTONE_STAIRS,
        GILDED_BLACKSTONE,
        POLISHED_BLACKSTONE,
        POLISHED_BLACKSTONE_SLAB,
        POLISHED_BLACKSTONE_STAIRS,
        CHISELED_POLISHED_BLACKSTONE,
        POLISHED_BLACKSTONE_BRICKS,
        POLISHED_BLACKSTONE_BRICK_SLAB,
        POLISHED_BLACKSTONE_BRICK_STAIRS,
        CRACKED_POLISHED_BLACKSTONE_BRICKS,
        RESPAWN_ANCHOR,
        WATER,
        LAVA,
        TALL_SEAGRASS,
        PISTON_HEAD,
        MOVING_PISTON,
        WALL_TORCH,
        FIRE,
        SOUL_FIRE,
        REDSTONE_WIRE,
        OAK_WALL_SIGN,
        SPRUCE_WALL_SIGN,
        BIRCH_WALL_SIGN,
        ACACIA_WALL_SIGN,
        JUNGLE_WALL_SIGN,
        DARK_OAK_WALL_SIGN,
        REDSTONE_WALL_TORCH,
        SOUL_WALL_TORCH,
        NETHER_PORTAL,
        ATTACHED_PUMPKIN_STEM,
        ATTACHED_MELON_STEM,
        PUMPKIN_STEM,
        MELON_STEM,
        END_PORTAL,
        COCOA,
        TRIPWIRE,
        POTTED_OAK_SAPLING,
        POTTED_SPRUCE_SAPLING,
        POTTED_BIRCH_SAPLING,
        POTTED_JUNGLE_SAPLING,
        POTTED_ACACIA_SAPLING,
        POTTED_DARK_OAK_SAPLING,
        POTTED_FERN,
        POTTED_DANDELION,
        POTTED_POPPY,
        POTTED_BLUE_ORCHID,
        POTTED_ALLIUM,
        POTTED_AZURE_BLUET,
        POTTED_RED_TULIP,
        POTTED_ORANGE_TULIP,
        POTTED_WHITE_TULIP,
        POTTED_PINK_TULIP,
        POTTED_OXEYE_DAISY,
        POTTED_CORNFLOWER,
        POTTED_LILY_OF_THE_VALLEY,
        POTTED_WITHER_ROSE,
        POTTED_RED_MUSHROOM,
        POTTED_BROWN_MUSHROOM,
        POTTED_DEAD_BUSH,
        POTTED_CACTUS,
        CARROTS,
        POTATOES,
        SKELETON_WALL_SKULL,
        WITHER_SKELETON_WALL_SKULL,
        ZOMBIE_WALL_HEAD,
        PLAYER_WALL_HEAD,
        CREEPER_WALL_HEAD,
        DRAGON_WALL_HEAD,
        WHITE_WALL_BANNER,
        ORANGE_WALL_BANNER,
        MAGENTA_WALL_BANNER,
        LIGHT_BLUE_WALL_BANNER,
        YELLOW_WALL_BANNER,
        LIME_WALL_BANNER,
        PINK_WALL_BANNER,
        GRAY_WALL_BANNER,
        LIGHT_GRAY_WALL_BANNER,
        CYAN_WALL_BANNER,
        PURPLE_WALL_BANNER,
        BLUE_WALL_BANNER,
        BROWN_WALL_BANNER,
        GREEN_WALL_BANNER,
        RED_WALL_BANNER,
        BLACK_WALL_BANNER,
        BEETROOTS,
        END_GATEWAY,
        FROSTED_ICE,
        KELP_PLANT,
        DEAD_TUBE_CORAL_WALL_FAN,
        DEAD_BRAIN_CORAL_WALL_FAN,
        DEAD_BUBBLE_CORAL_WALL_FAN,
        DEAD_FIRE_CORAL_WALL_FAN,
        DEAD_HORN_CORAL_WALL_FAN,
        TUBE_CORAL_WALL_FAN,
        BRAIN_CORAL_WALL_FAN,
        BUBBLE_CORAL_WALL_FAN,
        FIRE_CORAL_WALL_FAN,
        HORN_CORAL_WALL_FAN,
        BAMBOO_SAPLING,
        POTTED_BAMBOO,
        VOID_AIR,
        CAVE_AIR,
        BUBBLE_COLUMN,
        SWEET_BERRY_BUSH,
        WEEPING_VINES_PLANT,
        TWISTING_VINES_PLANT,
        CRIMSON_WALL_SIGN,
        WARPED_WALL_SIGN,
        POTTED_CRIMSON_FUNGUS,
        POTTED_WARPED_FUNGUS,
        POTTED_CRIMSON_ROOTS,
        POTTED_WARPED_ROOTS,
        AMETHYST_BLOCK(MCVersion.MC1_17),
        AMETHYST_CLUSTER(MCVersion.MC1_17),
        AMETHYST_SHARD(MCVersion.MC1_17),
        BUDDING_AMETHYST(MCVersion.MC1_17),
        SMALL_AMETHYST_BUD(MCVersion.MC1_17),
        MEDIUM_AMETHYST_BUD(MCVersion.MC1_17),
        LARGE_AMETHYST_BUD(MCVersion.MC1_17),
        AXOLOTL_BUCKET(MCVersion.MC1_17),
        AXOLOTL_SPAWN_EGG(MCVersion.MC1_17),
        AZALEA(MCVersion.MC1_17),
        AZALEA_LEAVES(MCVersion.MC1_17),
        FLOWERING_AZALEA(MCVersion.MC1_17),
        FLOWERING_AZALEA_LEAVES(MCVersion.MC1_17),
        POTTED_AZALEA_BUSH(MCVersion.MC1_17),
        POTTED_FLOWERING_AZALEA_BUSH(MCVersion.MC1_17),
        BUNDLE(MCVersion.MC1_17),
        CANDLE(MCVersion.MC1_17),
        WHITE_CANDLE(MCVersion.MC1_17),
        ORANGE_CANDLE(MCVersion.MC1_17),
        MAGENTA_CANDLE(MCVersion.MC1_17),
        LIGHT_BLUE_CANDLE(MCVersion.MC1_17),
        YELLOW_CANDLE(MCVersion.MC1_17),
        LIME_CANDLE(MCVersion.MC1_17),
        PINK_CANDLE(MCVersion.MC1_17),
        GRAY_CANDLE(MCVersion.MC1_17),
        LIGHT_GRAY_CANDLE(MCVersion.MC1_17),
        CYAN_CANDLE(MCVersion.MC1_17),
        PURPLE_CANDLE(MCVersion.MC1_17),
        BLUE_CANDLE(MCVersion.MC1_17),
        BROWN_CANDLE(MCVersion.MC1_17),
        GREEN_CANDLE(MCVersion.MC1_17),
        RED_CANDLE(MCVersion.MC1_17),
        BLACK_CANDLE(MCVersion.MC1_17),
        CANDLE_CAKE(MCVersion.MC1_17),
        WHITE_CANDLE_CAKE(MCVersion.MC1_17),
        ORANGE_CANDLE_CAKE(MCVersion.MC1_17),
        MAGENTA_CANDLE_CAKE(MCVersion.MC1_17),
        LIGHT_BLUE_CANDLE_CAKE(MCVersion.MC1_17),
        YELLOW_CANDLE_CAKE(MCVersion.MC1_17),
        LIME_CANDLE_CAKE(MCVersion.MC1_17),
        PINK_CANDLE_CAKE(MCVersion.MC1_17),
        GRAY_CANDLE_CAKE(MCVersion.MC1_17),
        LIGHT_GRAY_CANDLE_CAKE(MCVersion.MC1_17),
        CYAN_CANDLE_CAKE(MCVersion.MC1_17),
        PURPLE_CANDLE_CAKE(MCVersion.MC1_17),
        BLUE_CANDLE_CAKE(MCVersion.MC1_17),
        BROWN_CANDLE_CAKE(MCVersion.MC1_17),
        GREEN_CANDLE_CAKE(MCVersion.MC1_17),
        RED_CANDLE_CAKE(MCVersion.MC1_17),
        BLACK_CANDLE_CAKE(MCVersion.MC1_17),
        CALCITE(MCVersion.MC1_17),
        CAVE_VINES(MCVersion.MC1_17),
        CAVE_VINES_PLANT(MCVersion.MC1_17),
        COPPER_BLOCK(MCVersion.MC1_17),
        COPPER_INGOT(MCVersion.MC1_17),
        COPPER_ORE(MCVersion.MC1_17),
        EXPOSED_COPPER(MCVersion.MC1_17),
        WEATHERED_COPPER(MCVersion.MC1_17),
        OXIDIZED_COPPER(MCVersion.MC1_17),
        CUT_COPPER(MCVersion.MC1_17),
        EXPOSED_CUT_COPPER(MCVersion.MC1_17),
        WEATHERED_CUT_COPPER(MCVersion.MC1_17),
        OXIDIZED_CUT_COPPER(MCVersion.MC1_17),
        CUT_COPPER_STAIRS(MCVersion.MC1_17),
        EXPOSED_CUT_COPPER_STAIRS(MCVersion.MC1_17),
        WEATHERED_CUT_COPPER_STAIRS(MCVersion.MC1_17),
        OXIDIZED_CUT_COPPER_STAIRS(MCVersion.MC1_17),
        CUT_COPPER_SLAB(MCVersion.MC1_17),
        EXPOSED_CUT_COPPER_SLAB(MCVersion.MC1_17),
        WEATHERED_CUT_COPPER_SLAB(MCVersion.MC1_17),
        OXIDIZED_CUT_COPPER_SLAB(MCVersion.MC1_17),
        RAW_COPPER(MCVersion.MC1_17),
        RAW_COPPER_BLOCK(MCVersion.MC1_17),
        WAXED_COPPER_BLOCK(MCVersion.MC1_17),
        WAXED_EXPOSED_COPPER(MCVersion.MC1_17),
        WAXED_WEATHERED_COPPER(MCVersion.MC1_17),
        WAXED_OXIDIZED_COPPER(MCVersion.MC1_17),
        WAXED_CUT_COPPER(MCVersion.MC1_17),
        WAXED_EXPOSED_CUT_COPPER(MCVersion.MC1_17),
        WAXED_WEATHERED_CUT_COPPER(MCVersion.MC1_17),
        WAXED_OXIDIZED_CUT_COPPER(MCVersion.MC1_17),
        WAXED_CUT_COPPER_STAIRS(MCVersion.MC1_17),
        WAXED_EXPOSED_CUT_COPPER_STAIRS(MCVersion.MC1_17),
        WAXED_WEATHERED_CUT_COPPER_STAIRS(MCVersion.MC1_17),
        WAXED_OXIDIZED_CUT_COPPER_STAIRS(MCVersion.MC1_17),
        WAXED_CUT_COPPER_SLAB(MCVersion.MC1_17),
        WAXED_EXPOSED_CUT_COPPER_SLAB(MCVersion.MC1_17),
        WAXED_WEATHERED_CUT_COPPER_SLAB(MCVersion.MC1_17),
        WAXED_OXIDIZED_CUT_COPPER_SLAB(MCVersion.MC1_17),
        CHISELED_DEEPSLATE(MCVersion.MC1_17),
        COBBLED_DEEPSLATE(MCVersion.MC1_17),
        COBBLED_DEEPSLATE_SLAB(MCVersion.MC1_17),
        COBBLED_DEEPSLATE_STAIRS(MCVersion.MC1_17),
        COBBLED_DEEPSLATE_WALL(MCVersion.MC1_17),
        CRACKED_DEEPSLATE_BRICKS(MCVersion.MC1_17),
        CRACKED_DEEPSLATE_TILES(MCVersion.MC1_17),
        DEEPSLATE(MCVersion.MC1_17),
        DEEPSLATE_BRICKS(MCVersion.MC1_17),
        DEEPSLATE_BRICK_SLAB(MCVersion.MC1_17),
        DEEPSLATE_BRICK_STAIRS(MCVersion.MC1_17),
        DEEPSLATE_BRICK_WALL(MCVersion.MC1_17),
        DEEPSLATE_COAL_ORE(MCVersion.MC1_17),
        DEEPSLATE_COPPER_ORE(MCVersion.MC1_17),
        DEEPSLATE_DIAMOND_ORE(MCVersion.MC1_17),
        DEEPSLATE_EMERALD_ORE(MCVersion.MC1_17),
        DEEPSLATE_GOLD_ORE(MCVersion.MC1_17),
        DEEPSLATE_IRON_ORE(MCVersion.MC1_17),
        DEEPSLATE_LAPIS_ORE(MCVersion.MC1_17),
        DEEPSLATE_REDSTONE_ORE(MCVersion.MC1_17),
        DEEPSLATE_TILES(MCVersion.MC1_17),
        DEEPSLATE_TILE_SLAB(MCVersion.MC1_17),
        DEEPSLATE_TILE_STAIRS(MCVersion.MC1_17),
        DEEPSLATE_TILE_WALL(MCVersion.MC1_17),
        INFESTED_DEEPSLATE(MCVersion.MC1_17),
        POLISHED_DEEPSLATE(MCVersion.MC1_17),
        POLISHED_DEEPSLATE_SLAB(MCVersion.MC1_17),
        POLISHED_DEEPSLATE_STAIRS(MCVersion.MC1_17),
        POLISHED_DEEPSLATE_WALL(MCVersion.MC1_17),
        BIG_DRIPLEAF(MCVersion.MC1_17),
        SMALL_DRIPLEAF(MCVersion.MC1_17),
        BIG_DRIPLEAF_STEM(MCVersion.MC1_17),
        DRIPSTONE_BLOCK(MCVersion.MC1_17),
        POINTED_DRIPSTONE(MCVersion.MC1_17),
        GLOW_BERRIES(MCVersion.MC1_17),
        GLOW_INK_SAC(MCVersion.MC1_17),
        GLOW_ITEM_FRAME(MCVersion.MC1_17),
        GLOW_LICHEN(MCVersion.MC1_17),
        GOAT_SPAWN_EGG(MCVersion.MC1_17),
        GLOW_SQUID_SPAWN_EGG(MCVersion.MC1_17),
        HANGING_ROOTS(MCVersion.MC1_17),
        LIGHT(MCVersion.MC1_17),
        LIGHTNING_ROD(MCVersion.MC1_17),
        MOSS_CARPET(MCVersion.MC1_17),
        MOSS_BLOCK(MCVersion.MC1_17),
        POWDER_SNOW(MCVersion.MC1_17),
        POWDER_SNOW_BUCKET(MCVersion.MC1_17),
        POWDER_SNOW_CAULDRON(MCVersion.MC1_17),
        RAW_GOLD(MCVersion.MC1_17),
        RAW_GOLD_BLOCK(MCVersion.MC1_17),
        RAW_IRON(MCVersion.MC1_17),
        RAW_IRON_BLOCK(MCVersion.MC1_17),
        ROOTED_DIRT(MCVersion.MC1_17),
        SCULK_SENSOR(MCVersion.MC1_17),
        SMOOTH_BASALT(MCVersion.MC1_17),
        SPORE_BLOSSOM(MCVersion.MC1_17),
        SPYGLASS(MCVersion.MC1_17),
        TINTED_GLASS(MCVersion.MC1_17),
        TUFF(MCVersion.MC1_17),
        GRASS_PATH(MCVersion.MC1_9, MCVersion.MC1_16_X),
        DIRT_PATH(MCVersion.MC1_17),
        WATER_CAULDRON(MCVersion.MC1_17),
        LAVA_CAULDRON(MCVersion.MC1_17),
        MUSIC_DISC_OTHERSIDE(MCVersion.MC1_18),
        ACACIA_CHEST_BOAT(MCVersion.MC1_19),
        BIRCH_CHEST_BOAT(MCVersion.MC1_19),
        DARK_OAK_CHEST_BOAT(MCVersion.MC1_19),
        JUNGLE_CHEST_BOAT(MCVersion.MC1_19),
        OAK_CHEST_BOAT(MCVersion.MC1_19),
        SPRUCE_CHEST_BOAT(MCVersion.MC1_19),
        REINFORCED_DEEPSLATE(MCVersion.MC1_19),
        DISC_FRAGMENT_5(MCVersion.MC1_19),
        ECHO_SHARD(MCVersion.MC1_19),
        OCHRE_FROGLIGHT(MCVersion.MC1_19),
        PEARLESCENT_FROGLIGHT(MCVersion.MC1_19),
        VERDANT_FROGLIGHT(MCVersion.MC1_19),
        FROGSPAWN(MCVersion.MC1_19),
        GOAT_HORN(MCVersion.MC1_19),
        MANGROVE_BOAT(MCVersion.MC1_19),
        MANGROVE_BUTTON(MCVersion.MC1_19),
        MANGROVE_CHEST_BOAT(MCVersion.MC1_19),
        MANGROVE_DOOR(MCVersion.MC1_19),
        MANGROVE_FENCE(MCVersion.MC1_19),
        MANGROVE_FENCE_GATE(MCVersion.MC1_19),
        MANGROVE_LEAVES(MCVersion.MC1_19),
        MANGROVE_LOG(MCVersion.MC1_19),
        MANGROVE_PLANKS(MCVersion.MC1_19),
        MANGROVE_PRESSURE_PLATE(MCVersion.MC1_19),
        MANGROVE_PROPAGULE(MCVersion.MC1_19),
        MANGROVE_ROOTS(MCVersion.MC1_19),
        MANGROVE_SLAB(MCVersion.MC1_19),
        MANGROVE_SIGN(MCVersion.MC1_19),
        MANGROVE_STAIRS(MCVersion.MC1_19),
        MANGROVE_TRAPDOOR(MCVersion.MC1_19),
        MANGROVE_WALL_SIGN(MCVersion.MC1_19),
        MANGROVE_WOOD(MCVersion.MC1_19),
        MUDDY_MANGROVE_ROOTS(MCVersion.MC1_19),
        POTTED_MANGROVE_PROPAGULE(MCVersion.MC1_19),
        STRIPPED_MANGROVE_LOG(MCVersion.MC1_19),
        STRIPPED_MANGROVE_WOOD(MCVersion.MC1_19),
        MUD(MCVersion.MC1_19),
        MUD_BRICK_SLAB(MCVersion.MC1_19),
        MUD_BRICK_STAIRS(MCVersion.MC1_19),
        MUD_BRICK_WALL(MCVersion.MC1_19),
        MUD_BRICKS(MCVersion.MC1_19),
        PACKED_MUD(MCVersion.MC1_19),
        MUSIC_DISC_5(MCVersion.MC1_19),
        RECOVERY_COMPASS(MCVersion.MC1_19),
        SCULK(MCVersion.MC1_19),
        SCULK_VEIN(MCVersion.MC1_19),
        SCULK_CATALYST(MCVersion.MC1_19),
        SCULK_SHRIEKER(MCVersion.MC1_19),
        ALLAY_SPAWN_EGG(MCVersion.MC1_19),
        FROG_SPAWN_EGG(MCVersion.MC1_19),
        TADPOLE_SPAWN_EGG(MCVersion.MC1_19),
        WARDEN_SPAWN_EGG(MCVersion.MC1_19),
        TADPOLE_BUCKET(MCVersion.MC1_19),
        ENDER_DRAGON_SPAWN_EGG(MCVersion.MC1_19_3),
        IRON_GOLEM_SPAWN_EGG(MCVersion.MC1_19_3),
        SNOW_GOLEM_SPAWN_EGG(MCVersion.MC1_19_3),
        WITHER_SPAWN_EGG(MCVersion.MC1_19_3),
        BAMBOO_BLOCK(MCVersion.MC1_19_3),
        BAMBOO_BUTTON(MCVersion.MC1_19_3),
        BAMBOO_DOOR(MCVersion.MC1_19_3),
        BAMBOO_FENCE(MCVersion.MC1_19_3),
        BAMBOO_FENCE_GATE(MCVersion.MC1_19_3),
        BAMBOO_MOSAIC(MCVersion.MC1_19_3),
        BAMBOO_PLANKS(MCVersion.MC1_19_3),
        BAMBOO_PRESSURE_PLATE(MCVersion.MC1_19_3),
        BAMBOO_RAFT(MCVersion.MC1_19_3),
        BAMBOO_CHEST_RAFT(MCVersion.MC1_19_3),
        BAMBOO_SIGN(MCVersion.MC1_19_3),
        BAMBOO_SLAB(MCVersion.MC1_19_3),
        BAMBOO_MOSAIC_SLAB(MCVersion.MC1_19_3),
        BAMBOO_STAIRS(MCVersion.MC1_19_3),
        BAMBOO_MOSAIC_STAIRS(MCVersion.MC1_19_3),
        BAMBOO_TRAPDOOR(MCVersion.MC1_19_3),
        STRIPPED_BAMBOO_BLOCK(MCVersion.MC1_19_3),
        CHISELED_BOOKSHELF(MCVersion.MC1_19_3),
        PIGLIN_HEAD(MCVersion.MC1_19_3),
        PIGLIN_WALL_HEAD(MCVersion.MC1_19_3),
        ACACIA_HANGING_SIGN(MCVersion.MC1_19_3),
        BAMBOO_HANGING_SIGN(MCVersion.MC1_19_3),
        BIRCH_HANGING_SIGN(MCVersion.MC1_19_3),
        CRIMSON_HANGING_SIGN(MCVersion.MC1_19_3),
        DARK_OAK_HANGING_SIGN(MCVersion.MC1_19_3),
        JUNGLE_HANGING_SIGN(MCVersion.MC1_19_3),
        MANGROVE_HANGING_SIGN(MCVersion.MC1_19_3),
        OAK_HANGING_SIGN(MCVersion.MC1_19_3),
        SPRUCE_HANGING_SIGN(MCVersion.MC1_19_3),
        WARPED_HANGING_SIGN(MCVersion.MC1_19_3),
        BAMBOO_WALL_SIGN(MCVersion.MC1_19_3),
        ACACIA_WALL_HANGING_SIGN(MCVersion.MC1_19_3),
        BAMBOO_WALL_HANGING_SIGN(MCVersion.MC1_19_3),
        BIRCH_WALL_HANGING_SIGN(MCVersion.MC1_19_3),
        CRIMSON_WALL_HANGING_SIGN(MCVersion.MC1_19_3),
        DARK_OAK_WALL_HANGING_SIGN(MCVersion.MC1_19_3),
        JUNGLE_WALL_HANGING_SIGN(MCVersion.MC1_19_3),
        MANGROVE_WALL_HANGING_SIGN(MCVersion.MC1_19_3),
        OAK_WALL_HANGING_SIGN(MCVersion.MC1_19_3),
        SPRUCE_WALL_HANGING_SIGN(MCVersion.MC1_19_3),
        WARPED_WALL_HANGING_SIGN(MCVersion.MC1_19_3),
        CAMEL_SPAWN_EGG(MCVersion.MC1_19_3),
        BRUSH(MCVersion.MC1_19_4),
        CHERRY_BOAT(MCVersion.MC1_19_4),
        CHERRY_BUTTON(MCVersion.MC1_19_4),
        CHERRY_CHEST_BOAT(MCVersion.MC1_19_4),
        CHERRY_DOOR(MCVersion.MC1_19_4),
        CHERRY_FENCE(MCVersion.MC1_19_4),
        CHERRY_FENCE_GATE(MCVersion.MC1_19_4),
        CHERRY_HANGING_SIGN(MCVersion.MC1_19_4),
        CHERRY_LEAVES(MCVersion.MC1_19_4),
        CHERRY_LOG(MCVersion.MC1_19_4),
        CHERRY_PLANKS(MCVersion.MC1_19_4),
        CHERRY_PRESSURE_PLATE(MCVersion.MC1_19_4),
        CHERRY_SAPLING(MCVersion.MC1_19_4),
        CHERRY_SIGN(MCVersion.MC1_19_4),
        CHERRY_SLAB(MCVersion.MC1_19_4),
        CHERRY_STAIRS(MCVersion.MC1_19_4),
        CHERRY_TRAPDOOR(MCVersion.MC1_19_4),
        CHERRY_WALL_HANGING_SIGN(MCVersion.MC1_19_4),
        CHERRY_WALL_SIGN(MCVersion.MC1_19_4),
        CHERRY_WOOD(MCVersion.MC1_19_4),
        STRIPPED_CHERRY_LOG(MCVersion.MC1_19_4),
        STRIPPED_CHERRY_WOOD(MCVersion.MC1_19_4),
        PINK_PETALS(MCVersion.MC1_19_4),
        DECORATED_POT(MCVersion.MC1_19_4),
        SNIFFER_SPAWN_EGG(MCVersion.MC1_19_4),
        SUSPICIOUS_SAND(MCVersion.MC1_19_4),
        TORCHFLOWER(MCVersion.MC1_19_4),
        TORCHFLOWER_CROP(MCVersion.MC1_19_4),
        TORCHFLOWER_SEEDS(MCVersion.MC1_19_4),
        POTTED_CHERRY_SAPLING(MCVersion.MC1_19_4),
        POTTED_TORCHFLOWER(MCVersion.MC1_19_4),
        COAST_ARMOR_TRIM_SMITHING_TEMPLATE(MCVersion.MC1_19_4),
        DUNE_ARMOR_TRIM_SMITHING_TEMPLATE(MCVersion.MC1_19_4),
        EYE_ARMOR_TRIM_SMITHING_TEMPLATE(MCVersion.MC1_19_4),
        NETHERITE_UPGRADE_SMITHING_TEMPLATE(MCVersion.MC1_19_4),
        RIB_ARMOR_TRIM_SMITHING_TEMPLATE(MCVersion.MC1_19_4),
        SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE(MCVersion.MC1_19_4),
        SNOUT_ARMOR_TRIM_SMITHING_TEMPLATE(MCVersion.MC1_19_4),
        SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE(MCVersion.MC1_19_4),
        TIDE_ARMOR_TRIM_SMITHING_TEMPLATE(MCVersion.MC1_19_4),
        VEX_ARMOR_TRIM_SMITHING_TEMPLATE(MCVersion.MC1_19_4),
        WARD_ARMOR_TRIM_SMITHING_TEMPLATE(MCVersion.MC1_19_4),
        WILD_ARMOR_TRIM_SMITHING_TEMPLATE(MCVersion.MC1_19_4),
        SUSPICIOUS_GRAVEL(MCVersion.MC1_20),
        PITCHER_PLANT(MCVersion.MC1_20),
        SNIFFER_EGG(MCVersion.MC1_20),
        CALIBRATED_SCULK_SENSOR(MCVersion.MC1_20),
        PITCHER_CROP(MCVersion.MC1_20),
        PITCHER_POD(MCVersion.MC1_20),
        MUSIC_DISC_RELIC(MCVersion.MC1_20),
        WAYFINDER_ARMOR_TRIM_SMITHING_TEMPLATE(MCVersion.MC1_20),
        SHAPER_ARMOR_TRIM_SMITHING_TEMPLATE(MCVersion.MC1_20),
        SILENCE_ARMOR_TRIM_SMITHING_TEMPLATE(MCVersion.MC1_20),
        RAISER_ARMOR_TRIM_SMITHING_TEMPLATE(MCVersion.MC1_20),
        HOST_ARMOR_TRIM_SMITHING_TEMPLATE(MCVersion.MC1_20),
        ANGLER_POTTERY_SHERD(MCVersion.MC1_20),
        ARCHER_POTTERY_SHERD(MCVersion.MC1_20),
        ARMS_UP_POTTERY_SHERD(MCVersion.MC1_20),
        BLADE_POTTERY_SHERD(MCVersion.MC1_20),
        BREWER_POTTERY_SHERD(MCVersion.MC1_20),
        BURN_POTTERY_SHERD(MCVersion.MC1_20),
        DANGER_POTTERY_SHERD(MCVersion.MC1_20),
        EXPLORER_POTTERY_SHERD(MCVersion.MC1_20),
        FRIEND_POTTERY_SHERD(MCVersion.MC1_20),
        HEART_POTTERY_SHERD(MCVersion.MC1_20),
        HEARTBREAK_POTTERY_SHERD(MCVersion.MC1_20),
        HOWL_POTTERY_SHERD(MCVersion.MC1_20),
        MINER_POTTERY_SHERD(MCVersion.MC1_20),
        MOURNER_POTTERY_SHERD(MCVersion.MC1_20),
        PLENTY_POTTERY_SHERD(MCVersion.MC1_20),
        PRIZE_POTTERY_SHERD(MCVersion.MC1_20),
        SHEAF_POTTERY_SHERD(MCVersion.MC1_20),
        SHELTER_POTTERY_SHERD(MCVersion.MC1_20),
        SKULL_POTTERY_SHERD(MCVersion.MC1_20),
        SNORT_POTTERY_SHERD(MCVersion.MC1_20),
        CRAFTER(MCVersion.MC1_20_4),
        CHISELED_COPPER(MCVersion.MC1_20_4),
        EXPOSED_CHISELED_COPPER(MCVersion.MC1_20_4),
        WEATHERED_CHISELED_COPPER(MCVersion.MC1_20_4),
        OXIDIZED_CHISELED_COPPER(MCVersion.MC1_20_4),
        WAXED_CHISELED_COPPER(MCVersion.MC1_20_4),
        WAXED_EXPOSED_CHISELED_COPPER(MCVersion.MC1_20_4),
        WAXED_WEATHERED_CHISELED_COPPER(MCVersion.MC1_20_4),
        WAXED_OXIDIZED_CHISELED_COPPER(MCVersion.MC1_20_4),
        COPPER_BULB(MCVersion.MC1_20_4),
        EXPOSED_COPPER_BULB(MCVersion.MC1_20_4),
        WEATHERED_COPPER_BULB(MCVersion.MC1_20_4),
        OXIDIZED_COPPER_BULB(MCVersion.MC1_20_4),
        WAXED_COPPER_BULB(MCVersion.MC1_20_4),
        WAXED_EXPOSED_COPPER_BULB(MCVersion.MC1_20_4),
        WAXED_WEATHERED_COPPER_BULB(MCVersion.MC1_20_4),
        WAXED_OXIDIZED_COPPER_BULB(MCVersion.MC1_20_4),
        COPPER_DOOR(MCVersion.MC1_20_4),
        EXPOSED_COPPER_DOOR(MCVersion.MC1_20_4),
        WEATHERED_COPPER_DOOR(MCVersion.MC1_20_4),
        OXIDIZED_COPPER_DOOR(MCVersion.MC1_20_4),
        WAXED_COPPER_DOOR(MCVersion.MC1_20_4),
        WAXED_EXPOSED_COPPER_DOOR(MCVersion.MC1_20_4),
        WAXED_WEATHERED_COPPER_DOOR(MCVersion.MC1_20_4),
        WAXED_OXIDIZED_COPPER_DOOR(MCVersion.MC1_20_4),
        COPPER_GRATE(MCVersion.MC1_20_4),
        EXPOSED_COPPER_GRATE(MCVersion.MC1_20_4),
        WEATHERED_COPPER_GRATE(MCVersion.MC1_20_4),
        OXIDIZED_COPPER_GRATE(MCVersion.MC1_20_4),
        WAXED_COPPER_GRATE(MCVersion.MC1_20_4),
        WAXED_EXPOSED_COPPER_GRATE(MCVersion.MC1_20_4),
        WAXED_WEATHERED_COPPER_GRATE(MCVersion.MC1_20_4),
        WAXED_OXIDIZED_COPPER_GRATE(MCVersion.MC1_20_4),
        COPPER_TRAPDOOR(MCVersion.MC1_20_4),
        EXPOSED_COPPER_TRAPDOOR(MCVersion.MC1_20_4),
        WEATHERED_COPPER_TRAPDOOR(MCVersion.MC1_20_4),
        OXIDIZED_COPPER_TRAPDOOR(MCVersion.MC1_20_4),
        WAXED_COPPER_TRAPDOOR(MCVersion.MC1_20_4),
        WAXED_EXPOSED_COPPER_TRAPDOOR(MCVersion.MC1_20_4),
        WAXED_WEATHERED_COPPER_TRAPDOOR(MCVersion.MC1_20_4),
        WAXED_OXIDIZED_COPPER_TRAPDOOR(MCVersion.MC1_20_4),
        BREEZE_SPAWN_EGG(MCVersion.MC1_20_4),
        TRIAL_SPAWNER(MCVersion.MC1_20_4),
        TRIAL_KEY(MCVersion.MC1_20_4),
        TUFF_BRICKS(MCVersion.MC1_20_4),
        TUFF_BRICK_SLAB(MCVersion.MC1_20_4),
        TUFF_BRICK_STAIRS(MCVersion.MC1_20_4),
        TUFF_BRICK_WALL(MCVersion.MC1_20_4),
        TUFF_SLAB(MCVersion.MC1_20_4),
        TUFF_STAIRS(MCVersion.MC1_20_4),
        TUFF_WALL(MCVersion.MC1_20_4),
        CHISELED_TUFF(MCVersion.MC1_20_4),
        POLISHED_TUFF(MCVersion.MC1_20_4),
        CHISELED_TUFF_BRICKS(MCVersion.MC1_20_4),
        POLISHED_TUFF_SLAB(MCVersion.MC1_20_4),
        POLISHED_TUFF_STAIRS(MCVersion.MC1_20_4),
        POLISHED_TUFF_WALL(MCVersion.MC1_20_4),
        ARMADILLO_SCUTE(MCVersion.MC1_20_6),
        ARMADILLO_SPAWN_EGG(MCVersion.MC1_20_6),
        WOLF_ARMOR(MCVersion.MC1_20_6),
        BREEZE_ROD(MCVersion.MC1_20_6),
        BOGGED_SPAWN_EGG(MCVersion.MC1_20_6),
        HEAVY_CORE(MCVersion.MC1_20_6),
        MACE(MCVersion.MC1_20_6),
        OMINOUS_BOTTLE(MCVersion.MC1_20_6),
        OMINOUS_TRIAL_KEY(MCVersion.MC1_20_6),
        FLOW_BANNER_PATTERN(MCVersion.MC1_20_6),
        GUSTER_BANNER_PATTERN(MCVersion.MC1_20_6),
        FLOW_ARMOR_TRIM_SMITHING_TEMPLATE(MCVersion.MC1_20_6),
        BOLT_ARMOR_TRIM_SMITHING_TEMPLATE(MCVersion.MC1_20_6),
        FLOW_POTTERY_SHERD(MCVersion.MC1_20_6),
        GUSTER_POTTERY_SHERD(MCVersion.MC1_20_6),
        SCRAPE_POTTERY_SHERD(MCVersion.MC1_20_6),
        VAULT(MCVersion.MC1_20_6),
        WIND_CHARGE(MCVersion.MC1_20_6);

        private final MCVersion since;
        private final MCVersion until;

        private MCVanillaMaterial() {
            this.since = MCVersion.MC1_0;
            this.until = MCVersion.FUTURE;
        }

        private MCVanillaMaterial(MCVersion since) {
            this.since = since;
            this.until = MCVersion.FUTURE;
        }

        private MCVanillaMaterial(MCVersion since, MCVersion until) {
            this.since = since;
            this.until = until;
        }

        public boolean existsIn(MCVersion version) {
            return version.gte(this.since) && version.lte(this.until);
        }
    }
}

