/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.enums.bukkit;

import com.laytonsmith.abstraction.enums.MCTrimPattern;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.Target;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.inventory.meta.trim.TrimPattern;

public class BukkitMCTrimPattern
extends MCTrimPattern<TrimPattern> {
    private static final Map<TrimPattern, MCTrimPattern> BUKKIT_MAP = new HashMap<TrimPattern, MCTrimPattern>();

    public BukkitMCTrimPattern(MCTrimPattern.MCVanillaTrimPattern vanillaTrimPattern, TrimPattern trimPattern) {
        super(vanillaTrimPattern, trimPattern);
    }

    @Override
    public String name() {
        if (this.getAbstracted() == MCTrimPattern.MCVanillaTrimPattern.UNKNOWN) {
            ((TrimPattern)this.getConcrete()).getKey().getKey().toUpperCase();
        }
        return ((MCTrimPattern.MCVanillaTrimPattern)((Object)this.getAbstracted())).name();
    }

    public static MCTrimPattern valueOfConcrete(TrimPattern test) {
        MCTrimPattern trimPattern = BUKKIT_MAP.get(test);
        if (trimPattern == null) {
            MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.GENERAL, "Bukkit Trim Pattern missing in BUKKIT_MAP: " + String.valueOf(test), Target.UNKNOWN);
            return new BukkitMCTrimPattern(MCTrimPattern.MCVanillaTrimPattern.UNKNOWN, test);
        }
        return trimPattern;
    }

    public static void build() {
        TrimPattern trimPattern;
        for (MCTrimPattern.MCVanillaTrimPattern mCVanillaTrimPattern : MCTrimPattern.MCVanillaTrimPattern.values()) {
            if (mCVanillaTrimPattern == MCTrimPattern.MCVanillaTrimPattern.UNKNOWN || !mCVanillaTrimPattern.existsIn(Static.getServer().getMinecraftVersion())) continue;
            try {
                trimPattern = BukkitMCTrimPattern.getBukkitType(mCVanillaTrimPattern);
            }
            catch (IllegalAccessException | NoSuchFieldException ex) {
                MSLog.GetLogger().w(MSLog.Tags.RUNTIME, "Could not find a Bukkit trim pattern type for " + mCVanillaTrimPattern.name(), Target.UNKNOWN);
                continue;
            }
            BukkitMCTrimPattern wrapper = new BukkitMCTrimPattern(mCVanillaTrimPattern, trimPattern);
            MAP.put(mCVanillaTrimPattern.name(), wrapper);
            BUKKIT_MAP.put(trimPattern, wrapper);
        }
        for (Field field : TrimPattern.class.getFields()) {
            try {
                trimPattern = (TrimPattern)field.get(null);
                if (BUKKIT_MAP.containsKey(trimPattern)) continue;
                MAP.put(field.getName(), new BukkitMCTrimPattern(MCTrimPattern.MCVanillaTrimPattern.UNKNOWN, trimPattern));
                BUKKIT_MAP.put(trimPattern, new BukkitMCTrimPattern(MCTrimPattern.MCVanillaTrimPattern.UNKNOWN, trimPattern));
            }
            catch (ClassCastException | IllegalAccessException exception) {
                // empty catch block
            }
        }
    }

    private static TrimPattern getBukkitType(MCTrimPattern.MCVanillaTrimPattern v) throws NoSuchFieldException, IllegalAccessException {
        return (TrimPattern)TrimPattern.class.getField(v.name()).get(null);
    }
}

