/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.telemetry;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.Preferences;
import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.core.Prefs;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.telemetry.TelemetryCategory;
import com.laytonsmith.core.telemetry.TelemetryValue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;

public class TelemetryPrefs {
    private static Preferences prefs;

    public static void init(File f) throws IOException {
        String header = StreamUtils.GetResource("prefs-header.txt");
        ArrayList<Preferences.Preference> a = new ArrayList<Preferences.Preference>();
        String def = Prefs.TelemetryCollectByDefault() != false ? "true" : "nag";
        Set<Class<?>> vs = ClassDiscovery.getDefaultInstance().loadClassesWithAnnotation(TelemetryCategory.class);
        for (Class<?> v : vs) {
            TelemetryCategory tc = v.getAnnotation(TelemetryCategory.class);
            String prefix = tc.type().getPrefix();
            a.add(new Preferences.Preference(prefix + "." + tc.name(), def, Preferences.Type.STRING, tc.purpose(), tc.group().getGroupData()));
        }
        prefs = new Preferences(Implementation.GetServerType().getBranding(), Static.getLogger(), a, header);
        prefs.init(f);
        boolean doNag = false;
        for (Class<?> v : vs) {
            TelemetryCategory tc = v.getAnnotation(TelemetryCategory.class);
            String p2 = prefs.getStringPreference(tc.type().getPrefix() + "." + tc.name());
            if (!"nag".equalsIgnoreCase(p2)) continue;
            doNag = true;
            break;
        }
        if (doNag) {
            StreamUtils.GetSystemOut().println("There is one or more new Telemetry Category defined in " + f.getAbsolutePath() + ". Please take a look at the file to opt in or out of the collection category.");
        }
    }

    public static boolean GetTelemetryLoggable(Class<? extends TelemetryValue> type) {
        TelemetryCategory tc = type.getAnnotation(TelemetryCategory.class);
        if (tc == null) {
            return false;
        }
        String name = tc.name();
        String prefix = tc.type().getPrefix();
        String p2 = prefs.getStringPreference(prefix + "." + name);
        if ("nag".equalsIgnoreCase(p2)) {
            return false;
        }
        return Objects.equals(Preferences.getBoolean(p2), Boolean.TRUE);
    }
}

