/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.postgresql.jdbc3;

import com.laytonsmith.libs.org.postgresql.core.BaseConnection;
import com.laytonsmith.libs.org.postgresql.util.GT;
import com.laytonsmith.libs.org.postgresql.util.PSQLException;
import com.laytonsmith.libs.org.postgresql.util.PSQLState;
import java.sql.SQLException;

public abstract class AbstractJdbc3ParameterMetaData {
    private final BaseConnection _connection;
    private final int[] _oids;

    public AbstractJdbc3ParameterMetaData(BaseConnection connection, int[] oids) {
        this._connection = connection;
        this._oids = oids;
    }

    public String getParameterClassName(int param) throws SQLException {
        this.checkParamIndex(param);
        return this._connection.getTypeInfo().getJavaClass(this._oids[param - 1]);
    }

    public int getParameterCount() {
        return this._oids.length;
    }

    public int getParameterMode(int param) throws SQLException {
        this.checkParamIndex(param);
        return 1;
    }

    public int getParameterType(int param) throws SQLException {
        this.checkParamIndex(param);
        return this._connection.getTypeInfo().getSQLType(this._oids[param - 1]);
    }

    public String getParameterTypeName(int param) throws SQLException {
        this.checkParamIndex(param);
        return this._connection.getTypeInfo().getPGType(this._oids[param - 1]);
    }

    public int getPrecision(int param) throws SQLException {
        this.checkParamIndex(param);
        return 0;
    }

    public int getScale(int param) throws SQLException {
        this.checkParamIndex(param);
        return 0;
    }

    public int isNullable(int param) throws SQLException {
        this.checkParamIndex(param);
        return 2;
    }

    public boolean isSigned(int param) throws SQLException {
        this.checkParamIndex(param);
        return this._connection.getTypeInfo().isSigned(this._oids[param - 1]);
    }

    private void checkParamIndex(int param) throws PSQLException {
        if (param < 1 || param > this._oids.length) {
            throw new PSQLException(GT.tr("The parameter index is out of range: {0}, number of parameters: {1}.", new Object[]{new Integer(param), new Integer(this._oids.length)}), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }
}

