/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.persistence.io;

import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.DaemonManager;
import com.laytonsmith.PureUtilities.ZipReader;
import com.laytonsmith.persistence.ReadOnlyException;
import com.laytonsmith.persistence.io.ConnectionMixin;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReadWriteFileConnection
implements ConnectionMixin {
    protected final File file;
    protected String encoding = "UTF-8";
    protected final ZipReader reader;
    protected final String blankDataModel;
    protected final ExecutorService service;

    public ReadWriteFileConnection(URI uri, File workingDirectory, String blankDataModel) throws IOException {
        String path = uri.getSchemeSpecificPart();
        if (!path.startsWith("//")) {
            throw new IOException("Could not read the URI: " + uri.toString() + ". Did you forget the \"//\"?");
        }
        File temp = new File(path = path.substring(2));
        this.file = temp.isAbsolute() ? temp : new File(workingDirectory, path);
        if (this.file.exists()) {
            this.encoding = FileUtil.getFileCharset(this.file);
        }
        this.reader = new ZipReader(this.file);
        if (!this.reader.isZipped() && this.reader.getTopLevelFile().getParentFile() != null) {
            this.reader.getTopLevelFile().getParentFile().mkdirs();
        }
        if (!this.reader.exists()) {
            this.reader.getTopLevelFile().createNewFile();
        }
        this.blankDataModel = blankDataModel;
        this.service = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "ReadWriteFileConnection-" + String.valueOf(ReadWriteFileConnection.this.file));
                t.setPriority(1);
                t.setDaemon(true);
                return t;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getData() throws IOException {
        Future<byte[]> future;
        if (this.reader.isZipped()) {
            return this.reader.getFileContents();
        }
        ExecutorService executorService = this.service;
        synchronized (executorService) {
            future = this.service.submit(new Callable<byte[]>(){

                @Override
                public byte[] call() throws Exception {
                    return StreamUtils.GetBytes(FileUtil.readAsStream(ReadWriteFileConnection.this.file));
                }
            });
        }
        try {
            return new String(future.get(), this.encoding);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof IOException) {
                throw (IOException)ex.getCause();
            }
            throw new RuntimeException(ex.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeData(final DaemonManager dm, final String data) throws ReadOnlyException, IOException, UnsupportedOperationException {
        if (this.reader.isZipped()) {
            throw new ReadOnlyException("Cannot write to a zipped file.");
        }
        if (this.file.getParentFile() != null) {
            this.file.getParentFile().mkdirs();
        }
        if (!this.file.exists()) {
            throw new FileNotFoundException(this.file.getAbsolutePath() + " does not exist!");
        }
        ExecutorService executorService = this.service;
        synchronized (executorService) {
            dm.activateThread(null);
            this.service.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileUtil.write(data, ReadWriteFileConnection.this.file);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(ReadWriteFileConnection.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    dm.deactivateThread(null);
                }
            });
        }
    }

    @Override
    public String getPath() throws UnsupportedOperationException, IOException {
        return this.file.getCanonicalPath();
    }
}

