/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.tools;

import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.TermColors;
import com.laytonsmith.PureUtilities.ZipMaker;
import com.laytonsmith.core.LocalPackages;
import com.laytonsmith.core.MethodScriptCompiler;
import com.laytonsmith.core.Profiles;
import com.laytonsmith.core.Script;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.persistence.DataSourceException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MSLPMaker {
    public static void start(String path, Set<Class<? extends Environment.EnvironmentImpl>> envs) throws IOException {
        File start = new File(path);
        if (!start.exists()) {
            StreamUtils.GetSystemErr().println("The specified file does not exist!");
            return;
        }
        File output = new File(start.getParentFile(), start.getName() + ".mslp");
        if (output.exists()) {
            TermColors.pl("The file " + output.getName() + " already exists, would you like to overwrite? (Y/N)");
            String overwrite = TermColors.prompt();
            if (!overwrite.equalsIgnoreCase("y")) {
                return;
            }
        }
        LocalPackages localPackages = new LocalPackages();
        localPackages.search(start);
        boolean error = false;
        for (LocalPackages.FileInfo fi : localPackages.getMSFiles()) {
            try {
                MethodScriptCompiler.compile(MethodScriptCompiler.lex(fi.contents(), null, fi.file(), true), null, envs);
            }
            catch (ConfigCompileException e) {
                error = true;
                ConfigRuntimeException.HandleUncaughtException(e, "Compile error in script. Compilation will attempt to continue, however.", null);
            }
            catch (ConfigCompileGroupException ex) {
                error = true;
                ConfigRuntimeException.HandleUncaughtException(ex, null);
            }
        }
        ArrayList<Script> allScripts = new ArrayList<Script>();
        for (LocalPackages.FileInfo fi : localPackages.getMSAFiles()) {
            try {
                Environment env;
                List<Script> tempScripts = MethodScriptCompiler.preprocess(MethodScriptCompiler.lex(fi.contents(), null, fi.file(), false), envs);
                try {
                    env = Static.GenerateStandaloneEnvironment();
                }
                catch (Profiles.InvalidProfileException | DataSourceException | IOException | URISyntaxException ex) {
                    throw new RuntimeException(ex);
                }
                for (Script s : tempScripts) {
                    try {
                        s.compile(env.clone());
                        s.checkAmbiguous(allScripts);
                        allScripts.add(s);
                    }
                    catch (ConfigCompileException e) {
                        error = true;
                        ConfigRuntimeException.HandleUncaughtException(e, "Compile error in script. Compilation will attempt to continue, however.", null);
                    }
                    catch (ConfigCompileGroupException e) {
                        error = true;
                        ConfigRuntimeException.HandleUncaughtException(e, "Compile errors in script. Compilation will attempt to continue, however.", null);
                    }
                    catch (CloneNotSupportedException e) {
                        throw new Error("Environment wasn't clonable, while it should be.", e);
                    }
                }
            }
            catch (ConfigCompileException e) {
                error = true;
                ConfigRuntimeException.HandleUncaughtException(e, "Could not compile file " + String.valueOf(fi.file()) + " compilation will halt.", null);
            }
        }
        if (!error) {
            ZipMaker.MakeZip(start, output.getName());
            TermColors.pl(TermColors.GREEN + "The MSLP file has been created at " + output.getAbsolutePath() + TermColors.reset());
        } else {
            TermColors.pl(TermColors.RED + "MSLP file has not been created due to compile errors. Correct the errors, and try again." + TermColors.reset());
        }
    }
}

