/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.ClassLoading.ClassMirror;

import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.ClassReferenceMirror;
import com.laytonsmith.PureUtilities.Common.ClassUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AnnotationMirror
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ClassReferenceMirror type;
    private final boolean visible;
    private final List<AnnotationValue> values;

    public AnnotationMirror(Annotation annotation) {
        this.type = ClassReferenceMirror.fromClass(annotation.annotationType());
        this.visible = true;
        this.values = new ArrayList<AnnotationValue>();
        for (Method m : annotation.annotationType().getDeclaredMethods()) {
            try {
                this.values.add(new AnnotationValue(m.getName(), m.invoke((Object)annotation, new Object[0])));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    AnnotationMirror(ClassReferenceMirror type, boolean visible) {
        this.type = type;
        this.visible = visible;
        this.values = new ArrayList<AnnotationValue>();
    }

    void addAnnotationValue(String name, Object value) {
        this.values.add(new AnnotationValue(name, value));
    }

    public Object getValue(String forName) {
        for (AnnotationValue value : this.values) {
            if (!value.name.equals(forName)) continue;
            return value.value;
        }
        return null;
    }

    public List<String> getDefinedValues() {
        ArrayList<String> list = new ArrayList<String>();
        for (AnnotationValue value : this.values) {
            list.add(value.name);
        }
        return list;
    }

    public Object getValueWithDefault(String forName) throws ClassNotFoundException {
        Object value = this.getValue(forName);
        if (value != null) {
            return value;
        }
        Class c = this.type.loadClass();
        try {
            Method m = c.getMethod(forName, new Class[0]);
            return m.getDefaultValue();
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (SecurityException ex) {
            throw new RuntimeException(ex);
        }
    }

    public List<String> getDefinedValuesWithDefault() throws ClassNotFoundException {
        ArrayList<String> ret = new ArrayList<String>();
        Class c = this.type.loadClass();
        for (Method m : c.getDeclaredMethods()) {
            ret.add(m.getName());
        }
        return ret;
    }

    public ClassReferenceMirror getType() {
        return this.type;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public <T extends Annotation> T getProxy(Class<T> type) throws IllegalArgumentException {
        if (!this.type.getJVMName().equals(ClassUtils.getJVMName(type))) {
            throw new IllegalArgumentException();
        }
        return (T)((Annotation)Proxy.newProxyInstance(AnnotationMirror.class.getClassLoader(), new Class[]{type}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
                if ("equals".equals(method.getName()) && AnnotationMirror.matches(args2, Object.class) || "hashCode".equals(method.getName()) && AnnotationMirror.matches(args2, new Class[0]) || "toString".equals(method.getName()) && AnnotationMirror.matches(args2, new Class[0]) || "wait".equals(method.getName()) && AnnotationMirror.matches(args2, new Class[0]) || "wait".equals(method.getName()) && AnnotationMirror.matches(args2, Long.TYPE) || "wait".equals(method.getName()) && AnnotationMirror.matches(args2, Long.TYPE, Integer.TYPE) || "getClass".equals(method.getName()) && AnnotationMirror.matches(args2, new Class[0]) || "notify".equals(method.getName()) && AnnotationMirror.matches(args2, new Class[0]) || "notifyAll".equals(method.getName()) && AnnotationMirror.matches(args2, new Class[0]) || "finalize".equals(method.getName()) && AnnotationMirror.matches(args2, new Class[0]) || "clone".equals(method.getName()) && AnnotationMirror.matches(args2, new Class[0])) {
                    throw new RuntimeException("The " + method.getName() + " method cannot be called on Annotation Proxies yet.");
                }
                return AnnotationMirror.this.getValueWithDefault(method.getName());
            }
        }));
    }

    private static boolean matches(Object[] args2, Class ... types) {
        if (args2 == null) {
            return types.length == 0;
        }
        if (args2.length != types.length) {
            return false;
        }
        for (int i = 0; i < args2.length; ++i) {
            if (types[i].isAssignableFrom(args2[i].getClass())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "@" + String.valueOf(this.type) + "(" + StringUtils.Join(this.values, ", ") + ")";
    }

    public int hashCode() {
        int hash2 = 7;
        hash2 = 37 * hash2 + Objects.hashCode(this.type);
        return hash2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationMirror other = (AnnotationMirror)obj;
        return Objects.equals(this.type, other.type);
    }

    private static class AnnotationValue
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String name;
        private Object value;

        public AnnotationValue(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            if (this.value instanceof String) {
                return this.name + " = " + StringUtils.toCodeString(this.value.toString());
            }
            return this.name + " = " + this.value.toString();
        }

        public int hashCode() {
            int hash2 = 7;
            hash2 = 29 * hash2 + Objects.hashCode(this.name);
            hash2 = 29 * hash2 + Objects.hashCode(this.value);
            return hash2;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AnnotationValue other = (AnnotationValue)obj;
            if (!Objects.equals(this.name, other.name)) {
                return false;
            }
            return Objects.equals(this.value, other.value);
        }
    }
}

