/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Proxy;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface NonInheritImplements {
    public Class<?> value();

    public Class[] parameterTypes() default {};

    public static class Helper {
        private Helper() {
        }

        public static <T> T Cast(Class<T> castType, Object o) throws ClassCastException {
            NonInheritImplements nii = o.getClass().getAnnotation(NonInheritImplements.class);
            if (castType.isAssignableFrom(o.getClass())) {
                return castType.cast(o);
            }
            if (nii != null) {
                Class<?> iface = nii.value();
                Object ifaceProxy = Proxy.newProxyInstance(o.getClass().getClassLoader(), new Class[]{iface}, (proxy, method, args2) -> o.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke(o, args2));
                return (T)ifaceProxy;
            }
            throw new ClassCastException("The object cannot be cast to " + castType.getName());
        }

        public static boolean Instanceof(Object o, Class<?> value) {
            return value.isAssignableFrom(o.getClass()) || o.getClass().getAnnotation(NonInheritImplements.class) != null;
        }
    }
}

