/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.enums.bukkit;

import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCCommandMinecart;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCEnderSignal;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCFishHook;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCHopperMinecart;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCItem;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCLightningStrike;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCLlama;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCPigZombie;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCSizedFireball;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCStorageMinecart;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCTNT;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCThrownPotion;
import com.laytonsmith.abstraction.enums.MCEntityType;
import com.laytonsmith.abstraction.enums.MCVersion;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.Target;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Projectile;

public class BukkitMCEntityType
extends MCEntityType<EntityType> {
    protected static final Map<EntityType, MCEntityType> BUKKIT_MAP = new HashMap<EntityType, MCEntityType>();

    public BukkitMCEntityType(EntityType concreteType, MCEntityType.MCVanillaEntityType abstractedType) {
        super(abstractedType, concreteType);
    }

    public static void build() {
        for (MCEntityType.MCVanillaEntityType mCVanillaEntityType : MCEntityType.MCVanillaEntityType.values()) {
            EntityType type;
            if (!mCVanillaEntityType.existsIn(Static.getServer().getMinecraftVersion())) continue;
            try {
                type = BukkitMCEntityType.getBukkitType(mCVanillaEntityType);
            }
            catch (IllegalArgumentException | NoSuchFieldError ex) {
                MSLog.GetLogger().w(MSLog.Tags.RUNTIME, "Could not find a Bukkit EntityType for " + mCVanillaEntityType.name(), Target.UNKNOWN);
                continue;
            }
            BukkitMCEntityType wrapper = new BukkitMCEntityType(type, mCVanillaEntityType);
            wrapper.setWrapperClass();
            VANILLA_MAP.put(mCVanillaEntityType, wrapper);
            MAP.put(mCVanillaEntityType.name(), wrapper);
            BUKKIT_MAP.put(type, wrapper);
        }
        for (MCEntityType.MCVanillaEntityType mCVanillaEntityType : EntityType.values()) {
            if (BUKKIT_MAP.containsKey((Object)mCVanillaEntityType)) continue;
            MAP.put(mCVanillaEntityType.name(), new BukkitMCEntityType((EntityType)mCVanillaEntityType, MCEntityType.MCVanillaEntityType.UNKNOWN));
            BUKKIT_MAP.put((EntityType)mCVanillaEntityType, new BukkitMCEntityType((EntityType)mCVanillaEntityType, MCEntityType.MCVanillaEntityType.UNKNOWN));
        }
    }

    @Override
    public String name() {
        return this.getAbstracted() == MCEntityType.MCVanillaEntityType.UNKNOWN ? ((EntityType)this.getConcrete()).name() : this.getAbstracted().name();
    }

    @Override
    public boolean isSpawnable() {
        if (this.getAbstracted() == MCEntityType.MCVanillaEntityType.UNKNOWN) {
            return this.getConcrete() != EntityType.UNKNOWN && ((EntityType)this.getConcrete()).isSpawnable();
        }
        return this.getAbstracted().isSpawnable() || ((EntityType)this.getConcrete()).isSpawnable();
    }

    @Override
    public boolean isProjectile() {
        return ((EntityType)this.getConcrete()).getEntityClass() != null && Projectile.class.isAssignableFrom(((EntityType)this.getConcrete()).getEntityClass());
    }

    public static BukkitMCEntityType valueOfConcrete(EntityType test) {
        MCEntityType type = BUKKIT_MAP.get(test);
        if (type != null) {
            return (BukkitMCEntityType)type;
        }
        MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.GENERAL, "Bukkit EntityType missing in BUKKIT_MAP: " + test.name(), Target.UNKNOWN);
        return new BukkitMCEntityType(test, MCEntityType.MCVanillaEntityType.UNKNOWN);
    }

    private static EntityType getBukkitType(MCEntityType.MCVanillaEntityType v) {
        if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_6)) {
            switch (v) {
                case ENDER_EYE: {
                    return EntityType.EYE_OF_ENDER;
                }
                case DROPPED_ITEM: {
                    return EntityType.ITEM;
                }
                case LEASH_HITCH: {
                    return EntityType.LEASH_KNOT;
                }
                case SPLASH_POTION: {
                    return EntityType.POTION;
                }
                case THROWN_EXP_BOTTLE: {
                    return EntityType.EXPERIENCE_BOTTLE;
                }
                case PRIMED_TNT: {
                    return EntityType.TNT;
                }
                case FIREWORK: {
                    return EntityType.FIREWORK_ROCKET;
                }
                case MINECART_COMMAND: {
                    return EntityType.COMMAND_BLOCK_MINECART;
                }
                case MINECART_CHEST: {
                    return EntityType.CHEST_MINECART;
                }
                case MINECART_FURNACE: {
                    return EntityType.FURNACE_MINECART;
                }
                case MINECART_TNT: {
                    return EntityType.TNT_MINECART;
                }
                case MINECART_HOPPER: {
                    return EntityType.HOPPER_MINECART;
                }
                case MUSHROOM_COW: {
                    return EntityType.MOOSHROOM;
                }
                case SNOWMAN: {
                    return EntityType.SNOW_GOLEM;
                }
                case ENDER_CRYSTAL: {
                    return EntityType.END_CRYSTAL;
                }
                case FISHING_HOOK: {
                    return EntityType.FISHING_BOBBER;
                }
                case LIGHTNING: {
                    return EntityType.LIGHTNING_BOLT;
                }
            }
        } else if (v == MCEntityType.MCVanillaEntityType.ENDER_EYE) {
            return EntityType.valueOf((String)"ENDER_SIGNAL");
        }
        return EntityType.valueOf((String)v.name());
    }

    public void setWrapperClass(Class<? extends MCEntity> clazz) {
        this.wrapperClass = clazz;
    }

    private void setWrapperClass() {
        switch (this.getAbstracted()) {
            case DROPPED_ITEM: {
                this.wrapperClass = BukkitMCItem.class;
                break;
            }
            case ENDER_EYE: {
                this.wrapperClass = BukkitMCEnderSignal.class;
                break;
            }
            case FIREBALL: {
                this.wrapperClass = BukkitMCSizedFireball.class;
                break;
            }
            case FISHING_HOOK: {
                this.wrapperClass = BukkitMCFishHook.class;
                break;
            }
            case LIGHTNING: {
                this.wrapperClass = BukkitMCLightningStrike.class;
                break;
            }
            case SPLASH_POTION: {
                this.wrapperClass = BukkitMCThrownPotion.class;
                break;
            }
            case MINECART_CHEST: {
                this.wrapperClass = BukkitMCStorageMinecart.class;
                break;
            }
            case MINECART_COMMAND: {
                this.wrapperClass = BukkitMCCommandMinecart.class;
                break;
            }
            case MINECART_HOPPER: {
                this.wrapperClass = BukkitMCHopperMinecart.class;
                break;
            }
            case PRIMED_TNT: {
                this.wrapperClass = BukkitMCTNT.class;
                break;
            }
            case TRADER_LLAMA: {
                this.wrapperClass = BukkitMCLlama.class;
                break;
            }
            case ZOMBIFIED_PIGLIN: {
                this.wrapperClass = BukkitMCPigZombie.class;
                break;
            }
            case UNKNOWN: {
                this.wrapperClass = null;
                break;
            }
            default: {
                String[] split2 = ((MCEntityType.MCVanillaEntityType)this.abstracted).name().toLowerCase().split("_");
                if (split2.length == 0 || "".equals(split2[0])) break;
                String name = "com.laytonsmith.abstraction.bukkit.entities.BukkitMC";
                for (String s : split2) {
                    name = name.concat(Character.toUpperCase(s.charAt(0)) + s.substring(1));
                }
                try {
                    this.wrapperClass = Class.forName(name);
                    break;
                }
                catch (ClassNotFoundException e) {
                    String url = "https://github.com/sk89q/CommandHelper/tree/master/src/main/java/com/laytonsmith/abstraction/bukkit/entities";
                    MSLog.GetLogger().d(MSLog.Tags.RUNTIME, "While trying to find the correct entity class for " + this.getAbstracted().name() + "(attempted " + name + "), we could not find a wrapper class. This is not necessarily an error, we just don't have any special handling for this entity yet, and will treat it generically. If there is a matching file at" + url + ", please alert the developers of this notice.", Target.UNKNOWN);
                }
            }
        }
    }
}

