/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.postgresql.largeobject;

import com.laytonsmith.libs.org.postgresql.fastpath.Fastpath;
import com.laytonsmith.libs.org.postgresql.fastpath.FastpathArg;
import com.laytonsmith.libs.org.postgresql.largeobject.BlobInputStream;
import com.laytonsmith.libs.org.postgresql.largeobject.BlobOutputStream;
import com.laytonsmith.libs.org.postgresql.util.PSQLException;
import com.laytonsmith.libs.org.postgresql.util.PSQLState;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;

public class LargeObject {
    public static final int SEEK_SET = 0;
    public static final int SEEK_CUR = 1;
    public static final int SEEK_END = 2;
    private final Fastpath fp;
    private final long oid;
    private final int mode;
    private final int fd;
    private BlobOutputStream os;
    private boolean closed = false;

    protected LargeObject(Fastpath fp, long oid, int mode2) throws SQLException {
        this.fp = fp;
        this.oid = oid;
        this.mode = mode2;
        FastpathArg[] args2 = new FastpathArg[]{Fastpath.createOIDArg(oid), new FastpathArg(mode2)};
        this.fd = fp.getInteger("lo_open", args2);
    }

    public LargeObject copy() throws SQLException {
        return new LargeObject(this.fp, this.oid, this.mode);
    }

    public int getOID() {
        return (int)this.oid;
    }

    public long getLongOID() {
        return this.oid;
    }

    public void close() throws SQLException {
        if (!this.closed) {
            if (this.os != null) {
                try {
                    this.os.flush();
                }
                catch (IOException ioe) {
                    throw new PSQLException("Exception flushing output stream", PSQLState.DATA_ERROR, (Throwable)ioe);
                }
                finally {
                    this.os = null;
                }
            }
            FastpathArg[] args2 = new FastpathArg[]{new FastpathArg(this.fd)};
            this.fp.fastpath("lo_close", false, args2);
            this.closed = true;
        }
    }

    public byte[] read(int len) throws SQLException {
        FastpathArg[] args2 = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(len)};
        return this.fp.getData("loread", args2);
    }

    public int read(byte[] buf, int off, int len) throws SQLException {
        byte[] b = this.read(len);
        if (b.length < len) {
            len = b.length;
        }
        System.arraycopy(b, 0, buf, off, len);
        return len;
    }

    public void write(byte[] buf) throws SQLException {
        FastpathArg[] args2 = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(buf)};
        this.fp.fastpath("lowrite", false, args2);
    }

    public void write(byte[] buf, int off, int len) throws SQLException {
        FastpathArg[] args2 = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(buf, off, len)};
        this.fp.fastpath("lowrite", false, args2);
    }

    public void seek(int pos, int ref) throws SQLException {
        FastpathArg[] args2 = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(pos), new FastpathArg(ref)};
        this.fp.fastpath("lo_lseek", false, args2);
    }

    public void seek(int pos) throws SQLException {
        this.seek(pos, 0);
    }

    public int tell() throws SQLException {
        FastpathArg[] args2 = new FastpathArg[]{new FastpathArg(this.fd)};
        return this.fp.getInteger("lo_tell", args2);
    }

    public int size() throws SQLException {
        int cp = this.tell();
        this.seek(0, 2);
        int sz = this.tell();
        this.seek(cp, 0);
        return sz;
    }

    public void truncate(int len) throws SQLException {
        FastpathArg[] args2 = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(len)};
        this.fp.getInteger("lo_truncate", args2);
    }

    public InputStream getInputStream() throws SQLException {
        return new BlobInputStream(this, 4096);
    }

    public OutputStream getOutputStream() throws SQLException {
        if (this.os == null) {
            this.os = new BlobOutputStream(this, 4096);
        }
        return this.os;
    }
}

