/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import com.laytonsmith.PureUtilities.Color;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TermColors {
    public static final SYS SYSTEM;
    @TermColor
    public static String RED;
    @TermColor
    public static String GREEN;
    @TermColor
    public static String BLUE;
    @TermColor
    public static String YELLOW;
    @TermColor
    public static String CYAN;
    @TermColor
    public static String MAGENTA;
    @TermColor
    public static String BLACK;
    @TermColor
    public static String WHITE;
    @TermColor
    public static String BRIGHT_RED;
    @TermColor
    public static String BRIGHT_GREEN;
    @TermColor
    public static String BRIGHT_BLUE;
    @TermColor
    public static String BRIGHT_YELLOW;
    @TermColor
    public static String BRIGHT_CYAN;
    @TermColor
    public static String BRIGHT_MAGENTA;
    @TermColor
    public static String BRIGHT_BLACK;
    @TermColor
    public static String BRIGHT_WHITE;
    @TermColor
    public static String BG_RED;
    @TermColor
    public static String BG_GREEN;
    @TermColor
    public static String BG_BLUE;
    @TermColor
    public static String BG_YELLOW;
    @TermColor
    public static String BG_CYAN;
    @TermColor
    public static String BG_MAGENTA;
    @TermColor
    public static String BG_BLACK;
    @TermColor
    public static String BG_WHITE;
    @TermColor
    public static String BG_BRIGHT_RED;
    @TermColor
    public static String BG_BRIGHT_GREEN;
    @TermColor
    public static String BG_BRIGHT_BLUE;
    @TermColor
    public static String BG_BRIGHT_YELLOW;
    @TermColor
    public static String BG_BRIGHT_CYAN;
    @TermColor
    public static String BG_BRIGHT_MAGENTA;
    @TermColor
    public static String BG_BRIGHT_BLACK;
    @TermColor
    public static String BG_BRIGHT_WHITE;
    @TermColor
    public static String BLINKON;
    @TermColor
    public static String BLINKOFF;
    @TermColor
    public static String BOLD;
    @TermColor
    public static String STRIKE;
    @TermColor
    public static String UNDERLINE;
    @TermColor
    public static String ITALIC;
    @TermColor
    public static String RESET;
    private static final Map<String, String> DEFAULTS;
    private static List<Field> fields;
    private static Scanner scanner;

    private TermColors() {
    }

    public static void cls() {
        if (SYSTEM.equals((Object)SYS.WINDOWS)) {
            for (int i = 0; i < 50; ++i) {
                StreamUtils.GetSystemOut().println();
            }
        } else {
            StreamUtils.GetSystemOut().print("\u001b[2J");
            StreamUtils.GetSystemOut().flush();
        }
    }

    private static List<Field> fields() {
        if (fields == null) {
            fields = new ArrayList<Field>();
            for (Field f : TermColors.class.getFields()) {
                if (f.getAnnotation(TermColor.class) == null) continue;
                fields.add(f);
                try {
                    DEFAULTS.put(f.getName(), (String)f.get(null));
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    Logger.getLogger(TermColors.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return fields;
    }

    public static void EnableColors() {
        for (Field f : TermColors.fields()) {
            try {
                f.set(null, DEFAULTS.get(f.getName()));
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                Logger.getLogger(TermColors.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void DisableColors() {
        for (Field f : TermColors.fields()) {
            try {
                f.set(null, "");
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                Logger.getLogger(TermColors.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static boolean ColorsDisabled() {
        return RED == null;
    }

    private static String special(String type) {
        switch (type) {
            case "blinkon": {
                return "\u001b[5m";
            }
            case "blinkoff": {
                return "\u001b[25m";
            }
            case "bold": {
                return "\u001b[1m";
            }
            case "strike": {
                return "\u001b[9m";
            }
            case "underline": {
                return "\u001b[4m";
            }
            case "italic": {
                return "\u001b[3m";
            }
            case "reset": {
                return "\u001b[m";
            }
        }
        return "";
    }

    public static String reset() {
        return RESET;
    }

    public static String color(Color c) {
        return TermColors.color(c, false, true, true);
    }

    private static String color(Color c, boolean bright, boolean foreground, boolean resetCurrent) {
        int color2 = 37;
        if (c.equals(Color.RED)) {
            color2 = 31;
        } else if (c.equals(Color.GREEN)) {
            color2 = 32;
        } else if (c.equals(Color.BLUE)) {
            color2 = 34;
        } else if (c.equals(Color.YELLOW)) {
            color2 = 33;
        } else if (c.equals(Color.CYAN)) {
            color2 = 36;
        } else if (c.equals(Color.MAGENTA)) {
            color2 = 35;
        } else if (c.equals(Color.BLACK)) {
            color2 = 30;
        } else if (c.equals(Color.WHITE)) {
            color2 = 37;
        }
        if (!foreground) {
            color2 += 10;
        }
        return "\u001b[" + (resetCurrent ? "0;" : "") + color2 + ";" + (bright ? "1" : "22") + "m";
    }

    public static void p(CharSequence c) {
        StreamUtils.GetSystemOut().print(c);
        StreamUtils.GetSystemOut().flush();
    }

    public static String prompt() {
        if (scanner == null) {
            scanner = new Scanner(System.in);
        }
        TermColors.p(">" + MAGENTA);
        StreamUtils.GetSystemOut().flush();
        String ret = scanner.nextLine();
        TermColors.p(WHITE);
        return ret;
    }

    public static void pl(CharSequence c) {
        StreamUtils.GetSystemOut().println(String.valueOf(c) + WHITE);
    }

    public static void pl() {
        TermColors.pl("");
    }

    static {
        String os = System.getProperty("os.name");
        SYSTEM = os.contains("Windows") ? SYS.WINDOWS : SYS.UNIX;
        RED = TermColors.color(Color.RED);
        GREEN = TermColors.color(Color.GREEN);
        BLUE = TermColors.color(Color.BLUE);
        YELLOW = TermColors.color(Color.YELLOW);
        CYAN = TermColors.color(Color.CYAN);
        MAGENTA = TermColors.color(Color.MAGENTA);
        BLACK = TermColors.color(Color.BLACK);
        WHITE = TermColors.color(Color.WHITE);
        BRIGHT_RED = TermColors.color(Color.RED, true, true, true);
        BRIGHT_GREEN = TermColors.color(Color.GREEN, true, true, true);
        BRIGHT_BLUE = TermColors.color(Color.BLUE, true, true, true);
        BRIGHT_YELLOW = TermColors.color(Color.YELLOW, true, true, true);
        BRIGHT_CYAN = TermColors.color(Color.CYAN, true, true, true);
        BRIGHT_MAGENTA = TermColors.color(Color.MAGENTA, true, true, true);
        BRIGHT_BLACK = TermColors.color(Color.BLACK, true, true, true);
        BRIGHT_WHITE = TermColors.color(Color.WHITE, true, true, true);
        BG_RED = TermColors.color(Color.RED, false, false, false);
        BG_GREEN = TermColors.color(Color.GREEN, false, false, false);
        BG_BLUE = TermColors.color(Color.BLUE, false, false, false);
        BG_YELLOW = TermColors.color(Color.YELLOW, false, false, false);
        BG_CYAN = TermColors.color(Color.CYAN, false, false, false);
        BG_MAGENTA = TermColors.color(Color.MAGENTA, false, false, false);
        BG_BLACK = TermColors.color(Color.BLACK, false, false, false);
        BG_WHITE = TermColors.color(Color.WHITE, false, false, false);
        BG_BRIGHT_RED = TermColors.color(Color.RED, true, false, false);
        BG_BRIGHT_GREEN = TermColors.color(Color.GREEN, true, false, false);
        BG_BRIGHT_BLUE = TermColors.color(Color.BLUE, true, false, false);
        BG_BRIGHT_YELLOW = TermColors.color(Color.YELLOW, true, false, false);
        BG_BRIGHT_CYAN = TermColors.color(Color.CYAN, true, false, false);
        BG_BRIGHT_MAGENTA = TermColors.color(Color.MAGENTA, true, false, false);
        BG_BRIGHT_BLACK = TermColors.color(Color.BLACK, true, false, false);
        BG_BRIGHT_WHITE = TermColors.color(Color.WHITE, true, false, false);
        BLINKON = TermColors.special("blinkon");
        BLINKOFF = TermColors.special("blinkoff");
        BOLD = TermColors.special("bold");
        STRIKE = TermColors.special("strike");
        UNDERLINE = TermColors.special("underline");
        ITALIC = TermColors.special("italic");
        RESET = TermColors.special("reset");
        DEFAULTS = new HashMap<String, String>();
        fields = null;
        if (SYSTEM == SYS.WINDOWS) {
            TermColors.DisableColors();
        } else {
            TermColors.EnableColors();
        }
    }

    public static enum SYS {
        WINDOWS,
        UNIX;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    private static @interface TermColor {
    }
}

