/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import com.laytonsmith.PureUtilities.ArgumentParser;
import com.laytonsmith.PureUtilities.ExecutionQueue;
import com.laytonsmith.PureUtilities.ExecutionQueueImpl;
import com.laytonsmith.PureUtilities.SmartComment;
import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.abstraction.MCBlockCommandSender;
import com.laytonsmith.abstraction.MCCommand;
import com.laytonsmith.abstraction.MCCommandMap;
import com.laytonsmith.abstraction.MCCommandSender;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.StaticLayer;
import com.laytonsmith.abstraction.entities.MCCommandMinecart;
import com.laytonsmith.abstraction.enums.MCChatColor;
import com.laytonsmith.core.FullyQualifiedClassName;
import com.laytonsmith.core.Globals;
import com.laytonsmith.core.LocalPackages;
import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.MethodScriptFileLocations;
import com.laytonsmith.core.Prefs;
import com.laytonsmith.core.Procedure;
import com.laytonsmith.core.Profiles;
import com.laytonsmith.core.ProfilesImpl;
import com.laytonsmith.core.Script;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.Updater;
import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.compiler.CompilerWarning;
import com.laytonsmith.core.compiler.FileOptions;
import com.laytonsmith.core.compiler.analysis.StaticAnalysis;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CClosure;
import com.laytonsmith.core.constructs.CNativeClosure;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Command;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.NativeTypeList;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.constructs.Variable;
import com.laytonsmith.core.environments.CommandHelperEnvironment;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.environments.RuntimeMode;
import com.laytonsmith.core.environments.StaticRuntimeEnv;
import com.laytonsmith.core.events.EventUtils;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CancelCommandException;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.extensions.ExtensionManager;
import com.laytonsmith.core.functions.Commands;
import com.laytonsmith.core.functions.IncludeCache;
import com.laytonsmith.core.functions.Scheduling;
import com.laytonsmith.core.natives.interfaces.MEnumType;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.profiler.ProfilePoint;
import com.laytonsmith.core.profiler.Profiler;
import com.laytonsmith.core.taskmanager.TaskManagerImpl;
import com.laytonsmith.persistence.DataSourceException;
import com.laytonsmith.persistence.DataSourceFactory;
import com.laytonsmith.persistence.PersistenceNetwork;
import com.laytonsmith.persistence.PersistenceNetworkImpl;
import com.laytonsmith.persistence.io.ConnectionMixinFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;

public class AliasCore {
    private final MethodScriptFileLocations fileLocations;
    private final Set<String> echoCommand = new HashSet<String>();
    private CompilerEnvironment compilerEnv;
    private StaticRuntimeEnv staticRuntimeEnv;
    private List<Script> scripts;
    private boolean lastCompileFailed = false;
    private static final CompletionValues NONE = (alias, player2, args) -> new ArrayList();

    public AliasCore(MethodScriptFileLocations fileLocations) {
        this.fileLocations = fileLocations;
        if (Prefs.CheckForUpdates().booleanValue()) {
            new Thread(() -> {
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Boolean updateAvailable = Updater.isUpdateAvailable();
                if (updateAvailable != null && updateAvailable.booleanValue()) {
                    MSLog.GetLogger().always((MSLog.Tag)MSLog.Tags.GENERAL, "An update is available!", Target.UNKNOWN);
                }
            }, Implementation.GetServerType().getBranding() + "-update-check").start();
        }
    }

    public List<Script> getScripts() {
        return this.scripts;
    }

    public StaticRuntimeEnv getStaticRuntimeEnv() {
        return this.staticRuntimeEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean alias(String command, MCCommandSender sender) {
        if (this.scripts == null) {
            String msg2 = this.lastCompileFailed ? "CommandHelper failed to start correctly due to a script compilation error. Check server startup logs for more details. Enable halt-on-failure in preferences to automatically shutdown the server when this happens on startup." : "CommandHelper failed to start correctly. Check server startup logs for more details.";
            if (sender instanceof MCPlayer) {
                sender.sendMessage(String.valueOf((Object)MCChatColor.RED) + msg2);
            } else if (sender instanceof MCBlockCommandSender || sender instanceof MCCommandMinecart) {
                return false;
            }
            throw ConfigRuntimeException.CreateUncatchableException(msg2, Target.UNKNOWN);
        }
        if (sender instanceof MCPlayer && this.echoCommand.contains(sender.getName())) {
            return false;
        }
        Script script = null;
        for (Script s : this.scripts) {
            if (!s.match(command)) continue;
            script = s;
            break;
        }
        if (script == null) {
            return false;
        }
        if (Prefs.ConsoleLogCommands().booleanValue() && script.doLog()) {
            Static.getLogger().log(Level.INFO, "Running alias on " + sender.getName() + " ---> " + command);
        }
        GlobalEnv gEnv = new GlobalEnv(this.fileLocations.getConfigDirectory(), EnumSet.of(RuntimeMode.EMBEDDED));
        CommandHelperEnvironment cEnv = new CommandHelperEnvironment();
        cEnv.SetCommandSender(sender);
        cEnv.SetCommand(command);
        Environment env = Environment.createEnvironment(gEnv, this.staticRuntimeEnv, cEnv, this.compilerEnv);
        this.addPlayerReference(sender);
        ProfilePoint alias = env.getEnv(StaticRuntimeEnv.class).GetProfiler().start("Alias - \"" + command + "\"", LogLevel.ERROR);
        try {
            script.run(script.getVariables(command), env, output -> {
                if (output == null) {
                    return;
                }
                if ((output = output.trim()).startsWith("/")) {
                    if (Prefs.DebugMode().booleanValue()) {
                        Static.getLogger().log(Level.INFO, "Executing command on " + sender.getName() + ": " + output);
                    }
                    if (sender instanceof MCPlayer) {
                        ((MCPlayer)sender).chat(output);
                    } else {
                        Static.getServer().dispatchCommand(sender, output.substring(1));
                    }
                }
            });
        }
        catch (ConfigRuntimeException ex) {
            ex.setEnv(env);
            ConfigRuntimeException.HandleUncaughtException(ex, env);
        }
        finally {
            alias.stop();
            this.removePlayerReference(sender);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reload(MCPlayer player2, String[] settings, boolean firstLoad) {
        StaticAnalysis autoIncludeAnalysis;
        ExecutionQueue executionQueue;
        IncludeCache includeCache;
        PersistenceNetwork persistenceNetwork;
        ProfilesImpl profiles;
        Profiler profiler;
        ReloadOptions options;
        try {
            options = new ReloadOptions(settings);
        }
        catch (Exception ex) {
            if (player2 != null) {
                player2.sendMessage(ex.getMessage());
            } else {
                Static.getLogger().log(Level.SEVERE, ex.getMessage());
            }
            return;
        }
        if (!firstLoad) {
            try {
                Prefs.init(this.fileLocations.getPreferencesFile());
            }
            catch (IOException ex) {
                Static.getLogger().log(Level.SEVERE, "Failed to reload preferences.", ex);
                return;
            }
        } else if (Prefs.AllowDynamicShell().booleanValue()) {
            MSLog.GetLogger().Log((MSLog.Tag)MSLog.Tags.GENERAL, LogLevel.WARNING, "allow-dynamic-shell is set to true in " + this.fileLocations.getPreferencesFile().getName() + " you should set this to false, except during development.", Target.UNKNOWN);
        }
        MSLog.initialize(this.fileLocations.getConfigDirectory());
        if (options.reloadProfiler()) {
            try {
                profiler = new Profiler(this.fileLocations.getProfilerConfigFile());
            }
            catch (IOException ex) {
                Static.getLogger().log(Level.SEVERE, "Failed to create Profiler from config file.", ex);
                if (Prefs.HaltOnFailure().booleanValue() && firstLoad) {
                    Static.getLogger().log(Level.SEVERE, "Shutting down server (halt-on-failure)");
                    Static.getServer().shutdown();
                }
                return;
            }
        } else {
            profiler = this.staticRuntimeEnv.GetProfiler();
        }
        ProfilePoint extensionPreReload = profiler.start("Extension PreReloadAliases call", LogLevel.VERBOSE);
        try {
            ExtensionManager.PreReloadAliases(options);
        }
        finally {
            extensionPreReload.stop();
        }
        try {
            profiles = new ProfilesImpl(this.fileLocations.getProfilesFile());
        }
        catch (Profiles.InvalidProfileException | IOException ex) {
            MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.GENERAL, ex.getMessage(), Target.UNKNOWN);
            if (Prefs.HaltOnFailure().booleanValue() && firstLoad) {
                Static.getLogger().log(Level.SEVERE, "Shutting down server (halt-on-failure)");
                Static.getServer().shutdown();
            }
            return;
        }
        if (options.reloadPersistenceConfig()) {
            ProfilePoint persistenceConfigReload = profiler.start("Reloading persistence configuration", LogLevel.VERBOSE);
            try {
                DataSourceFactory.DisconnectAll();
                ConnectionMixinFactory.ConnectionMixinOptions opts = new ConnectionMixinFactory.ConnectionMixinOptions();
                opts.setWorkingDirectory(this.fileLocations.getConfigDirectory());
                persistenceNetwork = new PersistenceNetworkImpl(this.fileLocations.getPersistenceConfig(), new URI("sqlite://" + this.fileLocations.getDefaultPersistenceDBFile().getCanonicalFile().toURI().getRawSchemeSpecificPart().replace('\\', '/')), opts);
            }
            catch (DataSourceException | IOException | URISyntaxException ex) {
                Static.getLogger().log(Level.SEVERE, null, ex);
                if (Prefs.HaltOnFailure().booleanValue() && firstLoad) {
                    Static.getLogger().log(Level.SEVERE, "Shutting down server (halt-on-failure)");
                    Static.getServer().shutdown();
                }
                return;
            }
            finally {
                persistenceConfigReload.stop();
            }
        } else {
            persistenceNetwork = this.staticRuntimeEnv.GetPersistenceNetwork();
        }
        if (options.reloadScripts()) {
            includeCache = new IncludeCache();
            executionQueue = new ExecutionQueueImpl("MethodScriptExecutionQueue", "default");
            autoIncludeAnalysis = new StaticAnalysis(true);
        } else {
            includeCache = this.staticRuntimeEnv.getIncludeCache();
            executionQueue = this.staticRuntimeEnv.getExecutionQueue();
            autoIncludeAnalysis = this.staticRuntimeEnv.getAutoIncludeAnalysis();
        }
        StaticRuntimeEnv oldStaticRuntimeEnv = this.staticRuntimeEnv;
        StaticRuntimeEnv newStaticRuntimeEnv = new StaticRuntimeEnv(profiler, persistenceNetwork, profiles, new TaskManagerImpl(), executionQueue, includeCache, autoIncludeAnalysis);
        Environment env = null;
        LocalPackages localPackages = new LocalPackages();
        if (options.reloadScripts()) {
            List<Script> newScripts;
            File mainFile;
            GlobalEnv globalEnv = new GlobalEnv(this.fileLocations.getConfigDirectory(), EnumSet.of(RuntimeMode.EMBEDDED));
            CommandHelperEnvironment commandHelperEnv = new CommandHelperEnvironment();
            CompilerEnvironment compilerEnv = new CompilerEnvironment();
            env = Environment.createEnvironment(globalEnv, newStaticRuntimeEnv, commandHelperEnv, compilerEnv);
            File aliasConfig = new File(this.fileLocations.getConfigDirectory(), Prefs.ScriptName());
            if (!aliasConfig.exists()) {
                try {
                    aliasConfig.getParentFile().mkdirs();
                    aliasConfig.createNewFile();
                    String sampAliases = AliasCore.getStringResource(AliasCore.class.getResourceAsStream("/samp_aliases.txt"));
                    sampAliases = sampAliases.replaceAll("\n|\r\n", System.getProperty("line.separator"));
                    AliasCore.file_put_contents(aliasConfig, sampAliases, "o");
                }
                catch (Exception e) {
                    Static.getLogger().log(Level.WARNING, "Could not write sample aliases file");
                }
            }
            if (!(mainFile = new File(this.fileLocations.getConfigDirectory(), Prefs.MainFile())).exists()) {
                try {
                    mainFile.getParentFile().mkdirs();
                    mainFile.createNewFile();
                    String sampMain = AliasCore.getStringResource(AliasCore.class.getResourceAsStream("/samp_main.txt"));
                    sampMain = sampMain.replaceAll("\n|\r\n", System.getProperty("line.separator"));
                    AliasCore.file_put_contents(mainFile, sampMain, "o");
                }
                catch (Exception e) {
                    Static.getLogger().log(Level.WARNING, "Could not write sample main file");
                }
            }
            try {
                String main = AliasCore.file_get_contents(mainFile.getAbsolutePath());
                localPackages.appendMS(main, mainFile);
            }
            catch (IOException e) {
                Static.getLogger().log(Level.WARNING, "Could not read main file");
            }
            try {
                String aliasConfigStr = AliasCore.file_get_contents(aliasConfig.getAbsolutePath());
                localPackages.appendMSA(aliasConfigStr, aliasConfig);
            }
            catch (IOException e) {
                Static.getLogger().log(Level.WARNING, "Could not read aliases file");
            }
            File autoInclude = new File(env.getEnv(GlobalEnv.class).GetRootFolder(), "auto_include.ms");
            if (autoInclude.exists()) {
                localPackages.addAutoInclude(autoInclude);
            }
            localPackages.search(this.fileLocations.getLocalPackagesDirectory());
            includeCache.addAutoIncludes(localPackages.getAutoIncludes());
            ProfilePoint compilerMS = profiler.start("Compilation of MS files in Local Packages", LogLevel.VERBOSE);
            try {
                localPackages.compileMS(player2, env);
            }
            finally {
                compilerMS.stop();
            }
            ProfilePoint compilerMSA = profiler.start("Compilation of MSA files in Local Packages", LogLevel.VERBOSE);
            try {
                newScripts = localPackages.compileMSA(player2, env, env.getEnvClasses());
                for (int i = 0; i < newScripts.size(); ++i) {
                    Script s1 = newScripts.get(i);
                    if (s1.getSmartComment().getAnnotations("@command").isEmpty()) continue;
                    for (int j = i + 1; j < newScripts.size(); ++j) {
                        Script s2 = newScripts.get(j);
                        if (s2.getSmartComment().getAnnotations("@command").isEmpty() || !s1.getCommandName().equalsIgnoreCase(s2.getCommandName())) continue;
                        ConfigRuntimeException.HandleUncaughtException(new ConfigCompileException("Duplicate command defined. (First occurrence found at " + String.valueOf(s1.getTarget()) + ")", s2.getTarget()), "Duplicate command.", player2);
                    }
                }
            }
            finally {
                compilerMSA.stop();
            }
            if (localPackages.hasCompileErrors()) {
                Static.getLogger().log(Level.SEVERE, "Execution halted due to compile errors.");
                if (player2 != null) {
                    player2.sendMessage(String.valueOf((Object)MCChatColor.RED) + "[CommandHelper] Execution halted due to compile errors.");
                }
                this.lastCompileFailed = true;
                if (Prefs.HaltOnFailure().booleanValue() && firstLoad) {
                    Static.getLogger().log(Level.SEVERE, "Shutting down server (halt-on-failure)");
                    Static.getServer().shutdown();
                }
                return;
            }
            MSLog.GetLogger().Log((MSLog.Tag)MSLog.Tags.GENERAL, LogLevel.VERBOSE, "Compilation completed", Target.UNKNOWN);
            ProfilePoint shutdownHooks = profiler.start("Shutdown hooks call", LogLevel.VERBOSE);
            try {
                StaticLayer.GetConvertor().runShutdownHooks();
            }
            finally {
                shutdownHooks.stop();
            }
            ProfilePoint unregisteringEvents = profiler.start("Unregistering events", LogLevel.VERBOSE);
            try {
                EventUtils.UnregisterAll();
            }
            finally {
                unregisteringEvents.stop();
            }
            ProfilePoint runningExtensionHooks = profiler.start("Running event hooks", LogLevel.VERBOSE);
            try {
                ExtensionManager.RunHooks();
            }
            finally {
                runningExtensionHooks.stop();
            }
            Static.getServer().getMessenger().closeAllChannels();
            this.scripts = newScripts;
            this.compilerEnv = compilerEnv;
            this.staticRuntimeEnv = newStaticRuntimeEnv;
        } else {
            this.staticRuntimeEnv = newStaticRuntimeEnv;
        }
        if (!firstLoad) {
            if (options.reloadExecutionQueue() && oldStaticRuntimeEnv != null) {
                ProfilePoint stoppingExecutionQueue = profiler.start("Stopping execution queues", LogLevel.VERBOSE);
                try {
                    oldStaticRuntimeEnv.getExecutionQueue().stopAllNow();
                }
                finally {
                    stoppingExecutionQueue.stop();
                }
            }
            if (options.reloadTimeouts()) {
                ProfilePoint clearingTimeouts = profiler.start("Clearing timeouts/intervals", LogLevel.VERBOSE);
                try {
                    Scheduling.ClearScheduledRunners();
                }
                finally {
                    clearingTimeouts.stop();
                }
            }
            if (options.reloadGlobals()) {
                ProfilePoint clearingGlobals = profiler.start("Clearing globals", LogLevel.VERBOSE);
                try {
                    Globals.clear();
                }
                finally {
                    clearingGlobals.stop();
                }
            }
            if (options.reloadExtensions()) {
                ProfilePoint extManagerShutdown = profiler.start("Extension manager shutdown", LogLevel.VERBOSE);
                try {
                    ExtensionManager.Shutdown();
                }
                finally {
                    extManagerShutdown.stop();
                }
            }
        }
        if (options.reloadExtensions()) {
            ProfilePoint extensionManagerStartup = profiler.start("Extension manager startup", LogLevel.VERBOSE);
            try {
                ExtensionManager.Startup();
            }
            finally {
                extensionManagerStartup.stop();
            }
        }
        if (options.reloadScripts() && env != null) {
            env.getEnv(GlobalEnv.class).SetLabel("*");
            ProfilePoint executeAutoIncludes = profiler.start("Execution of auto includes", LogLevel.VERBOSE);
            try {
                includeCache.executeAutoIncludes(env, null);
            }
            finally {
                executeAutoIncludes.stop();
            }
            ProfilePoint executeMS = profiler.start("Execution of MS files in Local Packages", LogLevel.VERBOSE);
            try {
                env.getEnv(CommandHelperEnvironment.class).SetCommandSender(Static.getServer().getConsole());
                localPackages.executeMS(env);
            }
            finally {
                env.getEnv(CommandHelperEnvironment.class).SetCommandSender(null);
                executeMS.stop();
            }
            ProfilePoint registerCommands = profiler.start("Registering of annotated commands", LogLevel.VERBOSE);
            try {
                for (Script s1 : this.scripts) {
                    if (s1.getSmartComment().getAnnotations("@command").isEmpty()) continue;
                    this.registerCommand(s1, env);
                }
            }
            finally {
                registerCommands.stop();
            }
        }
        ProfilePoint postReloadAliases = profiler.start("Extension manager post reload aliases", LogLevel.VERBOSE);
        try {
            ExtensionManager.PostReloadAliases();
        }
        finally {
            postReloadAliases.stop();
        }
        Object output = firstLoad ? "Load complete. " : "Reload complete. ";
        if (options.reloadScripts()) {
            int count = localPackages.getMSFileCount() + localPackages.getMSAFileCount() + includeCache.size();
            output = (String)output + count + " files processed.";
        }
        Static.getLogger().log(Level.INFO, (String)output);
        if (player2 != null) {
            player2.sendMessage(String.valueOf((Object)MCChatColor.YELLOW) + "[CommandHelper] " + (String)output);
        }
    }

    private void registerCommand(Script script, Environment env) {
        MCCommand cmd = StaticLayer.GetConvertor().getNewCommand(script.getCommandName().toLowerCase());
        SmartComment comment = script.getSmartComment();
        String description = comment.getBody();
        cmd.setDescription(description);
        String usage = script.getSignatureWithoutLabel();
        if (!comment.getAnnotations("@usage").isEmpty()) {
            if (comment.getAnnotations("@usage").size() > 1) {
                MSLog.GetLogger().w(MSLog.Tags.COMPILER, "Duplicate usage annotation found. Will only use the first.", script.getTarget());
            }
            usage = comment.getAnnotations("@usage").get(0);
        }
        cmd.setUsage(usage);
        if (!comment.getAnnotations("@permission").isEmpty()) {
            if (comment.getAnnotations("@permission").size() > 1) {
                MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.COMPILER, "Duplicate permissions annotations, only one is allowed. Only the first is being used, but this is almost certainly not what you want, check your code immediately.", script.getTarget());
            }
            cmd.setPermission(comment.getAnnotations("@permission").get(0));
        }
        if (!comment.getAnnotations("@noPermMsg").isEmpty()) {
            if (comment.getAnnotations("@noPermMsg").size() > 1) {
                MSLog.GetLogger().w(MSLog.Tags.COMPILER, "Duplicate noPermMsg annotation found. Will only use the first.", script.getTarget());
            }
            cmd.setPermissionMessage(comment.getAnnotations("@noPermMsg").get(0));
        }
        cmd.setAliases(comment.getAnnotations("@alias"));
        if (!comment.getAnnotations("@tabcompleter").isEmpty()) {
            String proc2;
            if (comment.getAnnotations("@tabcompleter").size() > 1) {
                MSLog.GetLogger().w(MSLog.Tags.COMPILER, "Duplicate tabcompleter annotation found. Will only use the first.", script.getTarget());
            }
            if ("".equals(proc2 = comment.getAnnotations("@tabcompleter").get(0).trim())) {
                MSLog.GetLogger().i(MSLog.Tags.COMPILER, "Missing proc name in @tabcompleter annotation.", script.getTarget());
            } else {
                Procedure p2 = env.getEnv(GlobalEnv.class).GetProcs().get(proc2);
                Mixed m = null;
                try {
                    m = p2.execute(new ArrayList<Mixed>(), env, script.getTarget());
                }
                catch (ConfigRuntimeException ex) {
                    MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.COMPILER, "Script defined at " + String.valueOf(script.getTarget()) + " threw an exception. Tabcompletion is being skipped for this alias.", p2.getTarget());
                    ConfigRuntimeException.HandleUncaughtException(ex, env);
                }
                if (m != null) {
                    if (!(m instanceof CClosure)) {
                        MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.COMPILER, "Procedure " + proc2 + " returns a value other than a closure. It must unconditionally return a closure.", p2.getTarget());
                    } else {
                        Commands.set_tabcompleter.customExec(script.getTarget(), env, cmd, m);
                    }
                }
            }
        } else {
            HashMap<Object, Object> paramTypes = new HashMap<Object, Object>();
            for (String param : comment.getAnnotations("@param")) {
                String[] vals = param.split(" ");
                if (vals.length < 2) {
                    CompilerWarning warning = new CompilerWarning("One of the @param values for this comment is malformed, and won't be autocompleted. The general format should be \"@param $variableName <TYPE> [<DESCRIPTION>]\"", script.getTarget(), FileOptions.SuppressWarning.MalformedComment);
                    env.getEnv(CompilerEnvironment.class).addCompilerWarning(script.getScriptFileOptions(), warning);
                    continue;
                }
                Object name = vals[0];
                Object type = vals[1];
                if (((String)type).startsWith("[")) {
                    for (int i = 2; i < vals.length; ++i) {
                        type = (String)type + " " + (String)vals[i];
                        if (((String)vals[i]).endsWith("]")) break;
                    }
                }
                paramTypes.put(name, type);
            }
            ArrayList<CompletionValues> completions = new ArrayList<CompletionValues>();
            boolean hasFinal = false;
            for (Construct parameter : script.getParameters()) {
                if (parameter instanceof Command) continue;
                if (parameter instanceof CString) {
                    CString s = (CString)parameter;
                    completions.add((alias, player2, args) -> Arrays.asList(s.val()));
                    continue;
                }
                if (parameter instanceof Variable) {
                    String type;
                    Variable v = (Variable)parameter;
                    if (v.isFinal()) {
                        hasFinal = true;
                    }
                    if ((type = (String)paramTypes.get(v.getVariableName())) == null) {
                        if (v.getVariableName().toLowerCase().contains("player")) {
                            type = "$Player";
                        } else {
                            completions.add(NONE);
                            continue;
                        }
                    }
                    if (type.startsWith("[") && type.endsWith("]")) {
                        String finalType = type = type.substring(1, type.length() - 1);
                        completions.add((alias, player2, args) -> Arrays.asList(finalType.split(",")).stream().map(item -> item.trim()).toList());
                        continue;
                    }
                    if (type.equalsIgnoreCase("$none") || type.equalsIgnoreCase("none") || type.equalsIgnoreCase("string")) {
                        completions.add(NONE);
                        continue;
                    }
                    if (type.equalsIgnoreCase("$player")) {
                        completions.add(new CompletionValues(){

                            @Override
                            public List<String> getCompletions(CString alias, CString player2, CArray args) {
                                return Static.getServer().getOnlinePlayers().stream().map(p2 -> p2.getName()).toList();
                            }
                        });
                        continue;
                    }
                    if (type.equalsIgnoreCase("$offlineplayer")) {
                        completions.add((alias, player2, args) -> Arrays.asList(Static.getServer().getOfflinePlayers()).stream().map(p2 -> p2.getName()).toList());
                        continue;
                    }
                    if (type.equalsIgnoreCase("$boolean") || type.equalsIgnoreCase("boolean")) {
                        completions.add((alias, player2, args) -> Arrays.asList("true", "false"));
                        continue;
                    }
                    if (type.startsWith("$proc->")) {
                        String procName = type.substring(7);
                        Procedure completionProc = env.getEnv(GlobalEnv.class).GetProcs().get(procName);
                        if (completionProc == null) {
                            MSLog.GetLogger().w(MSLog.Tags.COMPILER, "Could not find " + String.valueOf(completionProc) + ", the parameter autocompletion will not work.", script.getTarget());
                            completions.add(NONE);
                            continue;
                        }
                        completions.add((alias, player2, args) -> {
                            Mixed ret = completionProc.execute(Arrays.asList(alias, player2, args), env, Target.UNKNOWN);
                            if (ret instanceof CArray) {
                                CArray ca = (CArray)ret;
                                return ca.asList().stream().map(i -> i.toString()).toList();
                            }
                            MSLog.GetLogger().w(MSLog.Tags.COMPILER, "Completion proc " + String.valueOf(completionProc) + " returned a non-array value.", script.getTarget());
                            return new ArrayList();
                        });
                        continue;
                    }
                    try {
                        FullyQualifiedClassName fqcn = FullyQualifiedClassName.forName(type, Target.UNKNOWN, env);
                        CClassType t2 = CClassType.get(fqcn);
                        if (t2.isEnum()) {
                            MEnumType enumType = NativeTypeList.getNativeEnumType(fqcn);
                            completions.add((alias, player2, args) -> enumType.values().stream().map(value -> value.name()).toList());
                            continue;
                        }
                    }
                    catch (CRECastException | ClassNotFoundException exception) {
                        // empty catch block
                    }
                    completions.add(NONE);
                    continue;
                }
                completions.add(NONE);
            }
            boolean finalHasFinal = hasFinal;
            CNativeClosure.ClosureRunnable runnable = (t, e, args) -> {
                List<String> inputArgs = ((CArray)args[2]).asList().stream().map(val -> val.val()).toList();
                CompletionValues completion = null;
                if (inputArgs.size() <= completions.size()) {
                    completion = (CompletionValues)completions.get(inputArgs.size() - 1);
                }
                if (completion == null) {
                    if (finalHasFinal) {
                        completion = (CompletionValues)completions.get(completions.size() - 1);
                    } else {
                        return new CArray(Target.UNKNOWN);
                    }
                }
                CString alias = (CString)args[0];
                CString sender = (CString)args[1];
                CArray a = (CArray)args[2];
                List<String> list = completion.getCompletions(alias, sender, a);
                String comparison = inputArgs.get(inputArgs.size() - 1);
                Mixed[] toReturn = (Mixed[])list.stream().filter(item -> item.startsWith(comparison)).map(item -> new CString((String)item, Target.UNKNOWN)).toList().toArray(CString[]::new);
                return new CArray(t, toReturn);
            };
            CNativeClosure nativeClosure = new CNativeClosure(runnable, env);
            Commands.set_tabcompleter.customExec(script.getTarget(), env, cmd, nativeClosure);
        }
        MCCommandMap map = Static.getServer().getCommandMap();
        String prefix = Implementation.GetServerType().getBranding().toLowerCase(Locale.ENGLISH);
        map.register(prefix + ":" + script.getCommandName().toLowerCase(), cmd);
    }

    public static String file_get_contents(String fileLocation) throws IOException {
        StringBuilder ret = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileLocation), StandardCharsets.UTF_8));){
            String str;
            while ((str = in.readLine()) != null) {
                ret.append(str).append('\n');
            }
        }
        return ret.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean file_put_contents(File fileLocation, String contents, String mode2) throws Exception {
        BufferedWriter out;
        block5: {
            block6: {
                if (!fileLocation.exists()) break block6;
                if (mode2.equalsIgnoreCase("o")) {
                    out = new BufferedWriter(new FileWriter(fileLocation));
                    break block5;
                } else if (mode2.equalsIgnoreCase("a")) {
                    out = new BufferedWriter(new FileWriter(fileLocation, true));
                    break block5;
                } else {
                    if (mode2.equalsIgnoreCase("c")) {
                        return false;
                    }
                    throw new RuntimeException("Undefined mode in file_put_contents: " + mode2);
                }
            }
            out = new BufferedWriter(new FileWriter(fileLocation));
        }
        out.write(contents);
        out.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringResource(InputStream is) throws IOException {
        StringWriter writer = new StringWriter();
        char[] buffer = new char[1024];
        try {
            int n;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((n = reader.read(buffer)) != -1) {
                ((Writer)writer).write(buffer, 0, n);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return ((Object)writer).toString();
    }

    public void removePlayerReference(MCCommandSender p2) {
        if (p2 instanceof MCPlayer) {
            this.echoCommand.remove(p2.getName());
        }
    }

    public void addPlayerReference(MCCommandSender p2) {
        if (p2 instanceof MCPlayer) {
            this.echoCommand.add(p2.getName());
        }
    }

    public boolean hasPlayerReference(MCCommandSender p2) {
        if (p2 instanceof MCPlayer) {
            return this.echoCommand.contains(p2.getName());
        }
        return false;
    }

    public class ReloadOptions {
        boolean globals = true;
        boolean timeouts = true;
        boolean executionQueue = true;
        boolean persistenceConfig = true;
        boolean profiler = true;
        boolean scripts = true;
        boolean extensions = true;
        private final ArgumentParser options = ArgumentParser.GetParser().addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Sets the list of arguments to be a whitelist, that is, only the specified modules get reloaded, the rest will be skipped. Without this option, the specified modules don't get reloaded.").asFlag().setName("whitelist")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Specifies that globals memory (values stored with export/import) should be preserved.").asFlag().setName('g', "globals")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Specifies that tasks registered with set_interval/set_timeout should be preserved.").asFlag().setName('t', "tasks")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Specifies that tasks registered in execution queues should be preserved.").asFlag().setName('e', "execution-queue")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Specifies that the persistence config file should not be reloaded.").asFlag().setName('r', "persistence-config")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Specifies that the profiler config should not be reloaded.").asFlag().setName('f', "profiler")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Specifies that scripts should not be reloaded.").asFlag().setName('s', "scripts")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Specifies that extensions should not be reloaded.").asFlag().setName('x', "extensions")).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("Prints this list and returns. Nothing is reloaded if this option is set.").asFlag().setName('h', "help"));

        public ReloadOptions(String[] settings) throws ArgumentParser.ValidationException {
            if (settings != null) {
                ArgumentParser.ArgumentParserResults results = this.options.match(settings);
                if (results.isFlagSet(Character.valueOf('h'))) {
                    throw new CancelCommandException(this.options.getBuiltDescription(), Target.UNKNOWN);
                }
                if (results.isFlagSet("whitelist")) {
                    this.globals = false;
                    this.timeouts = false;
                    this.executionQueue = false;
                    this.persistenceConfig = false;
                    this.profiler = false;
                    this.scripts = false;
                    this.extensions = false;
                }
                if (results.isFlagSet(Character.valueOf('g'))) {
                    boolean bl = this.globals = !this.globals;
                }
                if (results.isFlagSet(Character.valueOf('t'))) {
                    boolean bl = this.timeouts = !this.timeouts;
                }
                if (results.isFlagSet(Character.valueOf('e'))) {
                    boolean bl = this.executionQueue = !this.executionQueue;
                }
                if (results.isFlagSet(Character.valueOf('r')) || results.isFlagSet("persistence-config")) {
                    boolean bl = this.persistenceConfig = !this.persistenceConfig;
                }
                if (results.isFlagSet(Character.valueOf('f'))) {
                    boolean bl = this.profiler = !this.profiler;
                }
                if (results.isFlagSet(Character.valueOf('s'))) {
                    boolean bl = this.scripts = !this.scripts;
                }
                if (results.isFlagSet(Character.valueOf('x'))) {
                    this.extensions = !this.extensions;
                }
            }
        }

        public boolean reloadGlobals() {
            return this.globals;
        }

        public boolean reloadTimeouts() {
            return this.timeouts;
        }

        public boolean reloadExecutionQueue() {
            return this.executionQueue;
        }

        public boolean reloadPersistenceConfig() {
            return this.persistenceConfig;
        }

        public boolean reloadProfiler() {
            return this.profiler;
        }

        public boolean reloadScripts() {
            return this.scripts;
        }

        public boolean reloadExtensions() {
            return this.extensions;
        }
    }

    private static interface CompletionValues {
        public List<String> getCompletions(CString var1, CString var2, CArray var3);
    }
}

