/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.com.google.common.primitives;

import com.laytonsmith.libs.com.google.common.annotations.GwtCompatible;
import com.laytonsmith.libs.com.google.common.annotations.GwtIncompatible;
import com.laytonsmith.libs.com.google.common.base.Converter;
import com.laytonsmith.libs.com.google.common.base.Preconditions;
import com.laytonsmith.libs.com.google.common.primitives.ElementTypesAreNonnullByDefault;
import com.laytonsmith.libs.com.google.common.primitives.IntsMethodsForWeb;
import com.laytonsmith.libs.com.google.common.primitives.Longs;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Ints
extends IntsMethodsForWeb {
    public static final int BYTES = 4;
    public static final int MAX_POWER_OF_TWO = 0x40000000;

    private Ints() {
    }

    public static int hashCode(int value) {
        return value;
    }

    public static int checkedCast(long value) {
        int result = (int)value;
        Preconditions.checkArgument((long)result == value, "Out of range: %s", value);
        return result;
    }

    public static int saturatedCast(long value) {
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (value < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)value;
    }

    public static int compare(int a, int b) {
        return a < b ? -1 : (a > b ? 1 : 0);
    }

    public static boolean contains(int[] array2, int target) {
        for (int value : array2) {
            if (value != target) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(int[] array2, int target) {
        return Ints.indexOf(array2, target, 0, array2.length);
    }

    private static int indexOf(int[] array2, int target, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (array2[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] array2, int[] target) {
        Preconditions.checkNotNull(array2, "array");
        Preconditions.checkNotNull(target, "target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < array2.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array2[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(int[] array2, int target) {
        return Ints.lastIndexOf(array2, target, 0, array2.length);
    }

    private static int lastIndexOf(int[] array2, int target, int start, int end) {
        for (int i = end - 1; i >= start; --i) {
            if (array2[i] != target) continue;
            return i;
        }
        return -1;
    }

    @GwtIncompatible(value="Available in GWT! Annotation is to avoid conflict with GWT specialization of base class.")
    public static int min(int ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        int min2 = array2[0];
        for (int i = 1; i < array2.length; ++i) {
            if (array2[i] >= min2) continue;
            min2 = array2[i];
        }
        return min2;
    }

    @GwtIncompatible(value="Available in GWT! Annotation is to avoid conflict with GWT specialization of base class.")
    public static int max(int ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        int max2 = array2[0];
        for (int i = 1; i < array2.length; ++i) {
            if (array2[i] <= max2) continue;
            max2 = array2[i];
        }
        return max2;
    }

    public static int constrainToRange(int value, int min2, int max2) {
        Preconditions.checkArgument(min2 <= max2, "min (%s) must be less than or equal to max (%s)", min2, max2);
        return Math.min(Math.max(value, min2), max2);
    }

    public static int[] concat(int[] ... arrays) {
        int length2 = 0;
        for (int[] array2 : arrays) {
            length2 += array2.length;
        }
        int[] result = new int[length2];
        int pos = 0;
        for (int[] array3 : arrays) {
            System.arraycopy(array3, 0, result, pos, array3.length);
            pos += array3.length;
        }
        return result;
    }

    public static byte[] toByteArray(int value) {
        return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    public static int fromByteArray(byte[] bytes) {
        Preconditions.checkArgument(bytes.length >= 4, "array too small: %s < %s", bytes.length, 4);
        return Ints.fromBytes(bytes[0], bytes[1], bytes[2], bytes[3]);
    }

    public static int fromBytes(byte b1, byte b2, byte b3, byte b4) {
        return b1 << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }

    public static Converter<String, Integer> stringConverter() {
        return IntConverter.INSTANCE;
    }

    public static int[] ensureCapacity(int[] array2, int minLength, int padding) {
        Preconditions.checkArgument(minLength >= 0, "Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, "Invalid padding: %s", padding);
        return array2.length < minLength ? Arrays.copyOf(array2, minLength + padding) : array2;
    }

    public static String join(String separator, int ... array2) {
        Preconditions.checkNotNull(separator);
        if (array2.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array2.length * 5);
        builder.append(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            builder.append(separator).append(array2[i]);
        }
        return builder.toString();
    }

    public static Comparator<int[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sortDescending(int[] array2) {
        Preconditions.checkNotNull(array2);
        Ints.sortDescending(array2, 0, array2.length);
    }

    public static void sortDescending(int[] array2, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        Arrays.sort(array2, fromIndex, toIndex);
        Ints.reverse(array2, fromIndex, toIndex);
    }

    public static void reverse(int[] array2) {
        Preconditions.checkNotNull(array2);
        Ints.reverse(array2, 0, array2.length);
    }

    public static void reverse(int[] array2, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        int i = fromIndex;
        for (int j = toIndex - 1; i < j; ++i, --j) {
            int tmp = array2[i];
            array2[i] = array2[j];
            array2[j] = tmp;
        }
    }

    public static void rotate(int[] array2, int distance2) {
        Ints.rotate(array2, distance2, 0, array2.length);
    }

    public static void rotate(int[] array2, int distance2, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        if (array2.length <= 1) {
            return;
        }
        int length2 = toIndex - fromIndex;
        int m = -distance2 % length2;
        m = m < 0 ? m + length2 : m;
        int newFirstIndex = m + fromIndex;
        if (newFirstIndex == fromIndex) {
            return;
        }
        Ints.reverse(array2, fromIndex, newFirstIndex);
        Ints.reverse(array2, newFirstIndex, toIndex);
        Ints.reverse(array2, fromIndex, toIndex);
    }

    public static int[] toArray(Collection<? extends Number> collection) {
        if (collection instanceof IntArrayAsList) {
            return ((IntArrayAsList)collection).toIntArray();
        }
        Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        int[] array2 = new int[len];
        for (int i = 0; i < len; ++i) {
            array2[i] = ((Number)Preconditions.checkNotNull(boxedArray[i])).intValue();
        }
        return array2;
    }

    public static List<Integer> asList(int ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new IntArrayAsList(backingArray);
    }

    @CheckForNull
    public static Integer tryParse(String string) {
        return Ints.tryParse(string, 10);
    }

    @CheckForNull
    public static Integer tryParse(String string, int radix) {
        Long result = Longs.tryParse(string, radix);
        if (result == null || result != (long)result.intValue()) {
            return null;
        }
        return result.intValue();
    }

    @GwtCompatible
    private static class IntArrayAsList
    extends AbstractList<Integer>
    implements RandomAccess,
    Serializable {
        final int[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        IntArrayAsList(int[] array2) {
            this(array2, 0, array2.length);
        }

        IntArrayAsList(int[] array2, int start, int end) {
            this.array = array2;
            this.start = start;
            this.end = end;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Integer get(int index) {
            Preconditions.checkElementIndex(index, this.size());
            return this.array[this.start + index];
        }

        public Spliterator.OfInt spliterator() {
            return Spliterators.spliterator(this.array, this.start, this.end, 0);
        }

        @Override
        public boolean contains(@CheckForNull Object target) {
            return target instanceof Integer && Ints.indexOf(this.array, (Integer)target, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(@CheckForNull Object target) {
            int i;
            if (target instanceof Integer && (i = Ints.indexOf(this.array, (Integer)target, this.start, this.end)) >= 0) {
                return i - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(@CheckForNull Object target) {
            int i;
            if (target instanceof Integer && (i = Ints.lastIndexOf(this.array, (Integer)target, this.start, this.end)) >= 0) {
                return i - this.start;
            }
            return -1;
        }

        @Override
        public Integer set(int index, Integer element) {
            Preconditions.checkElementIndex(index, this.size());
            int oldValue = this.array[this.start + index];
            this.array[this.start + index] = Preconditions.checkNotNull(element);
            return oldValue;
        }

        @Override
        public List<Integer> subList(int fromIndex, int toIndex) {
            int size = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, size);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new IntArrayAsList(this.array, this.start + fromIndex, this.start + toIndex);
        }

        @Override
        public boolean equals(@CheckForNull Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof IntArrayAsList) {
                IntArrayAsList that = (IntArrayAsList)object;
                int size = this.size();
                if (that.size() != size) {
                    return false;
                }
                for (int i = 0; i < size; ++i) {
                    if (this.array[this.start + i] == that.array[that.start + i]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int result = 1;
            for (int i = this.start; i < this.end; ++i) {
                result = 31 * result + Ints.hashCode(this.array[i]);
            }
            return result;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(this.size() * 5);
            builder.append('[').append(this.array[this.start]);
            for (int i = this.start + 1; i < this.end; ++i) {
                builder.append(", ").append(this.array[i]);
            }
            return builder.append(']').toString();
        }

        int[] toIntArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }
    }

    private static enum LexicographicalComparator implements Comparator<int[]>
    {
        INSTANCE;


        @Override
        public int compare(int[] left, int[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i = 0; i < minLength; ++i) {
                int result = Ints.compare(left[i], right[i]);
                if (result == 0) continue;
                return result;
            }
            return left.length - right.length;
        }

        public String toString() {
            return "Ints.lexicographicalComparator()";
        }
    }

    private static final class IntConverter
    extends Converter<String, Integer>
    implements Serializable {
        static final IntConverter INSTANCE = new IntConverter();
        private static final long serialVersionUID = 1L;

        private IntConverter() {
        }

        @Override
        protected Integer doForward(String value) {
            return Integer.decode(value);
        }

        @Override
        protected String doBackward(Integer value) {
            return value.toString();
        }

        public String toString() {
            return "Ints.stringConverter()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

