/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import com.laytonsmith.PureUtilities.Common.ArrayUtils;
import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class ZipReader {
    private final File topZip;
    private final Deque<File> chainedPath;
    private final File file;
    private final boolean isZipped;
    private List<File> zipEntries = null;
    private List<File> zipDirectories = new ArrayList<File>();

    public ZipReader(URL url) {
        this(new File(url.getFile()));
    }

    public ZipReader(File file) {
        String newFile;
        this.chainedPath = new LinkedList<File>();
        if (file.getPath().startsWith("jar:")) {
            newFile = file.getPath().substring(4);
            file = new File(newFile);
        }
        if (file.getPath().startsWith("file:")) {
            newFile = file.getPath().substring(5);
            newFile = newFile.replace('\\', '/').replace('!', '/');
            while (newFile.startsWith("//")) {
                newFile = newFile.substring(1);
            }
            file = new File(newFile);
        }
        this.file = file = file.getAbsoluteFile();
        File f = file;
        this.chainedPath.addFirst(f);
        File tempTopZip = null;
        while ((f = f.getParentFile()) != null) {
            this.chainedPath.addFirst(f);
            try {
                if (tempTopZip != null) continue;
                ZipFile zf = new ZipFile(f);
                tempTopZip = f;
            }
            catch (ZipException zipException) {
            }
            catch (IOException | AccessControlException exception) {}
        }
        this.isZipped = tempTopZip != null;
        this.topZip = this.isZipped ? tempTopZip : file;
    }

    public File getTopLevelFile() {
        return this.topZip;
    }

    public boolean exists() {
        if (!this.topZip.exists()) {
            return false;
        }
        try {
            this.getInputStream().close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean canRead() {
        return this.topZip.canRead();
    }

    public boolean canWrite() {
        if (this.isZipped) {
            return false;
        }
        return this.topZip.canWrite();
    }

    public boolean isZipped() {
        return this.isZipped;
    }

    public InputStream getInputStream() throws FileNotFoundException, IOException {
        if (!this.isZipped) {
            return new FileInputStream(this.file);
        }
        return this.getFile(this.chainedPath, this.topZip.getAbsolutePath(), new ZipInputStream(new FileInputStream(this.topZip)));
    }

    public String getFileContents() throws FileNotFoundException, IOException {
        return this.getFileContents("UTF-8");
    }

    public String getFileContents(String charset) throws FileNotFoundException, IOException {
        if (!this.isZipped) {
            return FileUtil.read(this.file, charset);
        }
        return StreamUtils.GetString(this.getInputStream());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ZipReader other = (ZipReader)obj;
        return other.file.equals(this.file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        return this.file.toString();
    }

    public File getFile() {
        return this.file;
    }

    private InputStream getFile(Deque<File> fullChain, String zipName, ZipInputStream zis) throws FileNotFoundException, IOException {
        ZipEntry entry;
        BufferedInputStream zipReader = new BufferedInputStream(zis);
        boolean isZip = false;
        ArrayList<CallSite> recurseAttempts = new ArrayList<CallSite>();
        while ((entry = zis.getNextEntry()) != null) {
            File file;
            isZip = true;
            LinkedList<File> chain = new LinkedList<File>(fullChain);
            Object var9_10 = null;
            while ((file = (File)chain.pollFirst()) != null && !file.equals(new File(zipName + File.separator + entry.getName()))) {
            }
            if (file == null) continue;
            if (chain.isEmpty()) {
                return zipReader;
            }
            recurseAttempts.add((CallSite)((Object)(zipName + File.separator + entry.getName())));
        }
        for (String string : recurseAttempts) {
            ZipInputStream inner = new ZipInputStream(zipReader);
            try {
                return this.getFile(fullChain, string, inner);
            }
            catch (IOException iOException) {
            }
        }
        if (isZip) {
            throw new FileNotFoundException(zipName + " could not be found!");
        }
        throw new IOException(zipName + " is not a zip file!");
    }

    private void initList() throws IOException {
        if (!this.isZipped) {
            return;
        }
        if (this.zipEntries == null) {
            this.zipEntries = new ArrayList<File>();
            try (ZipInputStream zis = new ZipInputStream(new FileInputStream(this.topZip));){
                ZipEntry entry;
                while ((entry = zis.getNextEntry()) != null) {
                    File f = new File(this.topZip, entry.getName());
                    this.zipEntries.add(f);
                    if (!entry.isDirectory()) continue;
                    this.zipDirectories.add(f);
                }
            }
        }
    }

    public boolean isDirectory() throws IOException {
        if (!this.isZipped) {
            return this.file.isDirectory();
        }
        this.initList();
        return this.zipDirectories.contains(this.file);
    }

    public String getName() {
        return this.file.getName();
    }

    public File[] listFiles() throws IOException {
        if (!this.isZipped) {
            return this.file.listFiles();
        }
        this.initList();
        ArrayList<File> files = new ArrayList<File>();
        for (File f : this.zipEntries) {
            if (!f.getPath().startsWith(this.file.getPath()) || this.file.equals(f) || f.getPath().matches(Pattern.quote(this.file.getPath() + File.separatorChar) + "[^" + Pattern.quote(File.separator) + "]*" + Pattern.quote(File.separator) + ".*")) continue;
            files.add(f);
        }
        return ArrayUtils.asArray(File.class, files);
    }

    public ZipReader[] zipListFiles() throws IOException {
        File[] ret = this.listFiles();
        ZipReader[] zips = new ZipReader[ret.length];
        for (int i = 0; i < ret.length; ++i) {
            zips[i] = ret[i].isAbsolute() ? new ZipReader(ret[i]) : new ZipReader(new File(this.file, ret[i].getPath()));
        }
        return zips;
    }

    public void recursiveCopy(File dstFolder, boolean create) throws IOException {
        if (create) {
            dstFolder.mkdirs();
        }
        if (!dstFolder.isDirectory()) {
            throw new IOException("Destination folder is not a directory!");
        }
        for (ZipReader r : this.zipListFiles()) {
            File newFile;
            if (r.isDirectory()) {
                newFile = new File(dstFolder, r.getName());
                newFile.mkdir();
                r.recursiveCopy(newFile, create);
                continue;
            }
            newFile = new File(dstFolder, r.file.getName());
            newFile.getParentFile().mkdir();
            try (FileOutputStream fos = new FileOutputStream(newFile, false);
                 InputStream fis = r.getInputStream();){
                StreamUtils.Copy(fis, fos);
            }
        }
    }
}

