/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.io.gsonfire.gson;

import com.laytonsmith.libs.com.google.gson.TypeAdapter;
import com.laytonsmith.libs.com.google.gson.stream.JsonReader;
import com.laytonsmith.libs.com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Date;

abstract class DateUnixtimeTypeAdapter
extends TypeAdapter<Date> {
    private final boolean allowNegativeTimestamp;

    public DateUnixtimeTypeAdapter(boolean allowNegativeTimestamp) {
        this.allowNegativeTimestamp = allowNegativeTimestamp;
    }

    @Override
    public final void write(JsonWriter out, Date value) throws IOException {
        long time2 = value.getTime();
        if (time2 >= 0L || this.allowNegativeTimestamp) {
            out.value(this.toTimestamp(value));
        } else {
            out.nullValue();
        }
    }

    @Override
    public final Date read(JsonReader in) throws IOException {
        long time2 = in.nextLong();
        if (time2 >= 0L || this.allowNegativeTimestamp) {
            return this.fromTimestamp(time2);
        }
        return null;
    }

    protected abstract long toTimestamp(Date var1);

    protected abstract Date fromTimestamp(long var1);
}

