/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import com.laytonsmith.PureUtilities.ProgressIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipIterator {
    private final File zip;

    public ZipIterator(File zip) {
        this.zip = zip;
    }

    public void iterate(ZipIteratorCallback callback) throws IOException {
        this.iterate(callback, null);
    }

    public void iterate(ZipIteratorCallback callback, final ProgressIterator progressIterator) throws IOException {
        ZipEntry entry;
        final ZipInputStream zis = new ZipInputStream(new FileInputStream(this.zip));
        final double size = this.zip.length();
        while ((entry = zis.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            callback.handle(entry.getName(), new InputStream(){
                private double soFar = 0.0;

                @Override
                public int read() throws IOException {
                    if (progressIterator != null) {
                        this.soFar += 1.0;
                        if (this.soFar % 128.0 == 0.0) {
                            progressIterator.progressChanged(this.soFar, size);
                        }
                    }
                    return zis.read();
                }

                @Override
                public void close() throws IOException {
                }
            });
        }
        zis.close();
    }

    public static interface ZipIteratorCallback {
        public void handle(String var1, InputStream var2);
    }
}

