/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.tools.docgen;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscoveryCache;
import com.laytonsmith.PureUtilities.ClassLoading.DynamicClassLoader;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.annotations.api;
import com.laytonsmith.commandhelper.CommandHelperFileLocations;
import com.laytonsmith.core.events.Event;
import com.laytonsmith.core.functions.Function;
import com.laytonsmith.tools.docgen.DocGen;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExtensionDocGen {
    private static final String NL = StringUtils.nl();
    private static final Pattern WIKI_LINK = Pattern.compile("\\[([a-zA-Z]+://[^ ]+) ([^\\]]+)]");

    public static void generate(File inputExtension, OutputStream outputStream2) throws InstantiationException, IllegalAccessException, MalformedURLException, IOException {
        ClassDiscovery customDiscovery = new ClassDiscovery();
        ClassDiscoveryCache cache = new ClassDiscoveryCache(CommandHelperFileLocations.getDefault().getCacheDirectory());
        customDiscovery.setClassDiscoveryCache(cache);
        URL url = new URL("jar:" + String.valueOf(inputExtension.toURI().toURL()) + "!/");
        customDiscovery.addDiscoveryLocation(url);
        customDiscovery.setDefaultClassLoader(ExtensionDocGen.class.getClassLoader());
        StringBuilder fdocs = new StringBuilder();
        DynamicClassLoader classloader = new DynamicClassLoader();
        classloader.addJar(url);
        HashMap functionMap = new HashMap();
        for (Class<Function> clazz : customDiscovery.loadClassesWithAnnotationThatExtend(api.class, Function.class, classloader, true)) {
            Class<?> clazz2 = clazz.getEnclosingClass();
            if (functionMap.containsKey(clazz2)) {
                ((ArrayList)functionMap.get(clazz2)).add(clazz);
                continue;
            }
            functionMap.put(clazz2, new ArrayList());
            ((ArrayList)functionMap.get(clazz2)).add(clazz);
        }
        ArrayList functionEntryList = new ArrayList(functionMap.entrySet());
        Collections.sort(functionEntryList, new Comparator<Map.Entry<Class<?>, ArrayList<Class<? extends Function>>>>(){

            @Override
            public int compare(Map.Entry<Class<?>, ArrayList<Class<? extends Function>>> o1, Map.Entry<Class<?>, ArrayList<Class<? extends Function>>> o2) {
                return o1.getKey().getName().compareTo(o2.getKey().getName());
            }
        });
        for (Map.Entry entry : functionEntryList) {
            Collections.sort((List)entry.getValue(), new Comparator<Class<? extends Function>>(){

                @Override
                public int compare(Class<? extends Function> o1, Class<? extends Function> o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
        }
        if (!functionEntryList.isEmpty()) {
            fdocs.append("# Functions").append(NL);
        }
        for (Map.Entry entry : functionEntryList) {
            Class clazz = (Class)entry.getKey();
            String[] split2 = clazz.getName().split("\\.");
            fdocs.append("## ").append(split2[split2.length - 1]).append(NL);
            try {
                Method docsMethod = clazz.getMethod("docs", null);
                Object o = clazz.newInstance();
                fdocs.append((String)docsMethod.invoke(o, (Object[])null)).append(NL).append(NL);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException docsMethod) {
                // empty catch block
            }
            for (Class cf : (ArrayList)entry.getValue()) {
                Function f = (Function)cf.newInstance();
                if (!f.appearInDocumentation()) continue;
                DocGen.DocInfo di = new DocGen.DocInfo(f.docs());
                String d = "### " + ExtensionDocGen.markdownEscape(di.ret) + " " + ExtensionDocGen.markdownEscape(f.getName()) + "(" + ExtensionDocGen.markdownEscape(di.originalArgs) + "):" + NL + ExtensionDocGen.convertWiki(di.topDesc != null ? di.topDesc : di.desc) + NL + ExtensionDocGen.convertWiki((String)(di.extendedDesc != null ? NL + di.extendedDesc + NL : ""));
                fdocs.append(d).append(NL);
            }
        }
        HashMap hashMap = new HashMap();
        for (Class<Event> clazz : customDiscovery.loadClassesWithAnnotationThatExtend(api.class, Event.class, classloader, true)) {
            Class<?> enclosing = clazz.getEnclosingClass();
            if (hashMap.containsKey(enclosing)) {
                ((ArrayList)hashMap.get(enclosing)).add(clazz);
                continue;
            }
            hashMap.put(enclosing, new ArrayList());
            ((ArrayList)hashMap.get(enclosing)).add(clazz);
        }
        ArrayList arrayList = new ArrayList(hashMap.entrySet());
        Collections.sort(arrayList, new Comparator<Map.Entry<Class<?>, ArrayList<Class<? extends Event>>>>(){

            @Override
            public int compare(Map.Entry<Class<?>, ArrayList<Class<? extends Event>>> o1, Map.Entry<Class<?>, ArrayList<Class<? extends Event>>> o2) {
                return o1.getKey().getName().compareTo(o2.getKey().getName());
            }
        });
        for (Map.Entry e : arrayList) {
            Collections.sort((List)e.getValue(), new Comparator<Class<? extends Event>>(){

                @Override
                public int compare(Class<? extends Event> o1, Class<? extends Event> o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
        }
        if (!arrayList.isEmpty()) {
            fdocs.append("# Events").append(NL);
        }
        for (Map.Entry entry : arrayList) {
            Class enclosingClass = (Class)entry.getKey();
            String[] split3 = enclosingClass.getName().split("\\.");
            fdocs.append("## ").append(split3[split3.length - 1]).append(NL);
            try {
                Method docsMethod = enclosingClass.getMethod("docs", null);
                Object o = enclosingClass.newInstance();
                fdocs.append((String)docsMethod.invoke(o, (Object[])null)).append(NL).append(NL);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
            for (Class ce : (ArrayList)entry.getValue()) {
                Event e = (Event)ce.newInstance();
                Pattern p2 = Pattern.compile("\\{(.*?)\\} *?(.*?) *?\\{(.*?)\\} *?\\{(.*?)\\}");
                Matcher m = p2.matcher(e.docs());
                if (!m.find()) continue;
                String name = e.getName();
                String description = m.group(2).trim();
                String prefilter = DocGen.PrefilterData.Get(m.group(1).split("\\|"), DocGen.MarkupType.MARKDOWN);
                String eventData = DocGen.EventData.Get(m.group(3).split("\\|"), DocGen.MarkupType.MARKDOWN);
                String mutability = DocGen.MutabilityData.Get(m.group(4).split("\\|"), DocGen.MarkupType.MARKDOWN);
                fdocs.append("### ").append(ExtensionDocGen.markdownEscape(name)).append(NL);
                fdocs.append(description).append(NL);
                fdocs.append("#### Prefilters").append(NL).append(prefilter).append(NL);
                fdocs.append("#### Event Data").append(NL).append(eventData).append(NL);
                fdocs.append("#### Mutable Fields").append(NL).append(mutability).append(NL);
            }
        }
        outputStream2.write(fdocs.toString().getBytes("UTF-8"));
    }

    private static String convertWiki(String input) {
        String output = input;
        Matcher m = WIKI_LINK.matcher(input);
        if (m.find()) {
            output = m.replaceAll("[$2]($1)");
        }
        return output;
    }

    private static String markdownEscape(String input) {
        return input.replace("*", "\\*").replace("_", "\\_");
    }
}

