/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.asm;

import com.laytonsmith.core.asm.AsmCommonLibTemplates;
import com.laytonsmith.core.asm.IRBuilder;
import com.laytonsmith.core.asm.IRData;
import com.laytonsmith.core.asm.IRDataBuilder;
import com.laytonsmith.core.asm.IRType;
import com.laytonsmith.core.asm.LLVMEnvironment;
import com.laytonsmith.core.constructs.CDouble;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.natives.interfaces.Mixed;

public final class LLVMPlatformResolver {
    private LLVMPlatformResolver() {
    }

    public static IRData outputConstant(IRBuilder builder, Mixed c, Environment env) {
        if (c == null) {
            throw new NullPointerException("Unexpected null value");
        }
        if (c instanceof CInt) {
            CInt ci = (CInt)c;
            return IRDataBuilder.asConstant(IRType.INTEGER64, Long.toString(ci.getInt()));
        }
        if (c instanceof CDouble) {
            CDouble cd2 = (CDouble)c;
            long bits = Double.doubleToRawLongBits(cd2.getDouble());
            return IRDataBuilder.asConstant(IRType.DOUBLE, "0x" + Long.toHexString(bits));
        }
        if (c instanceof CString) {
            LLVMEnvironment e = env.getEnv(LLVMEnvironment.class);
            e.addGlobalDeclaration(AsmCommonLibTemplates.LLVM_MEMCPY_P0I8_P0I8_I64, env);
            String output = e.getOrPutStringConstant(c.val());
            int length2 = c.val().length() + 1;
            int alloca = e.getNewLocalVariableReference(IRType.OTHER);
            int bitcast = e.getNewLocalVariableReference(IRType.OTHER);
            int gep = e.getNewLocalVariableReference(IRType.STRING);
            builder.appendLine(c.getTarget(), "%" + alloca + " = alloca [" + length2 + " x i8]");
            builder.appendLine(c.getTarget(), "%" + bitcast + " = bitcast [" + length2 + " x i8]* %" + alloca + " to i8*");
            builder.appendLine(c.getTarget(), "call void @llvm.memcpy.p0i8.p0i8.i64(i8* %" + bitcast + ", i8* getelementptr inbounds ([" + length2 + " x i8], [" + length2 + " x i8]* @" + output + ", i32 0, i32 0), i64 " + length2 + ", i1 false)");
            builder.appendLine(c.getTarget(), "%" + gep + " = getelementptr inbounds [" + length2 + " x i8], [" + length2 + " x i8]* %" + alloca + ", i64 0, i64 0");
            return IRDataBuilder.setReturnVariable(gep, IRType.STRING);
        }
        throw new UnsupportedOperationException("Unsupported data type " + c.typeof().getName());
    }
}

