/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.exceptions;

import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public class StackTraceManager {
    private final Stack<ConfigRuntimeException.StackTraceElement> elements = new Stack();

    public void addStackTraceElement(ConfigRuntimeException.StackTraceElement element) {
        this.elements.add(element);
    }

    public void popStackTraceElement() {
        this.elements.pop();
    }

    public List<ConfigRuntimeException.StackTraceElement> getCurrentStackTrace() {
        ArrayList<ConfigRuntimeException.StackTraceElement> l = new ArrayList<ConfigRuntimeException.StackTraceElement>(this.elements);
        Collections.reverse(l);
        return l;
    }

    public boolean isStackEmpty() {
        return this.elements.isEmpty();
    }

    public boolean isStackSingle() {
        return this.elements.size() == 1;
    }

    public void setCurrentTarget(Target target) {
        if (!this.isStackEmpty()) {
            this.elements.peek().setDefinedAt(target);
        }
    }
}

