/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.taskmanager;

import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.annotations.taskhandler;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.taskmanager.TaskState;
import com.laytonsmith.core.taskmanager.TaskStateChangeListener;
import com.laytonsmith.core.taskmanager.TaskType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class TaskHandler {
    private final Set<TaskStateChangeListener> stateChangeListeners = new HashSet<TaskStateChangeListener>();
    private final taskhandler annotation;
    private TaskState state = TaskState.REGISTERED;
    private TaskType type;
    private int id;
    private Target target;

    protected TaskHandler(TaskType type, int id, Target target) {
        this.annotation = this.getClass().getAnnotation(taskhandler.class);
        if (this.annotation == null) {
            throw new RuntimeException("All instances of TaskHandler must be tagged with the @taskhandler");
        }
        this.type = type;
        this.id = id;
        this.target = target;
    }

    public void addStateChangeListener(TaskStateChangeListener listener) {
        this.stateChangeListeners.add(listener);
    }

    public void removeStateChangeListener(TaskStateChangeListener listener) {
        this.stateChangeListeners.remove(listener);
    }

    public synchronized void changeState(TaskState changeTo) {
        TaskState old = this.getState();
        this.state = changeTo;
        for (TaskStateChangeListener listener : this.stateChangeListeners) {
            listener.taskStateChanged(old, this);
        }
    }

    public final TaskState getState() {
        return this.state;
    }

    public final String[] getProperties() {
        return this.annotation.properties();
    }

    public final Map<String, Object> getPropertyData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (String prop : this.getProperties()) {
            data.put(prop, ReflectionUtils.get(this.getClass(), this, "get" + prop));
        }
        return data;
    }

    public final int getID() {
        return this.id;
    }

    public final TaskType getType() {
        return this.type;
    }

    public final Target getDefinedAt() {
        return this.target;
    }

    public abstract void kill();
}

