/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.persistence;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.Pair;
import com.laytonsmith.annotations.datasource;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.persistence.DataSource;
import com.laytonsmith.persistence.DataSourceException;
import com.laytonsmith.persistence.DataSourceModel;
import com.laytonsmith.persistence.StringSerializableDataSource;
import com.laytonsmith.persistence.io.ConnectionMixinFactory;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Properties;

@datasource(value="ini")
public class INIDataSource
extends StringSerializableDataSource {
    private INIDataSource() {
    }

    public INIDataSource(URI uri, ConnectionMixinFactory.ConnectionMixinOptions options) throws DataSourceException {
        super(uri, options);
    }

    @Override
    protected void populateModel(String data) throws DataSourceException {
        Properties props = new Properties();
        try {
            props.load(new StringReader(data));
        }
        catch (IOException ex) {
            throw new DataSourceException(null, ex);
        }
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        for (String key : props.stringPropertyNames()) {
            list.add(new Pair<String, String>(key, props.getProperty(key)));
        }
        this.model = new DataSourceModel(list);
    }

    @Override
    protected String serializeModel() {
        StringBuilder b = new StringBuilder();
        for (String[] key : this.model.keySet()) {
            b.append(StringUtils.Join(key, ".")).append("=").append(this.model.get(key)).append("\n");
        }
        return b.toString();
    }

    @Override
    public EnumSet<DataSource.DataSourceModifier> implicitModifiers() {
        return null;
    }

    @Override
    public EnumSet<DataSource.DataSourceModifier> invalidModifiers() {
        return EnumSet.of(DataSource.DataSourceModifier.PRETTYPRINT);
    }

    @Override
    public String docs() {
        return "INI {ini:///path/to/ini/file.ini} This type stores data in plain text, in a ini style. All the pros and cons of yml apply here, but instead of using the yml style to store the data, values are stored with key=value\\n signatures. Pretty print is not supported, since whitespace is relevant to the meta information.";
    }

    @Override
    public MSVersion since() {
        return MSVersion.V3_3_1;
    }
}

